/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.thickness.inference.visitor;

import java.io.IOException;
import java.util.Iterator;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.RealType;
import org.janelia.thickness.inference.visitor.CSVVisitor;

public class LUTVisitor
extends CSVVisitor {
    public LUTVisitor(String basePath, String relativeFilePattern, String separator) {
        super(basePath, relativeFilePattern, separator);
    }

    @Override
    public <T extends RealType<T>> void act(int iteration, RandomAccessibleInterval<T> matrix, RandomAccessibleInterval<T> scaledMatrix, double[] lut, int[] permutation, int[] inversePermutation, double[] scalingFactors, RandomAccessibleInterval<double[]> estimatedFit) {
        try {
            String path = this.fileDir(iteration);
            this.createParentDirectory(path);
            this.write(new CSVVisitor.IndexedIterable<Double>(this.separator, new DoubleArrayIterable(lut)), path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public class DoubleArrayIterable
    implements Iterable<Double> {
        private final double[] data;

        DoubleArrayIterable(double[] data) {
            this.data = data;
        }

        @Override
        public Iterator<Double> iterator() {
            return new Iterator<Double>(){
                int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < DoubleArrayIterable.this.data.length;
                }

                @Override
                public Double next() {
                    return DoubleArrayIterable.this.data[this.i++];
                }
            };
        }
    }
}

