/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.trakem2.transform;

import ij.process.ImageProcessor;
import java.awt.Rectangle;
import mpicbg.trakem2.transform.TransformMesh;
import mpicbg.trakem2.transform.TransformMeshMappingWithMasks;

public class TransformMeshMapping
extends TransformMeshMappingWithMasks<TransformMesh> {
    public TransformMeshMapping(TransformMesh t) {
        super(t);
    }

    public final ImageProcessor createMappedImage(ImageProcessor source) {
        Rectangle boundingBox = ((TransformMesh)this.transform).getBoundingBox();
        ImageProcessor target = source.createProcessor(boundingBox.width, boundingBox.height);
        this.map(source, target);
        return target;
    }

    public final ImageProcessor createMappedImageInterpolated(ImageProcessor source) {
        Rectangle boundingBox = ((TransformMesh)this.transform).getBoundingBox();
        ImageProcessor target = source.createProcessor(boundingBox.width, boundingBox.height);
        source.setInterpolationMethod(1);
        this.mapInterpolated(source, target);
        return target;
    }

    public final ImageProcessor createInverseMappedImage(ImageProcessor source) {
        ImageProcessor target = source.createProcessor((int)((TransformMesh)this.transform).getWidth(), (int)((TransformMesh)this.transform).getHeight());
        this.mapInverse(source, target);
        return target;
    }

    public final ImageProcessor createInverseMappedImageInterpolated(ImageProcessor source) {
        ImageProcessor target = source.createProcessor((int)((TransformMesh)this.transform).getWidth(), (int)((TransformMesh)this.transform).getHeight());
        this.mapInverseInterpolated(source, target);
        return target;
    }

    public final TransformMeshMappingWithMasks.ImageProcessorWithMasks createMappedMaskedImage(ImageProcessor source, ImageProcessor mask) {
        Rectangle boundingBox = ((TransformMesh)this.transform).getBoundingBox();
        ImageProcessor targetMask = mask == null ? null : mask.createProcessor(boundingBox.width, boundingBox.height);
        TransformMeshMappingWithMasks.ImageProcessorWithMasks target = new TransformMeshMappingWithMasks.ImageProcessorWithMasks(source.createProcessor(boundingBox.width, boundingBox.height), targetMask, null);
        this.map(new TransformMeshMappingWithMasks.ImageProcessorWithMasks(source, mask, null), target);
        return target;
    }

    public final TransformMeshMappingWithMasks.ImageProcessorWithMasks createMappedMaskedImageInterpolated(ImageProcessor source, ImageProcessor mask) {
        Rectangle boundingBox = ((TransformMesh)this.transform).getBoundingBox();
        ImageProcessor targetMask = mask == null ? null : mask.createProcessor(boundingBox.width, boundingBox.height);
        TransformMeshMappingWithMasks.ImageProcessorWithMasks target = new TransformMeshMappingWithMasks.ImageProcessorWithMasks(source.createProcessor(boundingBox.width, boundingBox.height), targetMask, null);
        this.mapInterpolated(new TransformMeshMappingWithMasks.ImageProcessorWithMasks(source, mask, null), target);
        return target;
    }
}

