/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.correlation;

import mpicbg.imglib.algorithm.Algorithm;
import mpicbg.imglib.algorithm.MultiThreaded;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.numeric.RealType;

public class CrossCorrelation<S extends RealType<S>, T extends RealType<T>>
implements Algorithm,
MultiThreaded {
    final Image<S> image1;
    final Image<T> image2;
    double R = 0.0;
    int numThreads;

    public static <S extends RealType<S>, T extends RealType<T>> double correlate(Image<S> img1, Image<T> img2) {
        CrossCorrelation<S, T> cc = new CrossCorrelation<S, T>(img1, img2);
        cc.process();
        return cc.getR();
    }

    public CrossCorrelation(Image<S> image1, Image<T> image2) {
        this.image1 = image1;
        this.image2 = image2;
        this.setNumThreads();
    }

    public double getR() {
        return this.R;
    }

    @Override
    public boolean checkInput() {
        return true;
    }

    @Override
    public boolean process() {
        double avg1 = this.computeAvg(this.image1);
        double avg2 = this.computeAvg(this.image2);
        boolean isCompatible = this.image1.getContainer().compareStorageContainerCompatibility(this.image2.getContainer());
        this.R = isCompatible ? this.computeSimple(avg1, avg2) : this.computeAdvancedSum(avg1, avg2);
        return true;
    }

    protected <R extends RealType<R>> double computeAvg(Image<R> image) {
        double avg = 0.0;
        for (RealType type : image) {
            avg += type.getRealDouble();
        }
        return avg / (double)image.getNumPixels();
    }

    protected double computeSimple(double avg1, double avg2) {
        Cursor<S> cursor1 = this.image1.createCursor();
        Cursor<T> cursor2 = this.image2.createCursor();
        double var1 = 0.0;
        double var2 = 0.0;
        double coVar = 0.0;
        while (cursor1.hasNext()) {
            cursor1.fwd();
            cursor2.fwd();
            double pixel1 = ((RealType)cursor1.getType()).getRealDouble();
            double pixel2 = ((RealType)cursor2.getType()).getRealDouble();
            double dist1 = pixel1 - avg1;
            double dist2 = pixel2 - avg2;
            coVar += dist1 * dist2;
            var1 += dist1 * dist1;
            var2 += dist2 * dist2;
        }
        cursor1.close();
        cursor2.close();
        coVar /= (double)this.image1.getNumPixels();
        double stDev1 = Math.sqrt(var1 /= (double)this.image1.getNumPixels());
        double stDev2 = Math.sqrt(var2 /= (double)this.image1.getNumPixels());
        if (stDev1 == 0.0 || stDev2 == 0.0) {
            if (stDev1 == stDev2 && avg1 == avg2) {
                return 1.0;
            }
            return 0.0;
        }
        return coVar / (stDev1 * stDev2);
    }

    protected double computeAdvancedSum(double avg1, double avg2) {
        LocalizableByDimCursor<S> cursor1 = this.image1.createLocalizableByDimCursor();
        LocalizableCursor<T> cursor2 = this.image2.createLocalizableCursor();
        double var1 = 0.0;
        double var2 = 0.0;
        double coVar = 0.0;
        while (cursor2.hasNext()) {
            cursor2.fwd();
            cursor1.setPosition(cursor2);
            double pixel1 = ((RealType)cursor1.getType()).getRealDouble();
            double pixel2 = ((RealType)cursor2.getType()).getRealDouble();
            double dist1 = pixel1 - avg1;
            double dist2 = pixel2 - avg2;
            coVar += dist1 * dist2;
            var1 += dist1 * dist1;
            var2 += dist2 * dist2;
        }
        cursor1.close();
        cursor2.close();
        coVar /= (double)this.image1.getNumPixels();
        double stDev1 = Math.sqrt(var1 /= (double)this.image1.getNumPixels());
        double stDev2 = Math.sqrt(var2 /= (double)this.image1.getNumPixels());
        if (stDev1 == 0.0 || stDev2 == 0.0) {
            if (stDev1 == stDev2 && avg1 == avg2) {
                return 1.0;
            }
            return 0.0;
        }
        return coVar / (stDev1 * stDev2);
    }

    @Override
    public String getErrorMessage() {
        return null;
    }

    @Override
    public void setNumThreads() {
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    @Override
    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    @Override
    public int getNumThreads() {
        return this.numThreads;
    }
}

