/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.integral;

import mpicbg.imglib.algorithm.integral.IntegralImage;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.function.Converter;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.numeric.NumericType;
import mpicbg.imglib.type.numeric.integer.LongType;

public class IntegralImageLong<R extends NumericType<R>>
extends IntegralImage<R, LongType> {
    public IntegralImageLong(Image<R> img, Converter<R, LongType> converter) {
        super(img, new LongType(), converter);
    }

    @Override
    protected void integrateLineDim0(Converter<R, LongType> converter, LocalizableByDimCursor<R> cursorIn, LocalizableByDimCursor<LongType> cursorOut, LongType sum, LongType tmpVar, int size) {
        converter.convert(cursorIn.getType(), sum);
        ((LongType)cursorOut.getType()).set(sum);
        long sum2 = sum.get();
        for (int i = 2; i < size; ++i) {
            cursorIn.fwd(0);
            cursorOut.fwd(0);
            converter.convert(cursorIn.getType(), tmpVar);
            ((LongType)cursorOut.getType()).set(sum2 += tmpVar.get());
        }
    }

    @Override
    protected void integrateLine(int d, LocalizableByDimCursor<LongType> cursor, LongType sum, int size) {
        long sum2 = ((LongType)cursor.getType()).get();
        for (int i = 2; i < size; ++i) {
            cursor.fwd(d);
            LongType type = (LongType)cursor.getType();
            type.set(sum2 += type.get());
        }
    }
}

