/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.constant;

import mpicbg.imglib.container.constant.ConstantContainer;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.cursor.constant.ConstantCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;

public class ConstantLocalizableCursor<T extends Type<T>>
extends ConstantCursor<T>
implements LocalizableCursor<T> {
    protected final int[] position;
    protected final int[] dimensions;

    public ConstantLocalizableCursor(ConstantContainer<T> container, Image<T> image, T type) {
        super(container, image, type);
        this.dimensions = image.getDimensions();
        this.position = new int[this.numDimensions];
        this.reset();
    }

    @Override
    public void fwd() {
        ++this.i;
        for (int d = 0; d < this.numDimensions; ++d) {
            if (this.position[d] >= this.dimensions[d] - 1) continue;
            int n = d;
            this.position[n] = this.position[n] + 1;
            for (int e = 0; e < d; ++e) {
                this.position[e] = 0;
            }
            return;
        }
    }

    @Override
    public void fwd(long steps) {
        for (long j = 0L; j < steps; ++j) {
            this.fwd();
        }
    }

    @Override
    public void reset() {
        this.i = -1L;
        this.position[0] = -1;
        for (int d = 1; d < this.numDimensions; ++d) {
            this.position[d] = 0;
        }
    }

    @Override
    public void getPosition(int[] position) {
        for (int d = 0; d < this.numDimensions; ++d) {
            position[d] = this.position[d];
        }
    }

    @Override
    public int[] getPosition() {
        return (int[])this.position.clone();
    }

    @Override
    public int getPosition(int dim) {
        return this.position[dim];
    }

    @Override
    public String getPositionAsString() {
        String pos = "(" + this.position[0];
        for (int d = 1; d < this.numDimensions; ++d) {
            pos = pos + ", " + this.position[d];
        }
        pos = pos + ")";
        return pos;
    }

    public String toString() {
        return this.getPositionAsString() + " = " + this.getType();
    }
}

