/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose.builder;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apposed.appose.Builder;
import org.apposed.appose.Environment;
import org.apposed.appose.builder.BaseBuilder;
import org.apposed.appose.util.Environments;

public final class SimpleBuilder
extends BaseBuilder<SimpleBuilder> {
    private final List<String> customBinPaths = new ArrayList<String>();

    public SimpleBuilder binPaths(String ... paths) {
        return this.binPaths(Arrays.asList(paths));
    }

    public SimpleBuilder binPaths(List<String> paths) {
        this.customBinPaths.addAll(paths);
        return this;
    }

    public SimpleBuilder appendSystemPath() {
        this.customBinPaths.addAll(Environments.systemPath());
        return this;
    }

    public SimpleBuilder inheritRunningJava() {
        String javaHome = System.getProperty("java.home");
        if (javaHome != null) {
            File javaHomeBin = new File(javaHome, "bin");
            if (javaHomeBin.isDirectory()) {
                this.customBinPaths.add(0, javaHomeBin.getAbsolutePath());
            }
            this.envVars.put("JAVA_HOME", javaHome);
        }
        return this;
    }

    @Override
    public String name() {
        return "custom";
    }

    @Override
    public Environment build() throws IOException {
        File base = this.envDir();
        if (base == null) {
            base = new File(".");
        }
        if (!base.exists() && !base.mkdirs()) {
            throw new IOException("Failed to create base directory: " + base);
        }
        final String basePath = base.getAbsolutePath();
        final ArrayList launchArgs = new ArrayList();
        final ArrayList<String> binPaths = new ArrayList<String>();
        File binDir = new File(base, "bin");
        if (binDir.isDirectory()) {
            binPaths.add(binDir.getAbsolutePath());
        }
        binPaths.addAll(this.customBinPaths);
        final HashMap environmentVars = new HashMap(this.envVars);
        return new Environment(){

            @Override
            public String base() {
                return basePath;
            }

            @Override
            public List<String> binPaths() {
                return binPaths;
            }

            @Override
            public List<String> launchArgs() {
                return launchArgs;
            }

            @Override
            public Map<String, String> envVars() {
                return environmentVars;
            }

            @Override
            public Builder<?> builder() {
                return SimpleBuilder.this;
            }
        };
    }

    @Override
    public Environment rebuild() throws IOException {
        throw new UnsupportedOperationException("SimpleBuilder does not support rebuild(). Custom environments do not manage packages and cannot be rebuilt.");
    }

    @Override
    public SimpleBuilder name(String envName) {
        throw new UnsupportedOperationException("SimpleBuilder does not support named environments. Use base(File) to specify the working directory.");
    }

    @Override
    public SimpleBuilder channels(List<String> channels) {
        throw new UnsupportedOperationException("SimpleBuilder does not support package channels. It uses existing executables without package management.");
    }

    @Override
    protected File envDir() {
        return this.envDir != null ? this.envDir : new File(".");
    }
}

