/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.function.Predicate;

public final class Plugins {
    private Plugins() {
    }

    public static <T> List<T> discover(Class<T> iface, Comparator<T> comparator) {
        ServiceLoader<Object> loader = ServiceLoader.load(iface);
        ArrayList<T> singletons = new ArrayList<T>();
        loader.forEach(singletons::add);
        if (comparator != null) {
            singletons.sort(comparator);
        }
        return singletons;
    }

    public static <E extends Throwable, T> T find(Collection<T> plugins, Predicate<T> condition) {
        return plugins.stream().filter(condition).findFirst().orElse(null);
    }

    public static <T, U> U create(Class<T> iface, Function<T, U> creator) {
        ServiceLoader<T> loader = ServiceLoader.load(iface);
        for (T factory : loader) {
            U result = creator.apply(factory);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

