/*
 * Decompiled with CFR 0.152.
 */
package fiji.statistics;

import ij.gui.Roi;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Rectangle;

public class RoiStatistics {
    protected int count;
    protected float cumulative;
    protected float cumulativeX;
    protected float cumulativeY;
    protected float min;
    protected float max;
    protected final Accumulator accumulator;

    public RoiStatistics(Roi roi) {
        Rectangle bounds = roi.getBounds();
        ImageProcessor mask = roi.getMask();
        this.accumulator = mask == null ? new RectangleAccumulator(bounds) : new GenericAccumulator(bounds.x, bounds.y, (ByteProcessor)mask);
    }

    public void init(ImageProcessor ip) {
        this.accumulate(this.getAccessor(ip));
    }

    protected Accessor getAccessor(ImageProcessor ip) {
        if (ip instanceof ByteProcessor) {
            return new ByteAccessor((ByteProcessor)ip);
        }
        if (ip instanceof ShortProcessor) {
            return new ShortAccessor((ShortProcessor)ip);
        }
        if (ip instanceof FloatProcessor) {
            return new FloatAccessor((FloatProcessor)ip);
        }
        if (ip instanceof ColorProcessor) {
            return new RGBAccessor((ColorProcessor)ip);
        }
        throw new RuntimeException("No accessor available for " + ip);
    }

    public void iterate(ImageProcessor ip, PixelHandler handler) {
        this.accumulator.iterate(this.getAccessor(ip), handler);
    }

    protected void accumulate(Accessor accessor) {
        this.count = 0;
        this.cumulativeY = 0.0f;
        this.cumulativeX = 0.0f;
        this.cumulative = 0.0f;
        this.min = Float.MAX_VALUE;
        this.max = -3.4028235E38f;
        this.accumulator.iterate(accessor, new PixelHandler(){

            @Override
            public final void handle(int x, int y, float value) {
                RoiStatistics.this.cumulative += value;
                RoiStatistics.this.cumulativeX += (float)x * value;
                RoiStatistics.this.cumulativeY += (float)y * value;
                ++RoiStatistics.this.count;
                if (RoiStatistics.this.min > value) {
                    RoiStatistics.this.min = value;
                }
                if (RoiStatistics.this.max < value) {
                    RoiStatistics.this.max = value;
                }
            }
        });
    }

    public int getCount() {
        return this.count;
    }

    public float getCumulative() {
        return this.cumulative;
    }

    public float getAverage() {
        return this.count == 0 ? 0.0f : this.cumulative / (float)this.count;
    }

    public float getCentroidX() {
        return this.cumulative == 0.0f ? 0.0f : this.cumulativeX / this.cumulative;
    }

    public float getCentroidY() {
        return this.cumulative == 0.0f ? 0.0f : this.cumulativeY / this.cumulative;
    }

    public float getAverage(ImageProcessor ip) {
        this.init(ip);
        return this.getAverage();
    }

    public float getMin() {
        return this.min;
    }

    public float getMax() {
        return this.max;
    }

    protected static class RGBAccessor
    implements Accessor {
        protected ColorProcessor ip;

        public RGBAccessor(ColorProcessor ip) {
            this.ip = ip;
        }

        @Override
        public final int getWidth() {
            return this.ip.getWidth();
        }

        @Override
        public final int getHeight() {
            return this.ip.getHeight();
        }

        @Override
        public final float getf(int x, int y) {
            return this.ip.getf(x, y);
        }
    }

    protected static class FloatAccessor
    implements Accessor {
        protected int w;
        protected int h;
        protected float[] pixels;

        public FloatAccessor(FloatProcessor ip) {
            this.w = ip.getWidth();
            this.h = ip.getHeight();
            this.pixels = (float[])ip.getPixels();
        }

        @Override
        public final int getWidth() {
            return this.w;
        }

        @Override
        public final int getHeight() {
            return this.h;
        }

        @Override
        public final float getf(int x, int y) {
            return this.pixels[x + this.w * y];
        }
    }

    protected static class ShortAccessor
    implements Accessor {
        protected int w;
        protected int h;
        protected short[] pixels;

        public ShortAccessor(ShortProcessor ip) {
            this.w = ip.getWidth();
            this.h = ip.getHeight();
            this.pixels = (short[])ip.getPixels();
        }

        @Override
        public final int getWidth() {
            return this.w;
        }

        @Override
        public final int getHeight() {
            return this.h;
        }

        @Override
        public final float getf(int x, int y) {
            return this.pixels[x + this.w * y] & 0xFFFF;
        }
    }

    protected static class ByteAccessor
    implements Accessor {
        protected int w;
        protected int h;
        protected byte[] pixels;

        public ByteAccessor(ByteProcessor ip) {
            this.w = ip.getWidth();
            this.h = ip.getHeight();
            this.pixels = (byte[])ip.getPixels();
        }

        @Override
        public final int getWidth() {
            return this.w;
        }

        @Override
        public final int getHeight() {
            return this.h;
        }

        @Override
        public final float getf(int x, int y) {
            return this.pixels[x + this.w * y] & 0xFF;
        }
    }

    protected static interface Accessor {
        public int getWidth();

        public int getHeight();

        public float getf(int var1, int var2);
    }

    protected class GenericAccumulator
    implements Accumulator {
        protected int x;
        protected int y;
        protected int width;
        protected int height;
        protected byte[] pixels;

        public GenericAccumulator(int x, int y, ByteProcessor mask) {
            this.x = x;
            this.y = y;
            this.width = mask.getWidth();
            this.height = mask.getHeight();
            this.pixels = (byte[])mask.getPixels();
        }

        @Override
        public final void iterate(Accessor accessor, PixelHandler handler) {
            int width = Math.min(this.width, accessor.getWidth() - this.x);
            int height = Math.min(this.height, accessor.getHeight() - this.y);
            for (int j = Math.max(0, -this.y); j < height; ++j) {
                for (int i = Math.max(0, -this.x); i < width; ++i) {
                    if (this.pixels[i + width * j] == 0) continue;
                    handler.handle(this.x + i, this.y + i, accessor.getf(this.x + i, this.y + j));
                }
            }
        }
    }

    protected class RectangleAccumulator
    implements Accumulator {
        protected int x0;
        protected int y0;
        protected int x1;
        protected int y1;

        public RectangleAccumulator(Rectangle rect) {
            this.x0 = rect.x;
            this.y0 = rect.y;
            this.x1 = this.x0 + rect.width;
            this.y1 = this.y0 + rect.height;
        }

        @Override
        public final void iterate(Accessor accessor, PixelHandler handler) {
            for (int y = this.y0; y < this.y1; ++y) {
                for (int x = this.x0; x < this.x1; ++x) {
                    handler.handle(x, y, accessor.getf(x, y));
                }
            }
        }
    }

    protected static interface Accumulator {
        public void iterate(Accessor var1, PixelHandler var2);
    }

    public static interface PixelHandler {
        public void handle(int var1, int var2, float var3);
    }
}

