/*
 * Decompiled with CFR 0.152.
 */
package fiji.util;

import java.lang.reflect.Array;
import java.util.Iterator;

public abstract class ArrayBase<ArrayType, BaseType>
implements Iterable<BaseType> {
    protected Class type;
    protected int actualSize;
    protected int allocated;
    protected int maximumGrowth;

    public ArrayBase(int size, int growth, Class type) {
        this.type = type;
        Object array = Array.newInstance(type, size);
        this.allocated = size;
        this.maximumGrowth = growth;
        this.setArray(array);
    }

    public ArrayBase(int size, Class type) {
        this(size, Integer.MAX_VALUE, type);
    }

    protected abstract ArrayType getArray();

    protected abstract void setArray(ArrayType var1);

    protected abstract BaseType valueOf(int var1);

    public void ensureCapacity(int required) {
        if (required <= this.actualSize) {
            return;
        }
        if (required <= this.allocated) {
            this.actualSize = required;
            return;
        }
        ArrayType base = this.getArray();
        int size = Math.max(required, this.allocated + Math.min(this.allocated, this.maximumGrowth));
        Object grown = Array.newInstance(this.type, size);
        if (this.actualSize > 0) {
            System.arraycopy(base, 0, grown, 0, this.actualSize);
        }
        this.allocated = size;
        this.actualSize = required;
        this.setArray(grown);
    }

    protected int getAddIndex() {
        int result = this.actualSize;
        this.ensureCapacity(this.actualSize + 1);
        return result;
    }

    protected void makeInsertSpace(int index) {
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException("Invalid index value");
        }
        this.ensureCapacity(this.actualSize + 1);
        if (index < this.actualSize) {
            ArrayType array = this.getArray();
            System.arraycopy(array, index, array, index + 1, this.actualSize - index - 1);
        }
    }

    public void remove(int index) {
        if (index < 0 || index >= this.actualSize) {
            throw new ArrayIndexOutOfBoundsException("Invalid index value: " + index);
        }
        if (index < --this.actualSize) {
            ArrayType array = this.getArray();
            System.arraycopy(array, index + 1, array, index, this.actualSize - index);
        }
    }

    public void clear() {
        this.setSize(0);
    }

    public int size() {
        return this.actualSize;
    }

    public void setSize(int count) {
        if (count > this.allocated) {
            this.ensureCapacity(count);
        }
        this.actualSize = count;
    }

    public ArrayType buildArray() {
        Object copy = Array.newInstance(this.type, this.actualSize);
        System.arraycopy(this.getArray(), 0, copy, 0, this.actualSize);
        return (ArrayType)copy;
    }

    @Override
    public Iterator<BaseType> iterator() {
        return new Iterator<BaseType>(){
            int counter = 0;

            @Override
            public boolean hasNext() {
                return this.counter < ArrayBase.this.actualSize;
            }

            @Override
            public BaseType next() {
                return ArrayBase.this.valueOf(this.counter++);
            }

            @Override
            public void remove() {
                ArrayBase.this.remove(--this.counter);
            }
        };
    }
}

