/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.viewer.plot.jfreechart;

import java.awt.Paint;
import java.awt.Stroke;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.scijava.plot.LineStyle;
import org.scijava.plot.MarkerStyle;
import org.scijava.plot.SeriesStyle;
import org.scijava.ui.awt.AWTColors;
import org.scijava.ui.swing.viewer.plot.jfreechart.AwtLineStyles;
import org.scijava.ui.swing.viewer.plot.jfreechart.AwtMarkerStyles;
import org.scijava.util.ColorRGB;

class RendererModifier {
    final AbstractRenderer renderer;

    private RendererModifier(AbstractRenderer renderer) {
        this.renderer = renderer;
    }

    public static RendererModifier wrap(AbstractRenderer renderer) {
        return new RendererModifier(renderer);
    }

    public void setSeriesStyle(int index, SeriesStyle style) {
        if (style == null) {
            return;
        }
        this.setSeriesColor(index, style.getColor());
        this.setSeriesLineStyle(index, style.getLineStyle());
        this.setSeriesMarkerStyle(index, style.getMarkerStyle());
    }

    public void setSeriesColor(int index, ColorRGB color) {
        if (color == null) {
            return;
        }
        this.renderer.setSeriesPaint(index, (Paint)AWTColors.getColor((ColorRGB)color));
    }

    public void setSeriesLineStyle(int index, LineStyle style) {
        AwtLineStyles line = AwtLineStyles.getInstance(style);
        this.setSeriesLinesVisible(index, line.isVisible());
        this.renderer.setSeriesStroke(index, (Stroke)line.getStroke());
    }

    public void setSeriesMarkerStyle(int index, MarkerStyle style) {
        AwtMarkerStyles marker = AwtMarkerStyles.getInstance(style);
        this.setSeriesShapesVisible(index, marker.isVisible());
        this.setSeriesShapesFilled(index, marker.isFilled());
        this.renderer.setSeriesShape(index, marker.getShape());
    }

    private void setSeriesLinesVisible(int index, boolean visible) {
        if (this.renderer instanceof LineAndShapeRenderer) {
            ((LineAndShapeRenderer)this.renderer).setSeriesLinesVisible(index, visible);
        }
        if (this.renderer instanceof XYLineAndShapeRenderer) {
            ((XYLineAndShapeRenderer)this.renderer).setSeriesLinesVisible(index, visible);
        }
    }

    private void setSeriesShapesVisible(int index, boolean visible) {
        if (this.renderer instanceof LineAndShapeRenderer) {
            ((LineAndShapeRenderer)this.renderer).setSeriesShapesVisible(index, visible);
        }
        if (this.renderer instanceof XYLineAndShapeRenderer) {
            ((XYLineAndShapeRenderer)this.renderer).setSeriesShapesVisible(index, visible);
        }
    }

    private void setSeriesShapesFilled(int index, boolean filled) {
        if (this.renderer instanceof LineAndShapeRenderer) {
            ((LineAndShapeRenderer)this.renderer).setSeriesShapesFilled(index, filled);
        }
        if (this.renderer instanceof XYLineAndShapeRenderer) {
            ((XYLineAndShapeRenderer)this.renderer).setSeriesShapesFilled(index, filled);
        }
    }
}

