/*
 * Decompiled with CFR 0.152.
 */
package VolumeJ;

import VolumeJ.VJAlphaColor;
import VolumeJ.VJClassifier;
import VolumeJ.VJGradient;
import VolumeJ.VJValue;
import VolumeJ.VJValueHSB;
import java.awt.Color;

public class VJClassifierLevoy
extends VJClassifier {
    protected float[] opacityTable;
    protected byte[] lut;
    protected double threshold;
    protected double width;
    protected int maxIntensity;
    protected int maskMagnitude;
    protected int maskIndex;
    protected float fractionMagnitude;
    protected int nrIndexBits;
    protected int nrMagnitudeBits;
    protected int nrIntensityBits;
    protected int maskIntensity;

    public VJClassifierLevoy() {
        this(8, 8, 8);
        this.description = "Gradient + index(spectrum)";
    }

    public VJClassifierLevoy(int nrIntensityBits, int nrMagnitudeBits, int nrIndexBits) {
        this.nrMagnitudeBits = nrMagnitudeBits;
        this.nrIntensityBits = nrIntensityBits;
        this.nrIndexBits = nrIndexBits;
        this.maxIntensity = (int)Math.pow(2.0, nrIntensityBits);
        this.maskIntensity = (int)Math.pow(2.0, nrIntensityBits) - 1;
        int maxMagnitude = (int)Math.sqrt(3.0 * Math.pow(this.maxIntensity, 2.0));
        this.fractionMagnitude = (float)Math.pow(2.0, nrMagnitudeBits) / (float)maxMagnitude;
        this.maskMagnitude = (int)Math.pow(2.0, nrMagnitudeBits) - 1;
        this.opacityTable = new float[(int)Math.pow(2.0, 16.0)];
        if (nrIndexBits > 0) {
            this.defaultLUT();
        }
    }

    public void setWidth(double width) {
        this.width = width;
    }

    @Override
    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    @Override
    public boolean visible(VJValue v) {
        return true;
    }

    @Override
    public int does() {
        return 4;
    }

    @Override
    public boolean hasLUT() {
        return true;
    }

    @Override
    public boolean doesIndex() {
        return true;
    }

    @Override
    public boolean doesCutouts() {
        return true;
    }

    @Override
    public String toString() {
        return this.description;
    }

    @Override
    public String toLongString() {
        return "Levoy (" + (this.does() == 4 ? "RGB" : "grays") + ") classifier. Makes voxels more opaque  the closer their intensity is to threshold (" + this.threshold + ") and the higher their surface gradient  (relative contribution set by deviation). Voxel colors determined from LUT and index volume if present.";
    }

    @Override
    public VJAlphaColor alphacolor(VJValue v, VJGradient g) {
        int igradient = (int)(g.getmag() * this.fractionMagnitude) & this.maskMagnitude;
        int entry = igradient << this.nrIntensityBits | v.intvalue;
        if (v instanceof VJValueHSB) {
            Color color = Color.getHSBColor(((VJValueHSB)v).getHue(), ((VJValueHSB)v).getSaturation(), 1.0f);
            return new VJAlphaColor((double)this.opacityTable[entry], color.getRed(), color.getGreen(), color.getBlue());
        }
        return new VJAlphaColor((double)this.opacityTable[entry], this.lut[v.index * 3 + 0] & 0xFF, this.lut[v.index * 3 + 1] & 0xFF, this.lut[v.index * 3 + 2] & 0xFF);
    }

    @Override
    public VJAlphaColor alphacolor(VJValue v) {
        int intensity = v.intvalue;
        int index = v.index;
        if (index == 0) {
            return new VJAlphaColor(1.0, intensity, intensity, intensity);
        }
        return new VJAlphaColor(1.0, this.lut[index * 3 + 0] & 0xFF, this.lut[index * 3 + 1] & 0xFF, this.lut[index * 3 + 2] & 0xFF);
    }

    public void setupOpacities(double oversampling) {
        for (int magnitude = 0; magnitude < (int)Math.pow(2.0, this.nrMagnitudeBits); ++magnitude) {
            for (int intensity = 0; intensity < this.maxIntensity; ++intensity) {
                double dfxi = magnitude << Math.min(0, 8 - this.nrMagnitudeBits);
                double uncorrectedOpacity = this.opacityCompute(dfxi, intensity, this.threshold, this.width);
                int ind = magnitude << this.nrIntensityBits | intensity;
                this.opacityTable[ind] = 1.0f - (float)Math.pow(1.0 - uncorrectedOpacity, oversampling);
            }
        }
    }

    protected void defaultLUT() {
        this.lut = new byte[(int)Math.pow(2.0, this.nrIndexBits) * 3];
        for (int index = 0; index < (int)Math.pow(2.0, this.nrIndexBits); ++index) {
            if (index == 0) {
                this.lut[index * 3 + 0] = -1;
                this.lut[index * 3 + 1] = -1;
                this.lut[index * 3 + 2] = -1;
                continue;
            }
            Color c = Color.getHSBColor((float)index / 255.0f, 1.0f, 1.0f);
            this.lut[index * 3 + 0] = (byte)c.getRed();
            this.lut[index * 3 + 1] = (byte)c.getGreen();
            this.lut[index * 3 + 2] = (byte)c.getBlue();
        }
    }

    @Override
    public boolean setLUT(byte[] reds, byte[] greens, byte[] blues) {
        this.lut = new byte[(int)Math.pow(2.0, this.nrIndexBits) * 3];
        if (this.lut.length != reds.length + greens.length + blues.length) {
            return false;
        }
        for (int index = 0; index < reds.length; ++index) {
            this.lut[index * 3 + 0] = reds[index];
            this.lut[index * 3 + 1] = greens[index];
            this.lut[index * 3 + 2] = blues[index];
        }
        return true;
    }

    protected double opacityCompute(double dfxi, double intensity, double threshold, double width) {
        double opacity = dfxi == 0.0 && intensity == threshold ? 1.0 : (dfxi > 0.0 && intensity <= threshold + width * dfxi && intensity >= threshold - width * dfxi ? 1.0 - 1.0 / width * Math.abs((threshold - intensity) / dfxi) : 0.0);
        return opacity;
    }
}

