/*
 * Decompiled with CFR 0.152.
 */
package VolumeJ;

import VolumeJ.VJUserInterface;
import bijnum.BIJmatrix;
import bijnum.BIJtransform;

public class VJMatrix {
    private float[][] m;

    public VJMatrix() {
        this.m = BIJtransform.newMatrix(3);
    }

    public VJMatrix(float[][] m) {
        this.m = m;
    }

    public VJMatrix(VJMatrix vjm) {
        this.m = BIJtransform.newMatrix(3);
        for (int i = 0; i < this.m.length; ++i) {
            for (int j = 0; j < this.m[0].length; ++j) {
                this.m[j][i] = vjm.m[j][i];
            }
        }
    }

    public static float[] newVector(float x, float y, float z) {
        float[] v = new float[]{x, y, z, 1.0f};
        return v;
    }

    public void translate(double tx, double ty, double tz) {
        this.m = BIJtransform.translate(this.m, (float)tx, (float)ty, (float)tz);
    }

    public void scale(double sx, double sy, double sz) {
        this.m = BIJtransform.scale(this.m, (float)sx, (float)sy, (float)sz);
    }

    public void rotatex(double theta) {
        this.m = BIJtransform.rotatex(this.m, (float)theta);
    }

    public void rotatey(double theta) {
        this.m = BIJtransform.rotatey(this.m, (float)theta);
    }

    public void rotatez(double theta) {
        this.m = BIJtransform.rotatez(this.m, (float)theta);
    }

    public float[] mul(float[] v) {
        float[] r = null;
        try {
            r = BIJmatrix.mul(this.m, v);
        }
        catch (Exception e) {
            VJUserInterface.error("grave error in VJMatrix" + e);
        }
        return r;
    }

    public static float[] getMin(float[][] vertex, int dimension) {
        float minv = Float.MAX_VALUE;
        int i = 0;
        for (int v = 0; v < vertex.length; ++v) {
            if (!(vertex[v][dimension] < minv)) continue;
            minv = vertex[v][dimension];
            i = v;
        }
        float[] min = new float[]{vertex[i][0], vertex[i][1], vertex[i][2], vertex[i][3]};
        return min;
    }

    public static float[] getMax(float[][] vertex, int dimension) {
        float maxv = -3.4028235E38f;
        int i = 0;
        for (int v = 0; v < vertex.length; ++v) {
            if (!(vertex[v][dimension] > maxv)) continue;
            maxv = vertex[v][dimension];
            i = v;
        }
        float[] max = new float[]{vertex[i][0], vertex[i][1], vertex[i][2], vertex[i][3]};
        return max;
    }

    public void mul(VJMatrix m0) {
        this.m = BIJmatrix.mul(m0.m, this.m);
    }

    public float[] getStepperColumn() {
        return BIJmatrix.col(this.m, 2);
    }

    public float[] getColumn(int n) {
        return BIJmatrix.col(this.m, n);
    }

    public float getOversamplingRatio() {
        float[] vs = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
        float[] os0 = this.mul(vs);
        vs[0] = 0.0f;
        vs[1] = 0.0f;
        vs[2] = 1.0f;
        vs[3] = 1.0f;
        float[] os1 = this.mul(vs);
        float distance = (float)Math.sqrt(Math.pow(os0[0] - os1[0], 2.0) + Math.pow(os0[1] - os1[1], 2.0) + Math.pow(os0[2] - os1[2], 2.0));
        return 1.0f / distance;
    }

    public void shear(double sx, double sy) {
        this.m[0][2] = (float)sx;
        this.m[1][2] = (float)sy;
    }

    public void permutation(int axis) {
        if (axis == 0) {
            this.m[0][0] = 0.0f;
            this.m[0][1] = 1.0f;
            this.m[0][2] = 0.0f;
            this.m[0][3] = 0.0f;
            this.m[1][0] = 0.0f;
            this.m[1][1] = 0.0f;
            this.m[1][2] = 1.0f;
            this.m[1][3] = 0.0f;
            this.m[2][0] = 1.0f;
            this.m[2][1] = 0.0f;
            this.m[2][2] = 0.0f;
            this.m[2][3] = 0.0f;
            this.m[3][0] = 0.0f;
            this.m[3][1] = 0.0f;
            this.m[3][2] = 0.0f;
            this.m[3][3] = 1.0f;
        } else if (axis == 1) {
            this.m[0][0] = 0.0f;
            this.m[0][1] = 0.0f;
            this.m[0][2] = 1.0f;
            this.m[0][3] = 0.0f;
            this.m[1][0] = 1.0f;
            this.m[1][1] = 0.0f;
            this.m[1][2] = 0.0f;
            this.m[1][3] = 0.0f;
            this.m[2][0] = 0.0f;
            this.m[2][1] = 1.0f;
            this.m[2][2] = 0.0f;
            this.m[2][3] = 0.0f;
            this.m[3][0] = 0.0f;
            this.m[3][1] = 0.0f;
            this.m[3][2] = 0.0f;
            this.m[3][3] = 1.0f;
        } else {
            this.m[0][0] = 1.0f;
            this.m[0][1] = 0.0f;
            this.m[0][2] = 0.0f;
            this.m[0][3] = 0.0f;
            this.m[1][0] = 0.0f;
            this.m[1][1] = 1.0f;
            this.m[1][2] = 0.0f;
            this.m[1][3] = 0.0f;
            this.m[2][0] = 0.0f;
            this.m[2][1] = 0.0f;
            this.m[2][2] = 1.0f;
            this.m[2][3] = 0.0f;
            this.m[3][0] = 0.0f;
            this.m[3][1] = 0.0f;
            this.m[3][2] = 0.0f;
            this.m[3][3] = 1.0f;
        }
    }

    public double[] getViewingVector() {
        double[] v = new double[]{this.m[0][1] * this.m[1][2] - this.m[1][1] * this.m[0][2], this.m[1][0] * this.m[0][2] - this.m[0][0] * this.m[1][2], this.m[0][0] * this.m[1][1] - this.m[1][0] * this.m[0][1], 1.0};
        return v;
    }

    public boolean getSliceOrder(double sci, double scj) {
        return (double)this.m[2][0] * sci + (double)this.m[2][1] * scj - (double)this.m[2][2] > 0.0;
    }

    public double[] getShearCoefficients() {
        double[] sc = new double[]{(this.m[1][1] * this.m[0][2] - this.m[0][1] * this.m[1][2]) / (this.m[0][0] * this.m[1][1] - this.m[1][0] * this.m[0][1]), (this.m[0][0] * this.m[1][2] - this.m[1][0] * this.m[0][2]) / (this.m[0][0] * this.m[1][1] - this.m[1][0] * this.m[0][1])};
        return sc;
    }

    public VJMatrix inverse() {
        float[][] mi = null;
        try {
            mi = BIJmatrix.inverse(this.m);
        }
        catch (Exception e) {
            VJUserInterface.error("VJMatrix: " + e);
        }
        return new VJMatrix(mi);
    }

    public String toString() {
        String s = "";
        s = s + this.m[0][0] + ", " + this.m[0][1] + ", " + this.m[0][2] + ", " + this.m[0][3] + "\n";
        s = s + this.m[1][0] + ", " + this.m[1][1] + ", " + this.m[1][2] + ", " + this.m[1][3] + "\n";
        s = s + this.m[2][0] + ", " + this.m[2][1] + ", " + this.m[2][2] + ", " + this.m[2][3] + "\n";
        s = s + this.m[3][0] + ", " + this.m[3][1] + ", " + this.m[3][2] + ", " + this.m[3][3] + "\n";
        return s;
    }
}

