/*
 * Decompiled with CFR 0.152.
 */
package VolumeJ;

import VolumeJ.VJInterpolator;
import VolumeJ.VJMatrix;
import VolumeJ.VJNearestNeighbor;
import VolumeJ.VJTrilinear;
import VolumeJ.VJValue;
import VolumeJ.VJViewspaceUtil;
import VolumeJ.VJVoxelLoc;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Frame;
import volume.Volume;
import volume.VolumeShort;

public class VJReconstructor {
    private static float anglex = 0.0f;
    private static float angley = 0.0f;
    private static float anglez = 0.0f;
    private static int length = 1;
    private static float aspectx = 1.0f;
    private static float aspecty = 1.0f;
    private static float aspectz = 1.0f;
    protected VolumeShort v;
    protected VJMatrix mi;
    protected int width;
    protected int height;
    protected int depth;
    protected int ioffset;
    protected int joffset;
    protected int koffset;

    public VJReconstructor() {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp instanceof ImagePlus && imp.getStackSize() > 1) {
            ImageStack isv = imp.getStack();
            Calibration c = imp.getCalibration();
            aspectx = 1.0f;
            aspecty = 1.0f;
            aspectz = (float)(c.pixelDepth / c.pixelWidth);
            this.v = null;
            try {
                this.v = new VolumeShort(isv);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.width = this.v.getWidth();
            this.height = this.v.getHeight();
            this.depth = this.v.getDepth();
            GenericDialog gd = new GenericDialog("Volume Reconstructor 1.1 (" + this.width + "x" + this.height + "x" + this.depth + ")", (Frame)IJ.getInstance());
            gd.addNumericField("aspect_x:", (double)aspectx, 2);
            gd.addNumericField("aspect_y:", (double)aspecty, 2);
            gd.addNumericField("aspect_z:", (double)aspectz, 2);
            gd.addNumericField("rotation_x (around x) angle (degrees/frame):", (double)anglex, 1);
            gd.addNumericField("rotation_y (around y) angle (degrees/frame):", (double)angley, 1);
            gd.addNumericField("rotation_z (around z) angle (degrees/frame):", (double)anglez, 1);
            gd.addNumericField("number of volumes:", (double)length, 0);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            aspectx = (float)gd.getNextNumber();
            aspecty = (float)gd.getNextNumber();
            aspectz = (float)gd.getNextNumber();
            anglex = (float)gd.getNextNumber();
            angley = (float)gd.getNextNumber();
            anglez = (float)gd.getNextNumber();
            length = (int)gd.getNextNumber();
            VJMatrix m = new VJMatrix();
            VJMatrix ms = new VJMatrix();
            ms.scale(aspectx, aspecty, aspectz);
            m.mul(ms);
            this.rotate(m, this.v, anglex, angley, anglez);
            this.setup(this.v, m);
            ImageStack is = new ImageStack(this.width, this.height);
            for (int t = 0; t < length; ++t) {
                for (int k = 0; k < this.depth; ++k) {
                    IJ.showStatus((String)("Reconstructing " + (t + 1) + "/" + length + "(" + k + "/" + this.depth + ") " + anglex * (float)(t + 1) + ", " + angley * (float)(t + 1) + ", " + anglez * (float)(t + 1)));
                    ImageProcessor ip = isv.getProcessor(1) instanceof ByteProcessor ? this.sliceByte(k) : this.sliceShort(k);
                    is.addSlice("" + k, ip);
                }
                this.rotate(m, this.v, anglex, angley, anglez);
            }
            ImagePlus impn = new ImagePlus("Hypervolume ", is);
            float temp = (float)c.pixelDepth;
            c.pixelDepth = c.pixelWidth;
            impn.setCalibration(c);
            c.pixelDepth = temp;
            impn.show();
        }
    }

    private ImageProcessor sliceByte(int k) {
        VJTrilinear interpolator = new VJTrilinear();
        VJNearestNeighbor endinterpolator = new VJNearestNeighbor();
        ByteProcessor ip = new ByteProcessor(this.width, this.height);
        byte[] pixels = (byte[])ip.getPixels();
        VJValue value = new VJValue();
        for (int j = 0; j < this.height; ++j) {
            for (int i = 0; i < this.width; ++i) {
                float[] vsv = new float[]{(float)i + (float)this.ioffset, (float)j + (float)this.joffset, (float)k + (float)this.koffset, 1.0f};
                float[] osv = this.mi.mul(vsv);
                VJVoxelLoc vl = new VJVoxelLoc(osv);
                pixels[j * this.width + i] = ((VJInterpolator)interpolator).isValid(vl, this.v) ? (byte)((VJInterpolator)interpolator).value((VJValue)value, (Volume)this.v, (VJVoxelLoc)vl).intvalue : ((float)vl.iz == vl.z && ((VJInterpolator)endinterpolator).isValid(vl, this.v) ? (byte)((VJInterpolator)endinterpolator).value((VJValue)value, (Volume)this.v, (VJVoxelLoc)vl).intvalue : (byte)0);
            }
        }
        return ip;
    }

    private ImageProcessor sliceShort(int k) {
        VJTrilinear interpolator = new VJTrilinear();
        VJNearestNeighbor endinterpolator = new VJNearestNeighbor();
        ShortProcessor ip = new ShortProcessor(this.width, this.height, false);
        short[] pixels = (short[])ip.getPixels();
        VJValue value = new VJValue();
        for (int j = 0; j < this.height; ++j) {
            for (int i = 0; i < this.width; ++i) {
                float[] vsv = new float[]{(float)i + (float)this.ioffset, (float)j + (float)this.joffset, (float)k + (float)this.koffset, 1.0f};
                float[] osv = this.mi.mul(vsv);
                VJVoxelLoc vl = new VJVoxelLoc(osv);
                pixels[j * this.width + i] = ((VJInterpolator)interpolator).isValid(vl, this.v) ? (short)((VJInterpolator)interpolator).value((VJValue)value, (Volume)this.v, (VJVoxelLoc)vl).intvalue : ((float)vl.iz == vl.z && ((VJInterpolator)endinterpolator).isValid(vl, this.v) ? (short)((VJInterpolator)endinterpolator).value((VJValue)value, (Volume)this.v, (VJVoxelLoc)vl).intvalue : (short)0);
            }
        }
        return ip;
    }

    private void rotate(VJMatrix m, Volume v, float anglex, float angley, float anglez) {
        VJMatrix mt = new VJMatrix();
        mt.translate(-v.getWidth() / 2, -v.getHeight() / 2, -v.getDepth() / 2);
        m.mul(mt);
        VJMatrix mrx = new VJMatrix();
        mrx.rotatex(anglex);
        m.mul(mrx);
        VJMatrix mry = new VJMatrix();
        mry.rotatey(angley);
        m.mul(mry);
        VJMatrix mrz = new VJMatrix();
        mrz.rotatez(anglez);
        m.mul(mrz);
    }

    public void setup(Volume v, VJMatrix m) {
        int[] vp = VJViewspaceUtil.suggestViewport(v, m);
        this.width = vp[0];
        this.height = vp[1];
        this.mi = m.inverse();
        int[][] minmax = VJViewspaceUtil.minmax(v, m);
        this.ioffset = (minmax[0][0] + minmax[1][0]) / 2 - this.width / 2;
        this.joffset = (minmax[0][1] + minmax[1][1]) / 2 - this.height / 2;
        this.koffset = minmax[0][2];
        this.depth = minmax[1][2] - minmax[0][2];
    }
}

