/*
 * Decompiled with CFR 0.152.
 */
package bijfit;

import bijfit.DesignMatrix;

public class DesignMatrixGamma
extends DesignMatrix {
    public DesignMatrixGamma(float[] t, float tmax, float t0) {
        this.a = new double[t.length][];
        if (tmax == 0.0f) {
            tmax = Float.MIN_VALUE;
        }
        for (int j = 0; j < t.length; ++j) {
            this.a[j] = this.fgamma(t[j], tmax, t0);
        }
    }

    protected double[] fgamma(float x, float xmax, float x0) {
        double[] p = new double[2];
        p[0] = 1.0;
        double xacc = (x - x0) / (xmax - x0);
        if (xacc <= 0.0) {
            xacc = 1.0E-12f;
        }
        p[1] = 1.0 + Math.log(xacc) - xacc;
        return p;
    }
}

