/*
 * Decompiled with CFR 0.152.
 */
package bijfit;

import Jama.Matrix;
import bijfit.DesignMatrix;
import bijfit.DesignMatrixLinear;
import bijnum.BIJutil;

public class GeneralLinearLeastSquares {
    public static float[] fit(float[] b, DesignMatrix dm) {
        double[] db = new double[b.length];
        for (int k = 0; k < b.length; ++k) {
            db[k] = b[k];
        }
        double[][] Aa = dm.getMatrix();
        Matrix a = new Matrix(Aa);
        Matrix x = a.solve(new Matrix(db, 1).transpose());
        double[][] xs = x.transpose().getArray();
        float[] coords = new float[xs[0].length];
        for (int l = 0; l < coords.length; ++l) {
            coords[l] = (float)xs[0][l];
        }
        return coords;
    }

    public static double[] fit(double[] db, DesignMatrix dm) {
        double[][] Aa = dm.getMatrix();
        Matrix a = new Matrix(Aa);
        Matrix x = a.solve(new Matrix(db, 1).transpose());
        double[][] xs = x.transpose().getArray();
        double[] coords = new double[xs[0].length];
        for (int l = 0; l < coords.length; ++l) {
            coords[l] = xs[0][l];
        }
        return coords;
    }

    public static float[][] fit(float[][] b, DesignMatrix dm) {
        float[][] coordinates = new float[b.length][];
        for (int j = 0; j < b.length; ++j) {
            coordinates[j] = GeneralLinearLeastSquares.fit(b[j], dm);
        }
        return coordinates;
    }

    public static void test() {
        float[] x = new float[]{-2.0f, -1.0f, 0.0f, 1.0f, 2.0f};
        float[] y = new float[]{-2.0f, 0.0f, 0.0f, 1.0f, 2.0f};
        DesignMatrixLinear dm = new DesignMatrixLinear(x);
        float[] params = GeneralLinearLeastSquares.fit(y, (DesignMatrix)dm);
        System.out.println(" x: " + BIJutil.toString(x) + " y: " + BIJutil.toString(y) + "a's: " + BIJutil.toString(params));
    }
}

