/*
 * Decompiled with CFR 0.152.
 */
package volume;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Frame;

public class Diffusion {
    protected static int iterations = 10;
    protected static float k = 2.0f;
    protected static float lambda = 1.0f;
    protected ImagePlus imp;
    protected float[] result = null;
    protected boolean scaleSpaceContrast = false;

    public Diffusion(ImagePlus imp) {
        this.imp = imp;
    }

    public boolean params() {
        GenericDialog gd = new GenericDialog("Nonlinear diffusion", (Frame)this.imp.getWindow());
        gd.addNumericField("lambda", (double)lambda, 2);
        gd.addNumericField("iterations", (double)iterations, 0);
        gd.addNumericField("k", (double)k, 2);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        lambda = (float)gd.getNextNumber();
        iterations = (int)gd.getNextNumber();
        k = (float)gd.getNextNumber();
        return true;
    }

    public void compute() {
        IJ.showStatus((String)("Nonlinear diffusion (lambda " + lambda + " k " + k + " n " + iterations + ")"));
        FloatProcessor fp = (FloatProcessor)this.imp.getProcessor().convertToFloat();
        int width = fp.getWidth();
        float[] source = (float[])fp.getPixels();
        float[] target = new float[source.length];
        for (int i = 0; i < iterations; ++i) {
            IJ.showProgress((double)((float)i / (float)iterations));
            for (int y = 1; y < fp.getHeight() - 1; ++y) {
                for (int x = 1; x < fp.getWidth() - 1; ++x) {
                    float cW;
                    float cE;
                    float cS;
                    float cN;
                    float n = Diffusion.dN(source, width, x, y);
                    float s = Diffusion.dS(source, width, x, y);
                    float e = Diffusion.dE(source, width, x, y);
                    float w = Diffusion.dW(source, width, x, y);
                    if (this.scaleSpaceContrast) {
                        cN = Diffusion.gScaleSpace(Math.abs(n), k);
                        cS = Diffusion.gScaleSpace(Math.abs(s), k);
                        cE = Diffusion.gScaleSpace(Math.abs(e), k);
                        cW = Diffusion.gScaleSpace(Math.abs(w), k);
                    } else {
                        cN = Diffusion.g(Math.abs(n), k);
                        cS = Diffusion.g(Math.abs(s), k);
                        cE = Diffusion.g(Math.abs(e), k);
                        cW = Diffusion.g(Math.abs(w), k);
                    }
                    float value = source[width * y + x];
                    target[width * y + x] = value += lambda * (cN * n + cS * s + cE * e + cW * w);
                }
            }
            float[] t = source;
            source = target;
            target = t;
        }
        this.result = source;
    }

    protected static float gScaleSpace(float a, float k) {
        return (float)Math.exp(-Math.pow(a / k, 2.0));
    }

    protected static float g(float grad, float k) {
        return (float)(1.0 / (1.0 + Math.pow(grad / k, 2.0)));
    }

    protected static float dN(float[] source, int width, int x, int y) {
        float p1 = source[(y - 1) * width + x];
        float p2 = source[y * width + x];
        return p1 - p2;
    }

    protected static float dS(float[] source, int width, int x, int y) {
        float p1 = source[(y + 1) * width + x];
        float p2 = source[y * width + x];
        return p1 - p2;
    }

    protected static float dE(float[] source, int width, int x, int y) {
        float p1 = source[y * width + (x + 1)];
        float p2 = source[y * width + x];
        return p1 - p2;
    }

    protected static float dW(float[] source, int width, int x, int y) {
        float p1 = source[y * width + (x - 1)];
        float p2 = source[y * width + x];
        return p1 - p2;
    }

    public ImageProcessor getProcessor() {
        return new FloatProcessor(this.imp.getProcessor().getWidth(), this.imp.getProcessor().getHeight(), this.result, null);
    }
}

