/*
 * Decompiled with CFR 0.152.
 */
package volume;

import ij.IJ;
import volume.Kernel1D;

public class Gaussian
extends Kernel1D {
    protected double sigma;

    public Gaussian() {
    }

    public Gaussian(double sigma) {
        this.sigma = sigma;
        if (sigma != 0.0) {
            int width = (int)(6.0 * sigma + 1.0);
            if (width % 2 == 0) {
                ++width;
            }
            this.halfwidth = width / 2;
            this.k = new double[this.halfwidth * 2 + 1];
            for (int l = -this.halfwidth; l <= this.halfwidth; ++l) {
                this.k[l + this.halfwidth] = this.function(l);
            }
        } else {
            this.halfwidth = 0;
        }
    }

    public double getSigma() {
        return this.sigma;
    }

    protected double function(double x) {
        return 1.0 / (Math.sqrt(Math.PI * 2) * this.sigma) * Math.exp(-x * x / (2.0 * this.sigma * this.sigma));
    }

    public Gaussian(int width) {
        if (width == 3) {
            this.halfwidth = width / 2;
            this.k = new double[this.halfwidth * 2 + 1];
            this.k[0] = 0.25;
            this.k[1] = 0.5;
            this.k[2] = 0.25;
        } else if (width == 5) {
            this.halfwidth = width / 2;
            this.k = new double[this.halfwidth * 2 + 1];
            this.k[0] = 0.0625;
            this.k[1] = 0.25;
            this.k[2] = 0.375;
            this.k[3] = 0.25;
            this.k[4] = 0.0625;
        } else {
            IJ.error((String)"Error initializing Gaussian kernel.");
        }
    }

    @Override
    public String toString() {
        return "Gauss" + this.sigma;
    }
}

