/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action.edit;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.View;
import org.jhotdraw.app.action.AbstractViewAction;
import org.jhotdraw.util.ResourceBundleUtil;

public class UndoAction
extends AbstractViewAction {
    public static final String ID = "edit.undo";
    private ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
    private PropertyChangeListener redoActionPropertyListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (name == "Name") {
                UndoAction.this.putValue("Name", evt.getNewValue());
            } else if (name == "enabled") {
                UndoAction.this.updateEnabledState();
            }
        }
    };

    public UndoAction(Application app, @Nullable View view) {
        super(app, view);
        this.labels.configureAction(this, ID);
    }

    protected void updateEnabledState() {
        boolean isEnabled = false;
        Action realAction = this.getRealUndoAction();
        if (realAction != null && realAction != this) {
            isEnabled = realAction.isEnabled();
        }
        this.setEnabled(isEnabled);
    }

    @Override
    protected void updateView(@Nullable View oldValue, @Nullable View newValue) {
        super.updateView(oldValue, newValue);
        if (newValue != null && newValue.getActionMap().get(ID) != null && newValue.getActionMap().get(ID) != this) {
            this.putValue("Name", newValue.getActionMap().get(ID).getValue("Name"));
            this.updateEnabledState();
        }
    }

    @Override
    protected void installViewListeners(View p) {
        super.installViewListeners(p);
        Action undoActionInView = p.getActionMap().get(ID);
        if (undoActionInView != null && undoActionInView != this) {
            undoActionInView.addPropertyChangeListener(this.redoActionPropertyListener);
        }
    }

    @Override
    protected void uninstallViewListeners(View p) {
        super.uninstallViewListeners(p);
        Action undoActionInView = p.getActionMap().get(ID);
        if (undoActionInView != null && undoActionInView != this) {
            undoActionInView.removePropertyChangeListener(this.redoActionPropertyListener);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Action realUndoAction = this.getRealUndoAction();
        if (realUndoAction != null && realUndoAction != this) {
            realUndoAction.actionPerformed(e);
        }
    }

    @Nullable
    private Action getRealUndoAction() {
        return this.getActiveView() == null ? null : this.getActiveView().getActionMap().get(ID);
    }
}

