/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.text;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Color;
import java.awt.color.ColorSpace;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;
import org.jhotdraw.color.ColorUtil;
import org.jhotdraw.color.HSBColorSpace;
import org.jhotdraw.util.prefs.PreferencesUtil;

public class ColorFormatter
extends DefaultFormatter {
    protected Format outputFormat = Format.RGB_INTEGER;
    @Nullable
    protected Format lastUsedInputFormat = null;
    protected static final Pattern rgbHexPattern = Pattern.compile("^\\s*(?:[rR][gG][bB]\\s*#|#)\\s*([0-9a-fA-F]{3,6})\\s*$");
    protected static final Pattern rgbIntegerShortPattern = Pattern.compile("^\\s*([0-9]{1,3})(?:\\s*,\\s*|\\s+)([0-9]{1,3})(?:\\s*,\\s*|\\s+)([0-9]{1,3})\\s*$");
    protected static final Pattern rgbIntegerPattern = Pattern.compile("^\\s*(?:[rR][gG][bB])?\\s*([0-9]{1,3})(?:\\s*,\\s*|\\s+)([0-9]{1,3})(?:\\s*,\\s*|\\s+)([0-9]{1,3})\\s*$");
    protected static final Pattern rgbPercentagePattern = Pattern.compile("^\\s*(?:[rR][gG][bB][%])?\\s*([0-9]{1,3}(?:\\.[0-9]+)?)(?:\\s*,\\s*|\\s+)([0-9]{1,3}(?:\\.[0-9]+)?)(?:\\s*,\\s*|\\s+)([0-9]{1,3}(?:\\.[0-9]+)?)\\s*$");
    protected static final Pattern hsbPercentagePattern = Pattern.compile("^\\s*(?:[hH][sS][bB])?\\s*([0-9]{1,3}(?:\\.[0-9]+)?)(?:\\s*,\\s*|\\s+)([0-9]{1,3}(?:\\.[0-9]+)?)(?:\\s*,\\s*|\\s+)([0-9]{1,3}(?:\\.[0-9]+)?)\\s*$");
    protected static final Pattern grayPercentagePattern = Pattern.compile("^\\s*(?:[gG][rR][aA][yY])?\\s*([0-9]{1,3}(?:\\.[0-9]+)?)\\s*$");
    protected boolean allowsNullValue = true;
    protected boolean isAdaptive = true;
    protected Preferences prefs;
    protected DecimalFormat numberFormat;

    public ColorFormatter() {
        this(Format.RGB_INTEGER, true, true);
    }

    public ColorFormatter(Format outputFormat, boolean allowsNullValue, boolean isAdaptive) {
        this.outputFormat = outputFormat;
        this.allowsNullValue = allowsNullValue;
        this.isAdaptive = isAdaptive;
        this.numberFormat = new DecimalFormat("#.#");
        this.numberFormat.setDecimalSeparatorAlwaysShown(false);
        this.numberFormat.setMaximumFractionDigits(1);
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        this.numberFormat.setDecimalFormatSymbols(dfs);
        this.prefs = PreferencesUtil.userNodeForPackage(this.getClass());
        try {
            this.lastUsedInputFormat = Format.valueOf(this.prefs.get("ColorFormatter.lastUsedInputFormat", Format.RGB_HEX.name()));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        if (isAdaptive && this.lastUsedInputFormat != null) {
            this.outputFormat = this.lastUsedInputFormat;
        }
        this.setOverwriteMode(false);
    }

    public void setOutputFormat(Format newValue) {
        if (newValue == null) {
            throw new NullPointerException("outputFormat may not be null");
        }
        this.outputFormat = newValue;
    }

    public Format getOutputFormat() {
        return this.outputFormat;
    }

    public Format getLastUsedInputFormat() {
        return this.lastUsedInputFormat;
    }

    public void setAllowsNullValue(boolean newValue) {
        this.allowsNullValue = newValue;
    }

    public boolean getAllowsNullValue() {
        return this.allowsNullValue;
    }

    public void setAdaptive(boolean newValue) {
        this.isAdaptive = newValue;
        if (newValue && this.lastUsedInputFormat != null) {
            this.outputFormat = this.lastUsedInputFormat;
        }
    }

    public boolean isAdaptive() {
        return this.isAdaptive;
    }

    private void setLastUsedInputFormat(Format newValue) {
        this.lastUsedInputFormat = newValue;
        if (this.isAdaptive) {
            this.outputFormat = this.lastUsedInputFormat;
        }
        this.prefs.put("ColorFormatter.lastUsedInputFormat", newValue.name());
    }

    @Override
    public Object stringToValue(String str) throws ParseException {
        if (str == null || str.trim().length() == 0) {
            if (this.allowsNullValue) {
                return null;
            }
            throw new ParseException("Null value is not allowed.", 0);
        }
        Matcher matcher = rgbHexPattern.matcher(str);
        if (matcher.matches()) {
            this.setLastUsedInputFormat(Format.RGB_HEX);
            try {
                String group1 = matcher.group(1);
                if (group1.length() == 3) {
                    return new Color(Integer.parseInt("" + group1.charAt(0) + group1.charAt(0) + group1.charAt(1) + group1.charAt(1) + group1.charAt(2) + group1.charAt(2), 16));
                }
                if (group1.length() == 6) {
                    return new Color(Integer.parseInt(group1, 16));
                }
                throw new ParseException("Hex color must have 3 or 6 digits.", 1);
            }
            catch (NumberFormatException nfe) {
                ParseException pe = new ParseException(str, 0);
                pe.initCause(nfe);
                throw pe;
            }
        }
        matcher = rgbIntegerShortPattern.matcher(str);
        if (matcher.matches()) {
            this.setLastUsedInputFormat(Format.RGB_INTEGER_SHORT);
        } else {
            matcher = rgbIntegerPattern.matcher(str);
            if (matcher.matches()) {
                this.setLastUsedInputFormat(Format.RGB_INTEGER);
            }
        }
        if (matcher.matches()) {
            try {
                return new Color(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)));
            }
            catch (NumberFormatException nfe) {
                ParseException pe = new ParseException(str, 0);
                pe.initCause(nfe);
                throw pe;
            }
            catch (IllegalArgumentException iae) {
                ParseException pe = new ParseException(str, 0);
                pe.initCause(iae);
                throw pe;
            }
        }
        matcher = rgbPercentagePattern.matcher(str);
        if (matcher.matches()) {
            this.setLastUsedInputFormat(Format.RGB_PERCENTAGE);
            try {
                return new Color(this.numberFormat.parse(matcher.group(1)).floatValue() / 100.0f, this.numberFormat.parse(matcher.group(2)).floatValue() / 100.0f, this.numberFormat.parse(matcher.group(3)).floatValue() / 100.0f);
            }
            catch (NumberFormatException nfe) {
                ParseException pe = new ParseException(str, 0);
                pe.initCause(nfe);
                throw pe;
            }
            catch (IllegalArgumentException iae) {
                ParseException pe = new ParseException(str, 0);
                pe.initCause(iae);
                throw pe;
            }
        }
        matcher = hsbPercentagePattern.matcher(str);
        if (matcher.matches()) {
            this.setLastUsedInputFormat(Format.HSB_PERCENTAGE);
            try {
                return new Color(HSBColorSpace.getInstance(), new float[]{matcher.group(1) == null ? 0.0f : this.numberFormat.parse(matcher.group(1)).floatValue() / 360.0f, matcher.group(2) == null ? 1.0f : this.numberFormat.parse(matcher.group(2)).floatValue() / 100.0f, matcher.group(3) == null ? 1.0f : this.numberFormat.parse(matcher.group(3)).floatValue() / 100.0f}, 1.0f);
            }
            catch (NumberFormatException nfe) {
                ParseException pe = new ParseException(str, 0);
                pe.initCause(nfe);
                throw pe;
            }
            catch (IllegalArgumentException iae) {
                ParseException pe = new ParseException(str, 0);
                pe.initCause(iae);
                throw pe;
            }
        }
        matcher = grayPercentagePattern.matcher(str);
        if (matcher.matches()) {
            this.setLastUsedInputFormat(Format.GRAY_PERCENTAGE);
            try {
                return ColorUtil.toColor(ColorSpace.getInstance(1003), matcher.group(1) == null ? 0.0f : this.numberFormat.parse(matcher.group(1)).floatValue() / 100.0f);
            }
            catch (NumberFormatException nfe) {
                ParseException pe = new ParseException(str, 0);
                pe.initCause(nfe);
                throw pe;
            }
            catch (IllegalArgumentException iae) {
                ParseException pe = new ParseException(str, 0);
                pe.initCause(iae);
                throw pe;
            }
        }
        throw new ParseException(str, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String valueToString(Object value) throws ParseException {
        String str = null;
        if (value == null) {
            if (!this.allowsNullValue) throw new ParseException("Null value is not allowed.", 0);
            return "";
        }
        if (!(value instanceof Color)) {
            throw new ParseException("Value is not a color " + value, 0);
        }
        Color c = (Color)value;
        Format f = this.outputFormat;
        if (this.isAdaptive) {
            switch (c.getColorSpace().getType()) {
                case 7: {
                    f = Format.HSB_PERCENTAGE;
                    break;
                }
                case 6: {
                    f = Format.GRAY_PERCENTAGE;
                    break;
                }
                default: {
                    f = Format.RGB_INTEGER_SHORT;
                }
            }
        }
        switch (f) {
            case RGB_HEX: {
                str = "000000" + Integer.toHexString(c.getRGB() & 0xFFFFFF);
                return "#" + str.substring(str.length() - 6);
            }
            case RGB_INTEGER_SHORT: {
                return c.getRed() + " " + c.getGreen() + " " + c.getBlue();
            }
            case RGB_INTEGER: {
                return "rgb " + c.getRed() + " " + c.getGreen() + " " + c.getBlue();
            }
            case RGB_PERCENTAGE: {
                return "rgb% " + this.numberFormat.format((float)c.getRed() / 255.0f) + " " + this.numberFormat.format((float)c.getGreen() / 255.0f) + " " + this.numberFormat.format((float)c.getBlue() / 255.0f) + "";
            }
            case HSB_PERCENTAGE: {
                float[] components = c.getColorSpace().getType() == 7 ? c.getComponents(null) : Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), new float[3]);
                return "hsb " + this.numberFormat.format(components[0] * 360.0f) + " " + this.numberFormat.format(components[1] * 100.0f) + " " + this.numberFormat.format(components[2] * 100.0f) + "";
            }
            case GRAY_PERCENTAGE: {
                float[] components = c.getColorSpace().getType() == 6 ? c.getComponents(null) : c.getColorComponents(ColorSpace.getInstance(1003), null);
                return "gray " + this.numberFormat.format(components[0] * 100.0f) + "";
            }
        }
        return str;
    }

    public static JFormattedTextField.AbstractFormatterFactory createFormatterFactory() {
        return ColorFormatter.createFormatterFactory(Format.RGB_INTEGER_SHORT, true, true);
    }

    public static JFormattedTextField.AbstractFormatterFactory createFormatterFactory(Format outputFormat, boolean allowsNullValue, boolean isAdaptive) {
        return new DefaultFormatterFactory(new ColorFormatter(outputFormat, allowsNullValue, isAdaptive));
    }

    public static enum Format {
        RGB_HEX,
        RGB_INTEGER_SHORT,
        RGB_INTEGER,
        RGB_PERCENTAGE,
        HSB_PERCENTAGE,
        GRAY_PERCENTAGE,
        CMYK_PERCENTAGE;

    }
}

