/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.coloc.results;

import com.itextpdf.text.BadElementException;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.Line;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.io.SaveDialog;
import java.awt.Color;
import java.awt.Image;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.math.ImageStatistics;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.LongType;
import sc.fiji.coloc.algorithms.AutoThresholdRegression;
import sc.fiji.coloc.algorithms.Histogram2D;
import sc.fiji.coloc.gadgets.Autoscaler;
import sc.fiji.coloc.gadgets.DataContainer;
import sc.fiji.coloc.results.ResultHandler;
import sc.fiji.coloc.results.Warning;

public class PDFWriter<T extends RealType<T>>
implements ResultHandler<T> {
    boolean isLetter = false;
    boolean isFirst = true;
    static boolean showName = true;
    static int succeededPrints = 0;
    static boolean showSize = true;
    DataContainer<T> container;
    PdfWriter writer;
    Document document;
    protected List<com.itextpdf.text.Image> listOfPDFImages = new ArrayList<com.itextpdf.text.Image>();
    protected List<Paragraph> listOfPDFTexts = new ArrayList<Paragraph>();
    protected List<Paragraph> PDFwarnings = new ArrayList<Paragraph>();

    public PDFWriter(DataContainer<T> container) {
        this.container = container;
    }

    @Override
    public void handleImage(RandomAccessibleInterval<T> image, String name) {
        ImagePlus imp = ImageJFunctions.wrapFloat(image, (String)name);
        double max = ((RealType)ImageStatistics.getImageMax(image)).getRealDouble();
        imp.setDisplayRange(0.0, max);
        this.addImageToList(imp, name);
    }

    @Override
    public void handleHistogram(Histogram2D<T> histogram, String name) {
        RandomAccessibleInterval<LongType> image = histogram.getPlotImage();
        ImagePlus imp = ImageJFunctions.wrapFloat(image, (String)name);
        imp.getProcessor().snapshot();
        imp.getProcessor().log();
        imp.updateAndDraw();
        Autoscaler.autoscale(imp.getProcessor());
        IJ.run((ImagePlus)imp, (String)"Fire", null);
        Overlay overlay = new Overlay();
        if (histogram.getDrawingSettings().contains((Object)Histogram2D.DrawingFlags.RegressionLine)) {
            AutoThresholdRegression<T> autoThreshold = this.container.getAutoThreshold();
            if (histogram != null && autoThreshold != null) {
                this.drawLine(histogram, overlay, image.dimension(0), image.dimension(1), autoThreshold.getAutoThresholdSlope(), autoThreshold.getAutoThresholdIntercept());
                overlay.setStrokeColor(Color.WHITE);
                imp.setOverlay(overlay);
            }
        }
        this.addImageToList(imp, name);
        imp.getProcessor().reset();
    }

    private void drawLine(Histogram2D<T> histogram, Overlay overlay, long imgWidth, long imgHeight, double slope, double intercept) {
        double startX = 0.0;
        double endX = imgWidth;
        double calibratedStartY = slope * histogram.getXMin() + intercept;
        double calibratedEndY = slope * histogram.getXMax() + intercept;
        double startY = calibratedStartY * histogram.getYBinWidth();
        double endY = calibratedEndY * histogram.getYBinWidth();
        startY = (double)(imgHeight - 1L) - startY;
        endY = (double)(imgHeight - 1L) - endY;
        Line lineROI = new Line(startX, startY, endX, endY);
        lineROI.setStrokeWidth(1.0f);
        overlay.add((Roi)lineROI);
    }

    protected void addImageToList(ImagePlus imp, String name) {
        Overlay overlay = imp.getOverlay();
        IJ.log((String)("overlay=" + overlay));
        if (overlay != null && overlay.size() > 0) {
            IJ.log((String)("" + overlay.get(0)));
        }
        ImagePlus flatten = imp.flatten();
        Image awtImage = flatten.getImage();
        try {
            com.itextpdf.text.Image pdfImage = com.itextpdf.text.Image.getInstance((Image)awtImage, null);
            pdfImage.setAlt(name);
            this.listOfPDFImages.add(pdfImage);
        }
        catch (BadElementException e) {
            IJ.log((String)"Could not convert image to correct format for PDF generation");
            IJ.handleException((Throwable)e);
        }
        catch (IOException e) {
            IJ.log((String)"Could not convert image to correct format for PDF generation");
            IJ.handleException((Throwable)e);
        }
    }

    @Override
    public void handleWarning(Warning warning) {
        this.PDFwarnings.add(new Paragraph("Warning! " + warning.getShortMessage() + " - " + warning.getLongMessage()));
    }

    @Override
    public void handleValue(String name, String value) {
        this.listOfPDFTexts.add(new Paragraph(name + ": " + value));
    }

    @Override
    public void handleValue(String name, double value) {
        this.handleValue(name, value, 3);
    }

    @Override
    public void handleValue(String name, double value, int decimals) {
        this.listOfPDFTexts.add(new Paragraph(name + ": " + IJ.d2s((double)value, (int)decimals)));
    }

    protected void addImage(com.itextpdf.text.Image image, String xLabel, String yLabel) throws DocumentException, IOException {
        if (!this.isFirst) {
            this.document.add((Element)new Paragraph("\n"));
            float vertPos = this.writer.getVerticalPosition(true);
            if (vertPos - this.document.bottom() < image.getHeight()) {
                this.document.newPage();
            } else {
                PdfContentByte cb = this.writer.getDirectContent();
                cb.setLineWidth(1.0f);
                if (this.isLetter) {
                    cb.moveTo(PageSize.LETTER.getLeft(50.0f), vertPos);
                    cb.lineTo(PageSize.LETTER.getRight(50.0f), vertPos);
                } else {
                    cb.moveTo(PageSize.A4.getLeft(50.0f), vertPos);
                    cb.lineTo(PageSize.A4.getRight(50.0f), vertPos);
                }
                cb.stroke();
            }
        }
        if (showName) {
            Paragraph paragraph = new Paragraph(image.getAlt());
            paragraph.setAlignment(1);
            this.document.add((Element)paragraph);
        }
        if (showSize) {
            Paragraph paragraph = new Paragraph(image.getWidth() + " x " + image.getHeight());
            paragraph.setAlignment(1);
            this.document.add((Element)paragraph);
        }
        PdfPTable table = new PdfPTable(2);
        table.setWidthPercentage(85.0f);
        table.setWidths(new int[]{1, 2});
        table.setSpacingBefore(4.0f);
        PdfPCell cell = new PdfPCell(new Phrase("\tChannel 2\n" + this.labelName(yLabel)));
        this.cellStyle(cell);
        table.addCell(cell);
        image.setAlignment(1);
        table.addCell(image);
        cell = new PdfPCell();
        this.cellStyle(cell);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\tChannel 1\n" + this.labelName(xLabel)));
        this.cellStyle(cell);
        table.addCell(cell);
        this.document.add((Element)table);
        this.isFirst = false;
    }

    private void cellStyle(PdfPCell cell) {
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        cell.setPaddingTop(2.0f);
        cell.setBorder(0);
        cell.setBorderColor(BaseColor.WHITE);
    }

    private String labelName(String s) {
        int maxLen = 30;
        return s.length() > 30 ? s.substring(0, 27) + "..." : s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        try {
            String jobName = this.container.getJobName();
            if (this.container.getMaskType() != DataContainer.MaskType.None) {
                jobName = jobName + (succeededPrints + 1);
            }
            SaveDialog sd = new SaveDialog("Save as PDF", jobName, ".pdf");
            jobName = sd.getFileName();
            String directory = sd.getDirectory();
            if (jobName == null || directory == null) {
                return;
            }
            String path = directory + jobName;
            this.document = new Document(this.isLetter ? PageSize.LETTER : PageSize.A4);
            this.document.addCreationDate();
            this.document.addTitle(jobName);
            this.writer = PdfWriter.getInstance((Document)this.document, (OutputStream)new FileOutputStream(path));
            this.document.open();
            Paragraph titlePara = new Paragraph(jobName);
            this.document.add((Element)titlePara);
            for (com.itextpdf.text.Image img : this.listOfPDFImages) {
                this.addImage(img, this.container.getSourceCh1Name(), this.container.getSourceCh2Name());
            }
            for (Paragraph p : this.PDFwarnings) {
                this.document.add((Element)p);
            }
            for (Paragraph p : this.listOfPDFTexts) {
                this.document.add((Element)p);
            }
        }
        catch (DocumentException de) {
            IJ.showMessage((String)"PDF Writer", (String)de.getMessage());
        }
        catch (IOException ioe) {
            IJ.showMessage((String)"PDF Writer", (String)ioe.getMessage());
        }
        finally {
            if (this.document != null) {
                this.document.close();
                ++succeededPrints;
            }
        }
    }
}

