/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.Shape;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Polygon
extends Shape {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Polygon.class);
    private String points;

    public Polygon() {
    }

    public Polygon(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public Polygon(Polygon orig) {
        super(orig);
        this.points = orig.points;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        if (element.hasAttribute("Points")) {
            this.setPoints(String.valueOf(element.getAttribute("Points")));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        return super.link(reference, o);
    }

    public String getPoints() {
        return this.points;
    }

    public void setPoints(String points) {
        this.points = points;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element Polygon_element) {
        if (Polygon_element == null) {
            Polygon_element = document.createElementNS(NAMESPACE, "Polygon");
        }
        super.asXMLElement(document, Polygon_element);
        if (this.points != null) {
            Polygon_element.setAttribute("Points", this.points);
        }
        return Polygon_element;
    }
}

