/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.blocks;

import net.imglib2.Interval;
import net.imglib2.algorithm.blocks.AbstractUnaryBlockOperator;
import net.imglib2.algorithm.blocks.BlockSupplier;
import net.imglib2.algorithm.blocks.UnaryBlockOperator;
import net.imglib2.blocks.BlockInterval;
import net.imglib2.blocks.SubArrayCopy;
import net.imglib2.blocks.TempArray;
import net.imglib2.type.NativeType;
import net.imglib2.type.PrimitiveType;
import net.imglib2.util.Cast;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;

class TilingUnaryBlockOperator<T extends NativeType<T>, P>
extends AbstractUnaryBlockOperator<T, T> {
    private final int[] innerTileSize;
    private final int[] borderTileSize;
    private final int[] numTiles;
    private final TempArray<P> tempArray;
    private final int innerTileNumElements;
    private final SubArrayCopy.Typed<P, P> subArrayCopy;
    private final int[] tile_pos_in_dest;
    private final long[] tile_pos_in_src;
    private final int[] tile_size;
    private final BlockInterval tile_interval_in_src;
    private final int[] zero;

    public TilingUnaryBlockOperator(T type, int numDimensions, int ... tileSize) {
        super(type, type, numDimensions, numDimensions);
        this.innerTileSize = Util.expandArray((int[])tileSize, (int)numDimensions);
        this.innerTileNumElements = Util.safeInt((long)Intervals.numElements((int[])this.innerTileSize));
        this.borderTileSize = new int[numDimensions];
        this.numTiles = new int[numDimensions];
        PrimitiveType primitiveType = type.getNativeTypeFactory().getPrimitiveType();
        this.tempArray = TempArray.forPrimitiveType((PrimitiveType)primitiveType);
        this.subArrayCopy = SubArrayCopy.forPrimitiveType((PrimitiveType)primitiveType);
        this.tile_pos_in_dest = new int[numDimensions];
        this.tile_pos_in_src = new long[numDimensions];
        this.tile_size = new int[numDimensions];
        this.tile_interval_in_src = BlockInterval.wrap((long[])this.tile_pos_in_src, (int[])this.tile_size);
        this.zero = new int[numDimensions];
    }

    private TilingUnaryBlockOperator(TilingUnaryBlockOperator<T, P> op) {
        super(op);
        this.innerTileSize = op.innerTileSize;
        this.innerTileNumElements = op.innerTileNumElements;
        this.tempArray = op.tempArray.newInstance();
        this.subArrayCopy = op.subArrayCopy;
        int n = op.numTargetDimensions();
        this.borderTileSize = new int[n];
        this.numTiles = new int[n];
        this.tile_pos_in_dest = new int[n];
        this.tile_pos_in_src = new long[n];
        this.tile_size = new int[n];
        this.tile_interval_in_src = BlockInterval.wrap((long[])this.tile_pos_in_src, (int[])this.tile_size);
        this.zero = op.zero;
    }

    @Override
    public void compute(BlockSupplier<T> src, Interval interval, Object dest) {
        BlockInterval blockInterval = BlockInterval.asBlockInterval((Interval)interval);
        long[] srcPos = blockInterval.min();
        int[] size = blockInterval.size();
        int n = this.numTargetDimensions();
        boolean singleTile = true;
        for (int d = 0; d < n; ++d) {
            this.numTiles[d] = (size[d] - 1) / this.innerTileSize[d] + 1;
            if (this.numTiles[d] > 1) {
                singleTile = false;
            }
            this.borderTileSize[d] = size[d] - (this.numTiles[d] - 1) * this.innerTileSize[d];
        }
        if (singleTile) {
            src.copy((Interval)blockInterval, dest);
        } else {
            Object tile_buf = this.tempArray.get(this.innerTileNumElements);
            this.compute_tiles_recursively(n - 1, src, srcPos, Cast.unchecked((Object)dest), size, tile_buf);
        }
    }

    private void compute_tiles_recursively(int d, BlockSupplier<T> src, long[] srcPos, P dest, int[] dest_size, P tile_buf) {
        int numTiles = this.numTiles[d];
        for (int i = 0; i < numTiles; ++i) {
            this.tile_pos_in_dest[d] = this.innerTileSize[d] * i;
            this.tile_pos_in_src[d] = srcPos[d] + (long)this.tile_pos_in_dest[d];
            int n = this.tile_size[d] = i == numTiles - 1 ? this.borderTileSize[d] : this.innerTileSize[d];
            if (d == 0) {
                src.copy((Interval)this.tile_interval_in_src, tile_buf);
                this.subArrayCopy.copy(tile_buf, this.tile_size, this.zero, dest, dest_size, this.tile_pos_in_dest, this.tile_size);
                continue;
            }
            this.compute_tiles_recursively(d - 1, src, srcPos, dest, dest_size, tile_buf);
        }
    }

    @Override
    public UnaryBlockOperator<T, T> independentCopy() {
        return new TilingUnaryBlockOperator<T, P>(this);
    }
}

