/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.lazy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.cache.Cache;
import net.imglib2.cache.CacheLoader;
import net.imglib2.cache.img.CachedCellImg;
import net.imglib2.cache.img.CellLoader;
import net.imglib2.cache.img.LoadedCellCacheLoader;
import net.imglib2.cache.img.SingleCellArrayImg;
import net.imglib2.cache.ref.SoftRefLoaderCache;
import net.imglib2.img.basictypeaccess.AccessFlags;
import net.imglib2.img.basictypeaccess.ArrayDataAccessFactory;
import net.imglib2.img.basictypeaccess.DataAccess;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.type.NativeType;
import net.imglib2.type.PrimitiveType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.integer.GenericByteType;
import net.imglib2.type.numeric.integer.GenericIntType;
import net.imglib2.type.numeric.integer.GenericLongType;
import net.imglib2.type.numeric.integer.GenericShortType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;
import net.imglib2.view.Views;

public interface Caches {
    public static <T extends NativeType<T>> RandomAccessibleInterval<T> cache(RandomAccessibleInterval<T> source, int ... blockSize) {
        long[] dimensions = Intervals.dimensionsAsLongArray(source);
        CellGrid grid = new CellGrid(dimensions, blockSize);
        RandomAccessibleLoader loader = new RandomAccessibleLoader(Views.zeroMin(source));
        NativeType type = (NativeType)Util.getTypeFromInterval(source);
        Cache cache = new SoftRefLoaderCache().withLoader((CacheLoader)LoadedCellCacheLoader.get((CellGrid)grid, loader, (NativeType)type, (Set)AccessFlags.setOf((AccessFlags)AccessFlags.VOLATILE)));
        Object img = GenericByteType.class.isInstance(type) ? new CachedCellImg(grid, type, cache, (DataAccess)ArrayDataAccessFactory.get((PrimitiveType)PrimitiveType.BYTE, (Set)AccessFlags.setOf((AccessFlags)AccessFlags.VOLATILE))) : (GenericShortType.class.isInstance(type) ? new CachedCellImg(grid, type, cache, (DataAccess)ArrayDataAccessFactory.get((PrimitiveType)PrimitiveType.SHORT, (Set)AccessFlags.setOf((AccessFlags)AccessFlags.VOLATILE))) : (GenericIntType.class.isInstance(type) ? new CachedCellImg(grid, type, cache, (DataAccess)ArrayDataAccessFactory.get((PrimitiveType)PrimitiveType.INT, (Set)AccessFlags.setOf((AccessFlags)AccessFlags.VOLATILE))) : (GenericLongType.class.isInstance(type) ? new CachedCellImg(grid, type, cache, (DataAccess)ArrayDataAccessFactory.get((PrimitiveType)PrimitiveType.LONG, (Set)AccessFlags.setOf((AccessFlags)AccessFlags.VOLATILE))) : (FloatType.class.isInstance(type) ? new CachedCellImg(grid, type, cache, (DataAccess)ArrayDataAccessFactory.get((PrimitiveType)PrimitiveType.FLOAT, (Set)AccessFlags.setOf((AccessFlags)AccessFlags.VOLATILE))) : (DoubleType.class.isInstance(type) ? new CachedCellImg(grid, type, cache, (DataAccess)ArrayDataAccessFactory.get((PrimitiveType)PrimitiveType.DOUBLE, (Set)AccessFlags.setOf((AccessFlags)AccessFlags.VOLATILE))) : null)))));
        return img;
    }

    public static <T> ArrayList<Future<T>> preFetch(RandomAccessible<T> source, Interval interval, long[] spacing, ExecutorService exec) throws InterruptedException, ExecutionException {
        int n = interval.numDimensions();
        long[] max = new long[n];
        Arrays.setAll(max, d -> interval.max(d) + spacing[d]);
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>();
        long[] offset = Intervals.minAsLongArray((Interval)interval);
        int d2 = 0;
        block0: while (d2 < n) {
            long[] offsetLocal = (long[])offset.clone();
            futures.add(exec.submit(() -> {
                RandomAccess access = source.randomAccess(interval);
                access.setPosition(offsetLocal);
                return access.get();
            }));
            for (d2 = 0; d2 < n; ++d2) {
                int n2 = d2;
                offset[n2] = offset[n2] + spacing[d2];
                if (offset[d2] < max[d2]) {
                    offset[d2] = Math.min(offset[d2], interval.max(d2));
                    continue block0;
                }
                offset[d2] = interval.min(d2);
            }
        }
        return futures;
    }

    public static class RandomAccessibleLoader<T extends NativeType<T>>
    implements CellLoader<T> {
        private final RandomAccessible<T> source;

        public RandomAccessibleLoader(RandomAccessible<T> source) {
            this.source = source;
        }

        public void load(SingleCellArrayImg<T, ?> cell) {
            Cursor s = Views.flatIterable((RandomAccessibleInterval)Views.interval(this.source, cell)).cursor();
            Cursor t = cell.cursor();
            while (s.hasNext()) {
                ((NativeType)t.next()).set((Type)s.next());
            }
        }
    }
}

