/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.linalg.eigen;

import net.imglib2.algorithm.linalg.eigen.EigenValues1D;
import net.imglib2.algorithm.linalg.eigen.EigenValues2DSquare;
import net.imglib2.algorithm.linalg.eigen.EigenValues2DSymmetric;
import net.imglib2.algorithm.linalg.eigen.EigenValuesSquare;
import net.imglib2.algorithm.linalg.eigen.EigenValuesSymmetric;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.composite.Composite;

public interface EigenValues<T extends RealType<T>, U extends ComplexType<U>> {
    public void compute(Composite<T> var1, Composite<U> var2);

    default public EigenValues<T, U> copy() {
        return this;
    }

    public static <T extends RealType<T>, U extends ComplexType<U>> EigenValues1D<T, U> oneDimensional() {
        return new EigenValues1D();
    }

    public static <T extends RealType<T>, U extends ComplexType<U>> EigenValues2DSquare<T, U> square2D() {
        return new EigenValues2DSquare();
    }

    public static <T extends RealType<T>, U extends ComplexType<U>> EigenValues2DSymmetric<T, U> symmetric2D() {
        return new EigenValues2DSymmetric();
    }

    public static <T extends RealType<T>, U extends ComplexType<U>> EigenValuesSquare<T, U> square(int nDim) {
        return new EigenValuesSquare(nDim);
    }

    public static <T extends RealType<T>, U extends ComplexType<U>> EigenValuesSymmetric<T, U> symmetric(int nDim) {
        return new EigenValuesSymmetric(nDim);
    }

    public static <T extends RealType<T>, U extends ComplexType<U>> EigenValues<T, U> invalid() {
        return (m, evs) -> {
            throw new UnsupportedOperationException("EigenValues not implemented yet!");
        };
    }
}

