/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.math.execution;

import java.util.Arrays;
import java.util.List;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.algorithm.math.abstractions.OFunction;
import net.imglib2.algorithm.math.abstractions.RandomAccessOnly;
import net.imglib2.converter.Converter;
import net.imglib2.type.numeric.RealType;

public class BlockReadingSource<I extends RealType<I>, O extends RealType<O>>
implements OFunction<O>,
RandomAccessOnly<I> {
    private final RandomAccessible<I> src;
    protected final RandomAccess<I> ra;
    protected final O scrap;
    protected final O tmp;
    private final Converter<RealType<?>, O> converter;
    protected final long[][] moves;
    protected final byte[] signs;

    public BlockReadingSource(O scrap, Converter<RealType<?>, O> converter, RandomAccessible<I> src, long[][] corners, byte[] signs) {
        this.scrap = scrap;
        this.tmp = (RealType)scrap.createVariable();
        this.src = src;
        this.converter = converter;
        this.ra = src.randomAccess();
        this.moves = new long[corners.length][corners[0].length];
        this.moves[0] = corners[0];
        for (int i = 1; i < corners.length; ++i) {
            for (int j = 0; j < corners[0].length; ++j) {
                this.moves[i][j] = corners[i][j] - corners[i - 1][j];
            }
        }
        this.signs = signs;
    }

    @Override
    public final O eval() {
        throw new UnsupportedOperationException();
    }

    @Override
    public O eval(Localizable loc) {
        this.ra.setPosition(loc);
        this.ra.move(this.moves[0]);
        this.converter.convert(this.ra.get(), this.scrap);
        this.scrap.mul((float)this.signs[0]);
        for (int i = 1; i < this.moves.length; ++i) {
            this.ra.move(this.moves[i]);
            this.converter.convert(this.ra.get(), this.tmp);
            if (1 == this.signs[i]) {
                this.scrap.add(this.tmp);
                continue;
            }
            this.scrap.sub(this.tmp);
        }
        return this.scrap;
    }

    @Override
    public List<OFunction<O>> children() {
        return Arrays.asList(new OFunction[0]);
    }

    @Override
    public final double evalDouble() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final double evalDouble(Localizable loc) {
        this.ra.setPosition(loc);
        double sum = 0.0;
        for (int i = 0; i < this.moves.length; ++i) {
            this.ra.move(this.moves[i]);
            sum += ((RealType)this.ra.get()).getRealDouble() * (double)this.signs[i];
        }
        return sum;
    }

    @Override
    public RandomAccessible<I> getRandomAccessible() {
        return this.src;
    }
}

