/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.neighborhood;

import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.neighborhood.RectangleNeighborhood;
import net.imglib2.algorithm.neighborhood.RectangleNeighborhoodFactory;
import net.imglib2.algorithm.neighborhood.RectangleNeighborhoodSkipCenter;
import net.imglib2.algorithm.neighborhood.RectangleNeighborhoodSkipCenterUnsafe;
import net.imglib2.algorithm.neighborhood.RectangleNeighborhoodUnsafe;
import net.imglib2.algorithm.neighborhood.RectangleShape;
import net.imglib2.algorithm.neighborhood.Shape;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;

public class CenteredRectangleShape
implements Shape {
    final int[] span;
    final boolean skipCenter;

    public CenteredRectangleShape(int[] span, boolean skipCenter) {
        this.span = span;
        this.skipCenter = skipCenter;
    }

    public <T> RectangleShape.NeighborhoodsIterableInterval<T> neighborhoods(RandomAccessibleInterval<T> source) {
        RectangleNeighborhoodFactory f = this.skipCenter ? RectangleNeighborhoodSkipCenterUnsafe.factory() : RectangleNeighborhoodUnsafe.factory();
        Interval spanInterval = this.createSpan();
        return new RectangleShape.NeighborhoodsIterableInterval<T>(source, spanInterval, f);
    }

    public <T> RectangleShape.NeighborhoodsAccessible<T> neighborhoodsRandomAccessible(RandomAccessible<T> source) {
        RectangleNeighborhoodFactory f = this.skipCenter ? RectangleNeighborhoodSkipCenterUnsafe.factory() : RectangleNeighborhoodUnsafe.factory();
        Interval spanInterval = this.createSpan();
        return new RectangleShape.NeighborhoodsAccessible<T>(source, spanInterval, f);
    }

    public <T> RectangleShape.NeighborhoodsIterableInterval<T> neighborhoodsSafe(RandomAccessibleInterval<T> source) {
        RectangleNeighborhoodFactory f = this.skipCenter ? RectangleNeighborhoodSkipCenter.factory() : RectangleNeighborhood.factory();
        Interval spanInterval = this.createSpan();
        return new RectangleShape.NeighborhoodsIterableInterval<T>(source, spanInterval, f);
    }

    public <T> RectangleShape.NeighborhoodsAccessible<T> neighborhoodsRandomAccessibleSafe(RandomAccessible<T> source) {
        RectangleNeighborhoodFactory f = this.skipCenter ? RectangleNeighborhoodSkipCenter.factory() : RectangleNeighborhood.factory();
        Interval spanInterval = this.createSpan();
        return new RectangleShape.NeighborhoodsAccessible<T>(source, spanInterval, f);
    }

    public boolean isSkippingCenter() {
        return this.skipCenter;
    }

    public int[] getSpan() {
        return (int[])this.span.clone();
    }

    public String toString() {
        return "CenteredRectangleShape, span = " + Util.printCoordinates((int[])this.span);
    }

    private Interval createSpan() {
        long[] min = new long[this.span.length];
        long[] max = new long[this.span.length];
        for (int d = 0; d < this.span.length; ++d) {
            min[d] = -this.span[d];
            max[d] = this.span[d];
        }
        return new FinalInterval(min, max);
    }

    @Override
    public Interval getStructuringElementBoundingBox(int numDimensions) {
        long[] a = new long[numDimensions];
        long[] b = new long[numDimensions];
        for (int i = 0; i < numDimensions; ++i) {
            a[i] = this.span[i] * -1;
            b[i] = this.span[i];
        }
        return Intervals.union((Interval)new FinalInterval(a, a), (Interval)new FinalInterval(b, b));
    }
}

