/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.neighborhood;

import java.util.Arrays;
import java.util.Iterator;
import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.AbstractInterval;
import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.FlatIterationOrder;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.neighborhood.HyperSphereNeighborhood;
import net.imglib2.algorithm.neighborhood.HyperSphereNeighborhoodCursor;
import net.imglib2.algorithm.neighborhood.HyperSphereNeighborhoodFactory;
import net.imglib2.algorithm.neighborhood.HyperSphereNeighborhoodRandomAccess;
import net.imglib2.algorithm.neighborhood.HyperSphereNeighborhoodUnsafe;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.algorithm.neighborhood.Shape;

public class HyperSphereShape
implements Shape {
    final long radius;

    public HyperSphereShape(long radius) {
        this.radius = radius;
    }

    public <T> NeighborhoodsIterableInterval<T> neighborhoods(RandomAccessibleInterval<T> source) {
        return new NeighborhoodsIterableInterval<T>(source, this.radius, HyperSphereNeighborhoodUnsafe.factory());
    }

    public <T> NeighborhoodsAccessible<T> neighborhoodsRandomAccessible(RandomAccessible<T> source) {
        return new NeighborhoodsAccessible<T>(source, this.radius, HyperSphereNeighborhoodUnsafe.factory());
    }

    public <T> NeighborhoodsIterableInterval<T> neighborhoodsSafe(RandomAccessibleInterval<T> source) {
        return new NeighborhoodsIterableInterval<T>(source, this.radius, HyperSphereNeighborhood.factory());
    }

    public <T> NeighborhoodsAccessible<T> neighborhoodsRandomAccessibleSafe(RandomAccessible<T> source) {
        return new NeighborhoodsAccessible<T>(source, this.radius, HyperSphereNeighborhood.factory());
    }

    public long getRadius() {
        return this.radius;
    }

    public String toString() {
        return "HyperSphereShape, radius = " + this.radius;
    }

    @Override
    public Interval getStructuringElementBoundingBox(int numDimensions) {
        long[] min = new long[numDimensions];
        Arrays.fill(min, -this.getRadius());
        long[] max = new long[numDimensions];
        Arrays.fill(max, this.getRadius());
        return new FinalInterval(min, max);
    }

    public static final class NeighborhoodsAccessible<T>
    extends AbstractEuclideanSpace
    implements RandomAccessible<Neighborhood<T>> {
        final RandomAccessible<T> source;
        final long radius;
        final HyperSphereNeighborhoodFactory<T> factory;

        public NeighborhoodsAccessible(RandomAccessible<T> source, long radius, HyperSphereNeighborhoodFactory<T> factory) {
            super(source.numDimensions());
            this.source = source;
            this.radius = radius;
            this.factory = factory;
        }

        public RandomAccess<Neighborhood<T>> randomAccess() {
            return new HyperSphereNeighborhoodRandomAccess<T>(this.source, this.radius, this.factory);
        }

        public RandomAccess<Neighborhood<T>> randomAccess(Interval interval) {
            return new HyperSphereNeighborhoodRandomAccess<T>(this.source, this.radius, this.factory, interval);
        }

        public Neighborhood<T> getType() {
            return (Neighborhood)this.randomAccess().getType();
        }
    }

    public static final class NeighborhoodsIterableInterval<T>
    extends AbstractInterval
    implements IterableInterval<Neighborhood<T>> {
        final RandomAccessibleInterval<T> source;
        final long radius;
        final long size;
        final HyperSphereNeighborhoodFactory<T> factory;

        public NeighborhoodsIterableInterval(RandomAccessibleInterval<T> source, long radius, HyperSphereNeighborhoodFactory<T> factory) {
            super(source);
            this.source = source;
            this.radius = radius;
            this.factory = factory;
            long s = source.dimension(0);
            for (int d = 1; d < this.n; ++d) {
                s *= source.dimension(d);
            }
            this.size = s;
        }

        public long size() {
            return this.size;
        }

        public Neighborhood<T> firstElement() {
            return (Neighborhood)this.cursor().next();
        }

        public Neighborhood<T> getType() {
            return (Neighborhood)this.cursor().getType();
        }

        public Object iterationOrder() {
            return new FlatIterationOrder((Interval)this);
        }

        public Iterator<Neighborhood<T>> iterator() {
            return this.cursor();
        }

        public Cursor<Neighborhood<T>> cursor() {
            return new HyperSphereNeighborhoodCursor<T>(this.source, this.radius, this.factory);
        }

        public Cursor<Neighborhood<T>> localizingCursor() {
            return this.cursor();
        }
    }
}

