/*
 * Decompiled with CFR 0.152.
 */
package bdv.img;

import bdv.viewer.Interpolation;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.render.DefaultMipmapOrdering;
import bdv.viewer.render.MipmapOrdering;
import java.util.function.Supplier;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.BoundingBoxEstimation;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.RealTransformRealRandomAccessible;
import net.imglib2.realtransform.RealTransformSequence;
import net.imglib2.realtransform.inverse.WrappedIterativeInvertibleRealTransform;
import net.imglib2.view.Views;

public class RealTransformedSource<T>
implements Source<T>,
MipmapOrdering {
    private final Source<T> source;
    private final String name;
    private final MipmapOrdering sourceMipmapOrdering;
    private InvertibleRealTransform xfm;
    private Interval[] boundingIntervalsPerLevel;
    private boolean isTransformed;
    private final Supplier<Boolean> boundingBoxCullingSupplier;
    private BoundingBoxEstimation bboxEst;

    public static <T> SourceAndConverter<T> wrap(SourceAndConverter<T> wrap, String name, int ndims) {
        return new SourceAndConverter(new RealTransformedSource<T>(wrap.getSpimSource(), name), wrap.getConverter(), wrap.asVolatile() == null ? null : RealTransformedSource.wrap(wrap.asVolatile(), name, ndims));
    }

    public RealTransformedSource(Source<T> source, String name) {
        this(source, name, null);
    }

    public RealTransformedSource(Source<T> source, String name, Supplier<Boolean> doBoundingBoxCulling) {
        this.source = source;
        this.name = name;
        this.isTransformed = false;
        this.boundingBoxCullingSupplier = doBoundingBoxCulling;
        this.xfm = null;
        this.bboxEst = new BoundingBoxEstimation(BoundingBoxEstimation.Method.FACES, 5);
        this.boundingIntervalsPerLevel = new Interval[source.getNumMipmapLevels()];
        this.sourceMipmapOrdering = MipmapOrdering.class.isInstance(source) ? (MipmapOrdering)source : new DefaultMipmapOrdering(source);
    }

    public boolean isPresent(int t) {
        return this.source.isPresent(t);
    }

    public boolean doBoundingBoxCulling() {
        if (this.boundingBoxCullingSupplier != null) {
            return this.boundingBoxCullingSupplier.get();
        }
        return !this.isTransformed && this.source.doBoundingBoxCulling();
    }

    public void updateTransform(RealTransform xfm) {
        this.xfm = xfm instanceof InvertibleRealTransform ? (InvertibleRealTransform)xfm : new WrappedIterativeInvertibleRealTransform(xfm);
        this.updateBoundingIntervals();
    }

    protected void updateBoundingIntervals() {
        for (int i = 0; i < this.getNumMipmapLevels(); ++i) {
            this.boundingIntervalsPerLevel[i] = this.estimateBoundingInterval(0, i);
        }
    }

    public void setIsTransformed(boolean isTransformed) {
        this.isTransformed = isTransformed;
    }

    public void setBoundingBoxEstimator(BoundingBoxEstimation bboxEst) {
        this.bboxEst = bboxEst;
    }

    public boolean isTransformed() {
        return this.isTransformed;
    }

    public Source<T> getWrappedSource() {
        return this.source;
    }

    public RandomAccessibleInterval<T> getSource(int t, int level) {
        if (this.isTransformed) {
            RealTransformRealRandomAccessible interpSrc = (RealTransformRealRandomAccessible)this.getInterpolatedSource(t, level, Interpolation.NEARESTNEIGHBOR);
            AffineTransform3D transform = new AffineTransform3D();
            this.source.getSourceTransform(t, level, transform);
            RealTransformSequence totalInverseTransform = new RealTransformSequence();
            totalInverseTransform.add((RealTransform)transform.inverse());
            totalInverseTransform.add((RealTransform)transform.inverse());
            totalInverseTransform.add((RealTransform)transform);
            return Views.interval((RandomAccessible)Views.raster((RealRandomAccessible)interpSrc), (Interval)this.boundingIntervalsPerLevel[level]);
        }
        return this.source.getSource(t, level);
    }

    private Interval estimateBoundingInterval(int t, int level) {
        if (this.xfm == null) {
            return this.source.getSource(t, level);
        }
        return this.bboxEst.estimatePixelInterval((RealTransform)this.xfm.copy().inverse(), (Interval)this.source.getSource(t, level));
    }

    public RealRandomAccessible<T> getInterpolatedSource(int t, int level, Interpolation method) {
        RealRandomAccessible realSrc = this.source.getInterpolatedSource(t, level, method);
        if (this.isTransformed && this.xfm != null) {
            AffineTransform3D transform = new AffineTransform3D();
            this.source.getSourceTransform(t, level, transform);
            RealTransformSequence totalTransform = new RealTransformSequence();
            totalTransform.add((RealTransform)transform.inverse());
            totalTransform.add((RealTransform)this.xfm);
            totalTransform.add((RealTransform)transform);
            return new RealTransformRealRandomAccessible(realSrc, (RealTransform)this.xfm);
        }
        return realSrc;
    }

    public synchronized void getSourceTransform(int t, int level, AffineTransform3D transform) {
        if (this.isTransformed) {
            transform.identity();
        } else {
            this.source.getSourceTransform(t, level, transform);
        }
    }

    public RealTransform getTransform() {
        return this.xfm;
    }

    public T getType() {
        return (T)this.source.getType();
    }

    public String getName() {
        return this.source.getName() + "_" + this.name;
    }

    public String getOriginalName() {
        return this.getWrappedSource().getName();
    }

    public VoxelDimensions getVoxelDimensions() {
        return this.source.getVoxelDimensions();
    }

    public int getNumMipmapLevels() {
        return this.source.getNumMipmapLevels();
    }

    public synchronized MipmapOrdering.MipmapHints getMipmapHints(AffineTransform3D screenTransform, int timepoint, int previousTimepoint) {
        return this.sourceMipmapOrdering.getMipmapHints(screenTransform, timepoint, previousTimepoint);
    }
}

