/*
 * Decompiled with CFR 0.152.
 */
package bigwarp.landmarks;

import bdv.gui.BigWarpMessageAnimator;
import bdv.viewer.TransformListener;
import bigwarp.landmarks.actions.AddPointEdit;
import bigwarp.landmarks.actions.DeleteRowEdit;
import bigwarp.landmarks.actions.LandmarkUndoManager;
import bigwarp.landmarks.actions.ModifyPointEdit;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import com.opencsv.CSVReader;
import com.opencsv.CSVWriter;
import com.opencsv.exceptions.CsvException;
import java.awt.Color;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import jitk.spline.ThinPlateR2LogRSplineKernelTransform;
import net.imglib2.RealLocalizable;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.InvertibleWrapped2DTransformAs3D;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.inverse.WrappedIterativeInvertibleRealTransform;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.SerializationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LandmarkTableModel
extends AbstractTableModel
implements TransformListener<InvertibleRealTransform> {
    private static final long serialVersionUID = -5865789085410559166L;
    private final double[] PENDING_PT;
    public static final int NAMECOLUMN = 0;
    public static final int ACTIVECOLUMN = 1;
    public static Color WARNINGBGCOLOR = new Color(255, 204, 0);
    public static Color DEFAULTBGCOLOR = new Color(255, 255, 255);
    private boolean DEBUG = false;
    protected int ndims = 3;
    protected int numCols = 8;
    protected int numRows = 0;
    protected int nextRowP = 0;
    protected int nextRowQ = 0;
    protected int numActive = 0;
    protected ArrayList<String> names;
    protected ArrayList<Boolean> activeList;
    protected ArrayList<Double[]> movingPts;
    protected ArrayList<Double[]> targetPts;
    protected ArrayList<Integer> tableIndexToActiveIndex;
    protected boolean pointUpdatePending = false;
    protected boolean pointUpdatePendingMoving = false;
    protected Double[] pointToOverride;
    protected ArrayList<Boolean> doesPointHaveAndNeedWarp;
    protected ArrayList<Integer> indicesOfChangedPoints;
    protected boolean elementDeleted = false;
    protected ArrayList<Boolean> needsInverse;
    protected ArrayList<Boolean> movingDisplayPointUnreliable;
    protected ThinPlateR2LogRSplineKernelTransform estimatedXfm;
    protected ArrayList<Double[]> warpedPoints;
    protected int maxInverseIterations = 500;
    protected double inverseThreshold = 0.5;
    protected double[] lastPoint;
    protected double[] tmp;
    protected LandmarkUndoManager undoRedoManager;
    protected BigWarpMessageAnimator message;
    protected boolean modifiedSinceLastSave;
    static final String[] columnNames3d = new String[]{"Name", "Active", "mvg-x", "mvg-y", "mvg-z", "fix-x", "fix-y", "fix-z"};
    static final String[] columnNames2d = new String[]{"Name", "Active", "mvg-x", "mvg-y", "fix-x", "fix-y"};
    final String[] columnNames;
    public final Logger logger = LoggerFactory.getLogger(LandmarkTableModel.class);

    public LandmarkTableModel(int ndims) {
        this.ndims = ndims;
        this.PENDING_PT = new double[ndims];
        Arrays.fill(this.PENDING_PT, Double.POSITIVE_INFINITY);
        this.lastPoint = this.PENDING_PT;
        this.names = new ArrayList();
        this.activeList = new ArrayList();
        this.tableIndexToActiveIndex = new ArrayList();
        this.movingPts = new ArrayList();
        this.targetPts = new ArrayList();
        this.pointToOverride = new Double[ndims];
        Arrays.fill((Object[])this.pointToOverride, (Object)Double.POSITIVE_INFINITY);
        if (ndims == 2) {
            this.columnNames = columnNames2d;
            this.numCols = 6;
        } else {
            this.columnNames = columnNames3d;
        }
        this.warpedPoints = new ArrayList();
        this.doesPointHaveAndNeedWarp = new ArrayList();
        this.movingDisplayPointUnreliable = new ArrayList();
        this.indicesOfChangedPoints = new ArrayList();
        this.needsInverse = new ArrayList();
        this.setTableListener();
        this.undoRedoManager = new LandmarkUndoManager();
        this.estimatedXfm = new ThinPlateR2LogRSplineKernelTransform(ndims);
        this.tmp = new double[3];
    }

    public void setMessage(BigWarpMessageAnimator message) {
        this.message = message;
    }

    public int getNumdims() {
        return this.ndims;
    }

    public double[] getPendingPoint() {
        return this.PENDING_PT;
    }

    @Deprecated
    public ThinPlateR2LogRSplineKernelTransform getTransform() {
        return this.estimatedXfm;
    }

    @Deprecated
    public void printDistances() {
        for (int i = 0; i < this.numRows; ++i) {
            System.out.println("");
            for (int d = 0; d < this.ndims; ++d) {
                System.out.print(" " + (this.movingPts.get(i)[this.ndims + d] - this.estimatedXfm.getSourceLandmarks()[d][i]));
                System.out.print(" " + (this.targetPts.get(i)[this.ndims + d] - this.estimatedXfm.getSourceLandmarks()[d][i]));
            }
        }
    }

    public void printState() {
        System.out.println("nextRowP: " + this.nextRowP);
        System.out.println("nextRowQ: " + this.nextRowQ);
    }

    public String toString() {
        String str = "";
        for (int i = 0; i < this.numRows; ++i) {
            str = str + Arrays.toString((Object[])this.movingPts.get(i)) + " -> " + Arrays.toString((Object[])this.targetPts.get(i)) + "\n";
        }
        return str;
    }

    @Deprecated
    public boolean validateTransformPoints() {
        for (int i = 0; i < this.numRows; ++i) {
            for (int d = 0; d < this.ndims; ++d) {
                if (this.targetPts.get(i)[d] == this.estimatedXfm.getSourceLandmarks()[d][i]) continue;
                System.out.println("Wrong for pt: " + i);
                return false;
            }
        }
        return true;
    }

    public void setTableListener() {
        this.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (LandmarkTableModel.this.estimatedXfm != null && e.getColumn() == 1 && e.getType() == 0) {
                    int row = e.getFirstRow();
                    LandmarkTableModel.this.indicesOfChangedPoints.add(row);
                }
            }
        });
    }

    public boolean isModifiedSinceSave() {
        return this.modifiedSinceLastSave;
    }

    protected void importTransformation(File ffwd, File finv) throws IOException {
        byte[] data = FileUtils.readFileToByteArray((File)ffwd);
        this.estimatedXfm = (ThinPlateR2LogRSplineKernelTransform)SerializationUtils.deserialize((byte[])data);
    }

    protected void exportTransformation(File ffwd, File finv) throws IOException {
        byte[] data = SerializationUtils.serialize((Serializable)this.estimatedXfm);
        FileUtils.writeByteArrayToFile((File)ffwd, (byte[])data);
    }

    public boolean isPointUpdatePending() {
        return this.pointUpdatePending;
    }

    public boolean isPointUpdatePendingMoving() {
        return this.pointUpdatePendingMoving;
    }

    public void restorePendingUpdate() {
        ArrayList<Double[]> pts;
        int i = 0;
        if (this.pointUpdatePendingMoving) {
            i = this.nextRowP;
            pts = this.movingPts;
        } else {
            i = this.nextRowQ;
            pts = this.movingPts;
        }
        for (int d = 0; d < this.ndims; ++d) {
            pts.get((int)i)[d] = this.pointToOverride[d];
        }
        this.activeList.set(i, true);
        this.buildTableToActiveIndex();
        this.pointUpdatePending = false;
        this.fireTableRowsUpdated(i, i);
    }

    @Override
    public int getColumnCount() {
        return this.numCols;
    }

    @Override
    public int getRowCount() {
        return this.numRows;
    }

    public int getActiveRowCount() {
        return this.numActive;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public ArrayList<Double[]> getPoints(boolean moving) {
        if (moving) {
            return this.movingPts;
        }
        return this.targetPts;
    }

    public ArrayList<String> getNames() {
        return this.names;
    }

    public void setColumnName(int row, String name) {
        this.names.set(row, name);
        this.fireTableCellUpdated(row, 0);
    }

    public boolean getIsActive(int row) {
        return this.activeList.get(row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIsActive(int row, boolean isActive) {
        LandmarkTableModel landmarkTableModel = this;
        synchronized (landmarkTableModel) {
            if (this.isRowUnpaired(row) && isActive) {
                if (this.message != null) {
                    this.message.showMessage("Can't activate unpaired row ( " + this.names.get(row) + " )");
                }
                return;
            }
            this.activeList.set(row, isActive);
            this.buildTableToActiveIndex();
        }
        if (this.activeList.get(row) != isActive) {
            this.fireTableCellUpdated(row, 1);
            this.modifiedSinceLastSave = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildTableToActiveIndex() {
        LandmarkTableModel landmarkTableModel = this;
        synchronized (landmarkTableModel) {
            this.tableIndexToActiveIndex.clear();
            int N = 0;
            int j = 0;
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!this.isActive(i)) continue;
                this.tableIndexToActiveIndex.add(j++);
                ++N;
            }
            this.numActive = N;
        }
    }

    public int getActiveIndex(int tableIndex) {
        return this.tableIndexToActiveIndex.get(tableIndex);
    }

    @Override
    public Class<?> getColumnClass(int col) {
        if (col == 0) {
            return String.class;
        }
        if (col == 1) {
            return Boolean.class;
        }
        return Double.class;
    }

    public boolean isActive(int i) {
        if (i < 0 || i >= this.getRowCount()) {
            return false;
        }
        return (Boolean)this.getValueAt(i, 1);
    }

    public void clear() {
        for (int i = this.getRowCount() - 1; i >= 0; --i) {
            this.deleteRow(i);
        }
    }

    public void deleteRow(int i) {
        if (this.getRowCount() > 0 && i >= 0) {
            this.undoRedoManager.addEdit(new DeleteRowEdit(this, i));
            this.deleteRowHelper(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRowHelper(int i) {
        LandmarkTableModel landmarkTableModel = this;
        synchronized (landmarkTableModel) {
            if (i >= this.names.size()) {
                return;
            }
            this.names.remove(i);
            this.movingPts.remove(i);
            this.targetPts.remove(i);
            this.activeList.remove(i);
            if (this.indicesOfChangedPoints.contains(i)) {
                this.indicesOfChangedPoints.remove(this.indicesOfChangedPoints.indexOf(i));
            }
            this.doesPointHaveAndNeedWarp.remove(i);
            this.movingDisplayPointUnreliable.remove(i);
            this.warpedPoints.remove(i);
            --this.numRows;
            this.pointUpdatePending = this.isUpdatePending();
            this.nextRowP = this.numRows;
            this.nextRowQ = this.numRows;
            this.fireTableRowsDeleted(i, i);
            this.modifiedSinceLastSave = true;
            this.buildTableToActiveIndex();
        }
    }

    public boolean isRowUnpaired(int i) {
        for (int d = 0; d < this.ndims; ++d) {
            if (!Double.isInfinite(this.movingPts.get(i)[d]) && !Double.isInfinite(this.targetPts.get(i)[d])) continue;
            return true;
        }
        return false;
    }

    public boolean isUpdatePending() {
        for (int i = 0; i < this.movingPts.size(); ++i) {
            if (!this.isRowUnpaired(i)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNextRow(boolean isMoving, int row) {
        LandmarkTableModel landmarkTableModel = this;
        synchronized (landmarkTableModel) {
            if (isMoving) {
                this.nextRowP = row;
            } else {
                this.nextRowQ = row;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNextRows(int lastAddedIndex) {
        LandmarkTableModel landmarkTableModel = this;
        synchronized (landmarkTableModel) {
            this.nextRowP = this.numRows;
            this.nextRowQ = this.numRows;
            this.pointUpdatePendingMoving = false;
            for (int i = lastAddedIndex; i < this.numRows; ++i) {
                if (Double.isInfinite(this.movingPts.get(i)[0])) {
                    this.pointUpdatePendingMoving = true;
                    if (i < this.nextRowP) {
                        this.nextRowP = i;
                    }
                    this.setIsActive(i, false);
                }
                if (!Double.isInfinite(this.targetPts.get(i)[0])) continue;
                this.pointUpdatePendingMoving = true;
                if (i < this.nextRowQ) {
                    this.nextRowQ = i;
                }
                this.setIsActive(i, false);
            }
            if (lastAddedIndex > 0 && !this.pointUpdatePendingMoving) {
                this.updateNextRows(0);
            }
            this.logger.trace(" updateNextRows  - moving: " + this.nextRowP + "  -  target:  " + this.nextRowQ);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextRow(boolean isMoving) {
        LandmarkTableModel landmarkTableModel = this;
        synchronized (landmarkTableModel) {
            if (isMoving) {
                return this.nextRowP;
            }
            return this.nextRowQ;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean isWarped(int i) {
        LandmarkTableModel landmarkTableModel = this;
        synchronized (landmarkTableModel) {
            return this.doesPointHaveAndNeedWarp.get(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWarpedPoint(int i, double[] pt) {
        LandmarkTableModel landmarkTableModel = this;
        synchronized (landmarkTableModel) {
            if (pt == null) {
                return;
            }
            for (int d = 0; d < this.ndims; ++d) {
                this.warpedPoints.get((int)i)[d] = pt[d];
            }
            this.doesPointHaveAndNeedWarp.set(i, true);
        }
    }

    public void printWarpedPoints() {
        String s = "";
        int N = this.doesPointHaveAndNeedWarp.size();
        for (int i = 0; i < N; ++i) {
            if (!this.doesPointHaveAndNeedWarp.get(i).booleanValue()) continue;
            s = s + String.format("%04d : ", i);
            for (int d = 0; d < this.ndims; ++d) {
                s = s + String.format("%f\t", this.warpedPoints.get(i)[d]);
            }
            s = s + "\n";
        }
        System.out.println(s);
    }

    public ArrayList<Double[]> getWarpedPoints() {
        return this.warpedPoints;
    }

    public ArrayList<Boolean> getChangedSinceWarp() {
        return this.doesPointHaveAndNeedWarp;
    }

    public void resetWarpedPoint(int i) {
        if (this.activeList.get(i).booleanValue()) {
            this.doesPointHaveAndNeedWarp.set(i, false);
        }
    }

    public void resetWarpedPoints() {
        for (int i = 0; i < this.doesPointHaveAndNeedWarp.size(); ++i) {
            this.resetWarpedPoint(i);
        }
    }

    public void resetNeedsInverse() {
        Collections.fill(this.needsInverse, false);
    }

    public void setNeedsInverse(int i) {
        this.needsInverse.set(i, true);
    }

    public boolean rowNeedsWarning(int row) {
        return this.movingDisplayPointUnreliable.get(row);
    }

    protected void firePointUpdated(int row, boolean isMoving) {
        this.modifiedSinceLastSave = true;
        for (int d = 0; d < this.ndims; ++d) {
            this.fireTableCellUpdated(row, 2 + d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEmptyRow(int index) {
        LandmarkTableModel landmarkTableModel = this;
        synchronized (landmarkTableModel) {
            Object[] movingPt = new Double[this.ndims];
            Object[] targetPt = new Double[this.ndims];
            Arrays.fill(targetPt, (Object)Double.POSITIVE_INFINITY);
            Arrays.fill(movingPt, (Object)Double.POSITIVE_INFINITY);
            this.movingPts.add(index, (Double[])movingPt);
            this.targetPts.add(index, (Double[])targetPt);
            this.names.add(index, this.nextName(index));
            this.activeList.add(index, false);
            this.warpedPoints.add(index, new Double[this.ndims]);
            this.doesPointHaveAndNeedWarp.add(index, false);
            this.movingDisplayPointUnreliable.add(index, false);
            this.tableIndexToActiveIndex.add(-1);
            ++this.numRows;
            this.modifiedSinceLastSave = true;
        }
        this.fireTableRowsInserted(index, index);
    }

    public void clearPt(int row, boolean isMoving) {
        this.pointEdit(row, this.PENDING_PT, false, isMoving, null, true);
    }

    public boolean add(double[] pt, boolean isMoving) {
        return this.pointEdit(-1, pt, true, isMoving, false, true, null);
    }

    public boolean add(double[] mvg, double[] tgt) {
        this.add(mvg, true);
        this.setPoint(this.numRows - 1, false, tgt, null);
        return true;
    }

    public boolean add(double[] pt, boolean isMoving, RealTransform xfm) {
        return this.pointEdit(-1, pt, true, isMoving, false, true, xfm);
    }

    public void setPoint(int row, boolean isMoving, double[] pt, RealTransform xfm) {
        this.setPoint(row, isMoving, pt, true, xfm);
    }

    public void setPoint(int row, boolean isMoving, double[] pt, boolean isUndoable, RealTransform xfm) {
        this.pointEdit(row, pt, false, isMoving, false, isUndoable, xfm);
    }

    public boolean pointEdit(int index, double[] pt, boolean forceAdd, boolean isMoving, boolean isWarped, boolean isUndoable, RealTransform xfm) {
        if (isWarped) {
            xfm.apply(pt, this.tmp);
            return this.pointEdit(index, this.tmp, forceAdd, isMoving, pt, isUndoable);
        }
        return this.pointEdit(index, pt, forceAdd, isMoving, null, isUndoable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pointEdit(int index, double[] pt, boolean forceAdd, boolean isMoving, double[] warpedPt, boolean isUndoable) {
        boolean isAdd;
        LandmarkTableModel landmarkTableModel = this;
        synchronized (landmarkTableModel) {
            if (index == -1) {
                index = isMoving ? this.nextRowP : this.nextRowQ;
            }
            boolean bl = isAdd = forceAdd || index == this.getRowCount();
            if (isAdd) {
                this.addEmptyRow(index);
            }
            double[] oldpt = LandmarkTableModel.copy(this.PENDING_PT);
            if (!isAdd) {
                oldpt = this.lastPoint != this.PENDING_PT ? LandmarkTableModel.copy(this.lastPoint) : (isMoving ? LandmarkTableModel.toPrimitive(this.movingPts.get(index)) : LandmarkTableModel.toPrimitive(this.targetPts.get(index)));
            }
            ArrayList<Double[]> pts = isMoving ? this.movingPts : this.targetPts;
            Double[] exPts = new Double[this.ndims];
            for (int i = 0; i < this.ndims; ++i) {
                exPts[i] = pt[i];
            }
            pts.set(index, exPts);
            if (isMoving && warpedPt != null) {
                this.updateWarpedPoint(index, warpedPt);
            } else {
                this.resetWarpedPoint(index);
            }
            if (isUndoable) {
                if (isAdd) {
                    this.undoRedoManager.addEdit(new AddPointEdit(this, index, pt, isMoving));
                } else {
                    this.undoRedoManager.addEdit(new ModifyPointEdit(this, index, oldpt, pt, isMoving));
                }
                this.lastPoint = this.PENDING_PT;
            } else if (this.lastPoint == this.PENDING_PT) {
                this.lastPoint = oldpt;
            }
            this.updateNextRows(index);
            this.activateRow(index);
        }
        this.firePointUpdated(index, isMoving);
        return isAdd;
    }

    public void setLastPoint(int i, boolean isMoving) {
        this.lastPoint = isMoving ? LandmarkTableModel.toPrimitive(this.movingPts.get(i)) : LandmarkTableModel.toPrimitive(this.targetPts.get(i));
    }

    public void resetLastPoint() {
        this.lastPoint = this.PENDING_PT;
    }

    public void updateAllWarpedPoints(InvertibleRealTransform xfm) {
        InvertibleRealTransform xfmToUse = xfm instanceof InvertibleWrapped2DTransformAs3D && this.ndims == 2 ? ((InvertibleWrapped2DTransformAs3D)xfm).transform : xfm;
        for (int i = 0; i < this.numRows; ++i) {
            if (this.isFixedPoint(i) || !this.isMovingPoint(i)) continue;
            this.computeWarpedPoint(i, xfmToUse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeWarpedPoint(int i, InvertibleRealTransform xfm) {
        LandmarkTableModel landmarkTableModel = this;
        synchronized (landmarkTableModel) {
            if (!this.isFixedPoint(i) && this.isMovingPoint(i) && xfm != null) {
                double[] tgt = LandmarkTableModel.toPrimitive(this.movingPts.get(i));
                double[] warpedPt = new double[this.ndims];
                xfm.applyInverse(warpedPt, tgt);
                if (xfm instanceof WrappedIterativeInvertibleRealTransform) {
                    WrappedIterativeInvertibleRealTransform inv = (WrappedIterativeInvertibleRealTransform)xfm;
                    double error = inv.getOptimzer().getError();
                    if (error > this.inverseThreshold) {
                        this.movingDisplayPointUnreliable.set(i, true);
                        this.message.showMessage(String.format("Warning: location of moving point %s in warped space is innacurate", this.names.get(i)));
                    } else {
                        this.movingDisplayPointUnreliable.set(i, false);
                    }
                }
                this.updateWarpedPoint(i, warpedPt);
            }
        }
    }

    public void setMaxInverseIterations(int maxIters) {
        this.maxInverseIterations = maxIters;
    }

    public void setInverseThreshold(double inverseThreshold) {
        this.inverseThreshold = inverseThreshold;
    }

    public int getIndexNearestTo(double[] pt, boolean isMoving) {
        double minDist = Double.MAX_VALUE;
        int minIndex = -1;
        for (int i = 0; i < this.numRows; ++i) {
            Double[] p = this.getPoint(isMoving, i);
            double thisdist = this.squaredDistance(p, pt);
            if (!(thisdist < minDist)) continue;
            minDist = thisdist;
            minIndex = i;
        }
        return minIndex;
    }

    public double squaredDistance(Double[] p, double[] q) {
        double dist = 0.0;
        for (int j = 0; j < p.length; ++j) {
            dist += (p[j] - q[j]) * (p[j] - q[j]);
        }
        return dist;
    }

    public int getIndexNearestTo(RealLocalizable pt, boolean isMoving) {
        double minDist = Double.MAX_VALUE;
        int minIndex = -1;
        for (int i = 0; i < this.numRows; ++i) {
            Double[] p = this.getPoint(isMoving, i);
            double thisdist = this.squaredDistance(p, pt);
            if (!(thisdist < minDist)) continue;
            minDist = thisdist;
            minIndex = i;
        }
        return minIndex;
    }

    public double squaredDistance(Double[] p, RealLocalizable q) {
        double dist = 0.0;
        for (int j = 0; j < p.length; ++j) {
            dist += (p[j] - q.getDoublePosition(j)) * (p[j] - q.getDoublePosition(j));
        }
        return dist;
    }

    public Double[] getPoint(boolean isMoving, int index) {
        if (isMoving) {
            return this.movingPts.get(index);
        }
        return this.targetPts.get(index);
    }

    public Double[] getMovingPoint(int index) {
        return this.movingPts.get(index);
    }

    public Double[] getFixedPoint(int index) {
        return this.targetPts.get(index);
    }

    public ArrayList<Double[]> getMovingPoints() {
        return this.movingPts;
    }

    public ArrayList<Double[]> getFixedPoints() {
        return this.targetPts;
    }

    public ArrayList<double[]> getMovingPointsCopy() {
        ArrayList<double[]> out = new ArrayList<double[]>();
        for (Double[] p : this.movingPts) {
            double[] q = new double[this.ndims];
            for (int d = 0; d < this.ndims; ++d) {
                q[d] = p[d];
            }
            out.add(q);
        }
        return out;
    }

    public ArrayList<double[]> getFixedPointsCopy() {
        ArrayList<double[]> out = new ArrayList<double[]>();
        for (Double[] p : this.targetPts) {
            double[] q = new double[this.ndims];
            for (int d = 0; d < this.ndims; ++d) {
                q[d] = p[d];
            }
            out.add(q);
        }
        return out;
    }

    public boolean isMovingPoint(int index) {
        return !Double.isInfinite(this.movingPts.get(index)[0]);
    }

    public boolean isFixedPoint(int index) {
        return !Double.isInfinite(this.targetPts.get(index)[0]);
    }

    public boolean isFixedPoint(int index, boolean isMoving) {
        if (isMoving) {
            return this.isMovingPoint(index);
        }
        return this.isFixedPoint(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateRow(int index) {
        boolean changed = false;
        LandmarkTableModel landmarkTableModel = this;
        synchronized (landmarkTableModel) {
            boolean activate = true;
            for (int d = 0; d < this.ndims; ++d) {
                if (!this.isMovingPoint(index)) {
                    activate = false;
                    break;
                }
                if (this.isFixedPoint(index)) continue;
                activate = false;
                break;
            }
            boolean bl = changed = activate != this.activeList.get(index);
            if (changed) {
                this.activeList.set(index, activate);
                this.buildTableToActiveIndex();
            }
        }
        if (changed) {
            this.fireTableCellUpdated(index, 1);
        }
    }

    private String nextName(int index) {
        String s;
        if (index == 0) {
            s = "Pt-0";
        } else {
            int i = index;
            try {
                i = 1 + Integer.parseInt(this.names.get(index - 1).replaceAll("Pt-", ""));
            }
            catch (Exception exception) {
                // empty catch block
            }
            s = String.format("Pt-%d", i);
        }
        return s;
    }

    private void markAsChanged(int index) {
        for (int i = 0; i < this.numRows; ++i) {
            if (this.indicesOfChangedPoints.contains(i)) continue;
            this.indicesOfChangedPoints.add(i);
        }
    }

    public void resetUpdated() {
        this.indicesOfChangedPoints.clear();
        this.elementDeleted = false;
    }

    @Deprecated
    public void transferUpdatesToModel() {
        if (this.estimatedXfm == null) {
            return;
        }
        this.initTransformation();
        this.resetUpdated();
    }

    public void load(File f) throws IOException {
        this.load(f, false);
    }

    public void load(File f, boolean invert) throws IOException {
        if (f.getCanonicalPath().endsWith("csv")) {
            this.loadCsv(f, invert);
        } else if (f.getCanonicalPath().endsWith("json")) {
            this.fromJson(f);
        }
    }

    public static LandmarkTableModel loadFromCsv(File f, boolean invert) throws IOException {
        CSVReader reader = new CSVReader((Reader)new FileReader(f.getAbsolutePath()));
        List rows = null;
        try {
            rows = reader.readAll();
            reader.close();
        }
        catch (CsvException csvException) {
            // empty catch block
        }
        LandmarkTableModel ltm = null;
        if (((String[])rows.get(0)).length == 6) {
            ltm = new LandmarkTableModel(2);
        } else if (((String[])rows.get(0)).length == 8) {
            ltm = new LandmarkTableModel(3);
        }
        if (ltm != null) {
            ltm.loadCsvHelper(invert, rows);
        }
        return ltm;
    }

    public void loadCsv(File f, boolean invert) throws IOException {
        CSVReader reader = new CSVReader((Reader)new FileReader(f.getAbsolutePath()));
        List rows = null;
        try {
            rows = reader.readAll();
            reader.close();
        }
        catch (CsvException csvException) {
            // empty catch block
        }
        this.loadCsvHelper(invert, rows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadCsvHelper(boolean invert, List<String[]> rows) throws IOException {
        LandmarkTableModel landmarkTableModel = this;
        synchronized (landmarkTableModel) {
            this.clear();
            if (rows == null || rows.size() < 1) {
                System.err.println("Error reading csv");
                return;
            }
            int ndims = 3;
            int expectedRowLength = 8;
            int i = 0;
            for (String[] row : rows) {
                int d;
                if (i == 0 && row.length == 6) {
                    ndims = 2;
                    expectedRowLength = 6;
                }
                if (row.length != expectedRowLength) {
                    throw new IOException("Invalid file - not enough columns");
                }
                this.names.add(row[0]);
                this.activeList.add(Boolean.parseBoolean(row[1]));
                Double[] movingPt = new Double[ndims];
                Double[] targetPt = new Double[ndims];
                int k = 2;
                for (d = 0; d < ndims; ++d) {
                    movingPt[d] = Double.parseDouble(row[k++]);
                }
                for (d = 0; d < ndims; ++d) {
                    targetPt[d] = Double.parseDouble(row[k++]);
                }
                if (invert) {
                    this.movingPts.add(targetPt);
                    this.targetPts.add(movingPt);
                } else {
                    this.movingPts.add(movingPt);
                    this.targetPts.add(targetPt);
                }
                this.warpedPoints.add(new Double[ndims]);
                this.doesPointHaveAndNeedWarp.add(false);
                this.movingDisplayPointUnreliable.add(false);
                ++i;
            }
            this.ndims = ndims;
            this.numRows = i;
            this.updateNextRows(0);
            this.buildTableToActiveIndex();
        }
        for (int i = 0; i < this.numRows; ++i) {
            this.fireTableRowsInserted(i, i);
        }
    }

    public int numActive() {
        return this.numActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyPointSafe(double[] point, int index, boolean moving) {
        LandmarkTableModel landmarkTableModel = this;
        synchronized (landmarkTableModel) {
            if (index >= this.getRowCount()) {
                return false;
            }
            for (int d = 0; d < point.length && d < this.ndims; ++d) {
                point[d] = moving ? this.movingPts.get(index)[d].doubleValue() : this.targetPts.get(index)[d].doubleValue();
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyMovingPointSafe(double[] point, int index) {
        LandmarkTableModel landmarkTableModel = this;
        synchronized (landmarkTableModel) {
            if (index >= this.movingPts.size()) {
                return false;
            }
            for (int d = 0; d < point.length && d < this.ndims; ++d) {
                point[d] = this.movingPts.get(index)[d];
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyWarpedPointSafe(double[] point, int index) {
        LandmarkTableModel landmarkTableModel = this;
        synchronized (landmarkTableModel) {
            if (index >= this.warpedPoints.size()) {
                return false;
            }
            for (int d = 0; d < point.length && d < this.ndims; ++d) {
                point[d] = this.warpedPoints.get(index)[d];
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyTargetPointSafe(double[] point, int index) {
        LandmarkTableModel landmarkTableModel = this;
        synchronized (landmarkTableModel) {
            if (index >= this.targetPts.size()) {
                return false;
            }
            for (int d = 0; d < point.length && d < this.ndims; ++d) {
                point[d] = this.targetPts.get(index)[d];
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyMovingLandmarks(int tableIndex, double[][] destination) {
        LandmarkTableModel landmarkTableModel = this;
        synchronized (landmarkTableModel) {
            for (int i = 0; i < this.numRows && i < destination.length; ++i) {
                for (int d = 0; d < this.ndims && d < destination[i].length; ++d) {
                    destination[i][d] = this.movingPts.get(i)[d];
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyWarpedMovingLandmarks(int tableIndex, double[][] destination) {
        LandmarkTableModel landmarkTableModel = this;
        synchronized (landmarkTableModel) {
            for (int i = 0; i < this.numRows && i < destination.length; ++i) {
                for (int d = 0; d < this.ndims && d < destination[i].length; ++d) {
                    destination[i][d] = this.warpedPoints.get(i)[d];
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTargetLandmarks(double[][] destination) {
        LandmarkTableModel landmarkTableModel = this;
        synchronized (landmarkTableModel) {
            for (int i = 0; i < this.numRows && i < destination.length; ++i) {
                for (int d = 0; d < this.ndims && d < destination[i].length; ++d) {
                    destination[i][d] = this.targetPts.get(i)[d];
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyLandmarks(int tableIndex, double[][] movingLandmarks, double[][] targetLandmarks) {
        LandmarkTableModel landmarkTableModel = this;
        synchronized (landmarkTableModel) {
            if (this.numActive != movingLandmarks[0].length) {
                System.out.println("copy landmarks INCONSISTENCY");
            }
            if (this.activeList.get(tableIndex).booleanValue()) {
                int activeIndex = this.getActiveIndex(tableIndex);
                for (int d = 0; d < this.ndims; ++d) {
                    movingLandmarks[d][activeIndex] = this.movingPts.get(tableIndex)[d];
                    targetLandmarks[d][activeIndex] = this.targetPts.get(tableIndex)[d];
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyLandmarks(double[][] movingLandmarks, double[][] targetLandmarks) {
        this.logger.trace(String.format("copyLandmarks. nActive=%d.  sizes = %d x %d ; %d x %d ", this.numActive, movingLandmarks.length, movingLandmarks[0].length, targetLandmarks.length, targetLandmarks[0].length));
        LandmarkTableModel landmarkTableModel = this;
        synchronized (landmarkTableModel) {
            int k = 0;
            for (int i = 0; i < this.numRows; ++i) {
                if (!this.activeList.get(i).booleanValue()) continue;
                for (int d = 0; d < this.ndims; ++d) {
                    movingLandmarks[d][k] = this.movingPts.get(i)[d];
                    targetLandmarks[d][k] = this.targetPts.get(i)[d];
                }
                ++k;
            }
        }
    }

    @Deprecated
    public void initTransformation() {
        int numActive = this.numActive();
        double[][] mvgPts = new double[this.ndims][numActive];
        double[][] tgtPts = new double[this.ndims][numActive];
        this.copyLandmarks(mvgPts, tgtPts);
        this.estimatedXfm = new ThinPlateR2LogRSplineKernelTransform(this.ndims, tgtPts, mvgPts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File f) throws IOException {
        CSVWriter csvWriter = new CSVWriter((Writer)new FileWriter(f.getAbsoluteFile()));
        LandmarkTableModel landmarkTableModel = this;
        synchronized (landmarkTableModel) {
            int N = this.names.size();
            ArrayList<String[]> rows = new ArrayList<String[]>(N);
            int rowLength = 2 * this.ndims + 2;
            for (int i = 0; i < N; ++i) {
                String[] row = new String[rowLength];
                row[0] = this.names.get(i);
                row[1] = this.activeList.get(i).toString();
                int k = 2;
                int j = 0;
                while (j < this.ndims) {
                    row[k++] = this.movingPts.get(i)[j++].toString();
                }
                j = 0;
                while (j < this.ndims) {
                    row[k++] = this.targetPts.get(i)[j++].toString();
                }
                rows.add(row);
            }
            csvWriter.writeAll(rows);
            csvWriter.close();
            this.modifiedSinceLastSave = false;
        }
    }

    public JsonElement toJson() {
        Gson gson = new GsonBuilder().serializeSpecialFloatingPointValues().create();
        JsonObject out = new JsonObject();
        JsonElement mvgPtsObj = gson.toJsonTree(this.getMovingPoints(), new TypeToken<List<Double[]>>(){}.getType());
        JsonElement fixedPtsObj = gson.toJsonTree(this.getFixedPoints(), new TypeToken<List<Double[]>>(){}.getType());
        JsonElement activeObj = gson.toJsonTree(this.activeList);
        JsonElement namesObj = gson.toJsonTree(this.names);
        out.add("type", (JsonElement)new JsonPrimitive("BigWarpLandmarks"));
        out.add("numDimensions", (JsonElement)new JsonPrimitive((Number)this.ndims));
        out.add("movingPoints", mvgPtsObj);
        out.add("fixedPoints", fixedPtsObj);
        out.add("active", activeObj);
        out.add("names", namesObj);
        return out;
    }

    public void fromJson(File f) {
        Gson gson = new Gson();
        OpenOption[] options = new OpenOption[]{StandardOpenOption.READ};
        try {
            Reader reader = Channels.newReader((ReadableByteChannel)FileChannel.open(Paths.get(f.getCanonicalPath(), new String[0]), options), StandardCharsets.UTF_8.name());
            this.fromJson((JsonElement)gson.fromJson(reader, JsonObject.class));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fromJson(JsonElement json) {
        if (!json.isJsonObject()) {
            return;
        }
        JsonObject obj = json.getAsJsonObject();
        JsonObject landmarks = obj.get("landmarks").getAsJsonObject();
        LandmarkTableModel landmarkTableModel = this;
        synchronized (landmarkTableModel) {
            this.clear();
            JsonArray namesArr = landmarks.get("names").getAsJsonArray();
            JsonArray activeArr = landmarks.get("active").getAsJsonArray();
            JsonArray mvgArr = landmarks.get("movingPoints").getAsJsonArray();
            JsonArray fixedArr = landmarks.get("fixedPoints").getAsJsonArray();
            this.numRows = namesArr.size();
            int ndims = landmarks.get("numDimensions").getAsInt();
            for (int i = 0; i < this.numRows; ++i) {
                this.names.add(namesArr.get(i).getAsString());
                this.activeList.add(activeArr.get(i).getAsBoolean());
                JsonElement mvg = mvgArr.get(i);
                JsonElement fixed = fixedArr.get(i);
                Double[] movingPt = new Double[ndims];
                Double[] targetPt = new Double[ndims];
                for (int d = 0; d < ndims; ++d) {
                    movingPt[d] = mvg.getAsJsonArray().get(d).getAsDouble();
                    targetPt[d] = fixed.getAsJsonArray().get(d).getAsDouble();
                }
                this.movingPts.add(movingPt);
                this.targetPts.add(targetPt);
                this.warpedPoints.add(new Double[ndims]);
                this.doesPointHaveAndNeedWarp.add(false);
                this.movingDisplayPointUnreliable.add(false);
            }
            this.ndims = ndims;
            this.updateNextRows(0);
            this.buildTableToActiveIndex();
        }
        for (int i = 0; i < this.numRows; ++i) {
            this.fireTableRowsInserted(i, i);
        }
    }

    public static String print(Double[] d) {
        String out = "";
        for (int i = 0; i < d.length; ++i) {
            out = out + d[i] + " ";
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueAt(Object value, int row, int col) {
        LandmarkTableModel landmarkTableModel = this;
        synchronized (landmarkTableModel) {
            if (row < 0 || col < 0 || row >= this.numRows || col >= this.numCols) {
                System.out.println("Warning: row (" + row + ") or column (" + col + ") out of range.");
                return;
            }
            if (col == 0) {
                this.names.set(row, (String)value);
            } else if (col == 1) {
                this.setIsActive(row, (Boolean)value);
            } else if (col < 2 + this.ndims) {
                Double[] thesePts = this.movingPts.get(row);
                thesePts[col - 2] = (double)((Double)value);
            } else {
                Double[] thesePts = this.targetPts.get(row);
                thesePts[col - this.ndims - 2] = (double)((Double)value);
            }
        }
        this.fireTableCellUpdated(row, col);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this.names.size()) {
            return null;
        }
        if (columnIndex == 0) {
            return this.names.get(rowIndex);
        }
        if (columnIndex == 1) {
            return this.activeList.get(rowIndex);
        }
        if (columnIndex < 2 + this.ndims) {
            return this.movingPts.get(rowIndex)[columnIndex - 2];
        }
        return this.targetPts.get(rowIndex)[columnIndex - this.ndims - 2];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col <= 1;
    }

    public LandmarkTableModel invert() {
        LandmarkTableModel inv = new LandmarkTableModel(this.ndims);
        int N = this.getRowCount();
        double[] tmp = new double[this.ndims];
        for (int i = 0; i < N; ++i) {
            int d;
            Double[] thisMoving = this.movingPts.get(i);
            Double[] thisTarget = this.targetPts.get(i);
            for (d = 0; d < this.ndims; ++d) {
                tmp[d] = thisMoving[d];
            }
            inv.add(tmp, false, null);
            for (d = 0; d < this.ndims; ++d) {
                tmp[d] = thisTarget[d];
            }
            inv.setPoint(i, true, tmp, null);
        }
        return inv;
    }

    public LandmarkUndoManager getUndoManager() {
        return this.undoRedoManager;
    }

    public static double[] copy(double[] in) {
        double[] out = new double[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = in[i];
        }
        return out;
    }

    public static double[] toPrimitive(Double[] in) {
        double[] out = new double[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = in[i];
        }
        return out;
    }

    public void transformChanged(InvertibleRealTransform transform) {
        this.updateAllWarpedPoints(transform);
    }
}

