/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.mesh;

import java.util.HashMap;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.mesh.Mesh;
import net.imglib2.mesh.Triangle;
import net.imglib2.mesh.Triangles;
import net.imglib2.mesh.Vertex;
import net.imglib2.mesh.Vertices;
import net.imglib2.mesh.alg.MarchingCubesBooleanType;
import net.imglib2.mesh.alg.MarchingCubesRealType;
import net.imglib2.mesh.alg.MeshConnectedComponents;
import net.imglib2.mesh.alg.RemoveDuplicateVertices;
import net.imglib2.mesh.alg.SimplifyMesh;
import net.imglib2.mesh.impl.naive.NaiveDoubleMesh;
import net.imglib2.mesh.impl.nio.BufferMesh;
import net.imglib2.type.BooleanType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Intervals;

public class Meshes {
    public static RealPoint center(Mesh m) {
        RealPoint p = new RealPoint(new float[]{0.0f, 0.0f, 0.0f});
        for (Vertex v : m.vertices()) {
            p.move((RealLocalizable)v);
        }
        for (int d = 0; d < 3; ++d) {
            p.setPosition(p.getDoublePosition(d) / (double)m.vertices().sizel(), d);
        }
        return p;
    }

    public static RealInterval boundingBox(Mesh mesh) {
        double[] boundingBox = new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY};
        for (Vertex v : mesh.vertices()) {
            double x = v.x();
            double y = v.y();
            double z = v.z();
            if (x < boundingBox[0]) {
                boundingBox[0] = x;
            }
            if (y < boundingBox[1]) {
                boundingBox[1] = y;
            }
            if (z < boundingBox[2]) {
                boundingBox[2] = z;
            }
            if (x > boundingBox[3]) {
                boundingBox[3] = x;
            }
            if (y > boundingBox[4]) {
                boundingBox[4] = y;
            }
            if (!(z > boundingBox[5])) continue;
            boundingBox[5] = z;
        }
        return Intervals.createMinMaxReal((double[])new double[]{boundingBox[0], boundingBox[1], boundingBox[2], boundingBox[3], boundingBox[4], boundingBox[5]});
    }

    public static Mesh boundingBoxMesh(Mesh input) {
        RealInterval interval = Meshes.boundingBox(input);
        NaiveDoubleMesh m = new NaiveDoubleMesh();
        long bbl = m.vertices().add(interval.realMin(0), interval.realMin(1), interval.realMin(2));
        long bbr = m.vertices().add(interval.realMax(0), interval.realMin(1), interval.realMin(2));
        long bfl = m.vertices().add(interval.realMin(0), interval.realMax(1), interval.realMin(2));
        long bfr = m.vertices().add(interval.realMax(0), interval.realMax(1), interval.realMin(2));
        long tbl = m.vertices().add(interval.realMin(0), interval.realMin(1), interval.realMax(2));
        long tbr = m.vertices().add(interval.realMax(0), interval.realMin(1), interval.realMax(2));
        long tfl = m.vertices().add(interval.realMin(0), interval.realMax(1), interval.realMax(2));
        long tfr = m.vertices().add(interval.realMax(0), interval.realMax(1), interval.realMax(2));
        m.triangles().add(bbl, bfr, bbr);
        m.triangles().add(bbl, bfl, bfr);
        m.triangles().add(tfl, bfr, bfl);
        m.triangles().add(tfl, tfr, bfr);
        m.triangles().add(tbl, tfr, tfl);
        m.triangles().add(tbl, tbr, tfr);
        m.triangles().add(tbl, bbl, bbr);
        m.triangles().add(tbl, tbr, tfr);
        m.triangles().add(tfl, bfl, bbl);
        m.triangles().add(tfl, bbl, tbr);
        m.triangles().add(tfr, tbr, bbr);
        m.triangles().add(tfr, bbr, tfr);
        return m;
    }

    public static void copy(Mesh src, Mesh dest) {
        HashMap<Long, Long> vIndexMap = new HashMap<Long, Long>();
        for (Vertex v : src.vertices()) {
            long destIndex;
            long srcIndex = v.index();
            if (srcIndex == (destIndex = dest.vertices().add(v.x(), v.y(), v.z(), v.nx(), v.ny(), v.nz(), v.u(), v.v()))) continue;
            vIndexMap.put(srcIndex, destIndex);
        }
        for (Triangle tri : src.triangles()) {
            long v0src = tri.vertex0();
            long v1src = tri.vertex1();
            long v2src = tri.vertex2();
            long v0 = vIndexMap.getOrDefault(v0src, v0src);
            long v1 = vIndexMap.getOrDefault(v1src, v1src);
            long v2 = vIndexMap.getOrDefault(v2src, v2src);
            dest.triangles().add(v0, v1, v2, tri.nx(), tri.ny(), tri.nz());
        }
    }

    public static void calculateNormals(Mesh src, Mesh dest) {
        HashMap<Long, float[]> triNormals = new HashMap<Long, float[]>();
        for (Triangle tri : src.triangles()) {
            int v0 = (int)tri.vertex0();
            int v1 = (int)tri.vertex1();
            int v2 = (int)tri.vertex2();
            float v0x = src.vertices().xf(v0);
            float v0y = src.vertices().yf(v0);
            float v0z = src.vertices().zf(v0);
            float v1x = src.vertices().xf(v1);
            float v1y = src.vertices().yf(v1);
            float v1z = src.vertices().zf(v1);
            float v2x = src.vertices().xf(v2);
            float v2y = src.vertices().yf(v2);
            float v2z = src.vertices().zf(v2);
            float v10x = v1x - v0x;
            float v10y = v1y - v0y;
            float v10z = v1z - v0z;
            float v20x = v2x - v0x;
            float v20y = v2y - v0y;
            float v20z = v2z - v0z;
            float nx = v10y * v20z - v10z * v20y;
            float ny = v10z * v20x - v10x * v20z;
            float nz = v10x * v20y - v10y * v20x;
            float nmag = (float)Math.sqrt(Math.pow(nx, 2.0) + Math.pow(ny, 2.0) + Math.pow(nz, 2.0));
            triNormals.put(tri.index(), new float[]{nx / nmag, ny / nmag, nz / nmag});
        }
        HashMap<Long, float[]> vNormals = new HashMap<Long, float[]>();
        for (Triangle tri : src.triangles()) {
            float[] triNormal = (float[])triNormals.get(tri.index());
            for (long idx : new long[]{tri.vertex0(), tri.vertex1(), tri.vertex2()}) {
                float[] cumNormal = vNormals.getOrDefault(idx, new float[]{0.0f, 0.0f, 0.0f});
                cumNormal[0] = cumNormal[0] + triNormal[0];
                cumNormal[1] = cumNormal[1] + triNormal[1];
                cumNormal[2] = cumNormal[2] + triNormal[2];
                vNormals.put(idx, cumNormal);
            }
        }
        HashMap<Long, Long> vIndexMap = new HashMap<Long, Long>();
        for (Vertex v : src.vertices()) {
            long srcIndex = v.index();
            float[] vNormal = (float[])vNormals.get(v.index());
            double vNormalMag = Math.sqrt(Math.pow(vNormal[0], 2.0) + Math.pow(vNormal[1], 2.0) + Math.pow(vNormal[2], 2.0));
            long destIndex = dest.vertices().add(v.x(), v.y(), v.z(), (double)vNormal[0] / vNormalMag, (double)vNormal[1] / vNormalMag, (double)vNormal[2] / vNormalMag, v.u(), v.v());
            if (srcIndex == destIndex) continue;
            vIndexMap.put(srcIndex, destIndex);
        }
        for (Triangle tri : src.triangles()) {
            long v0src = tri.vertex0();
            long v1src = tri.vertex1();
            long v2src = tri.vertex2();
            long v0 = vIndexMap.getOrDefault(v0src, v0src);
            long v1 = vIndexMap.getOrDefault(v1src, v1src);
            long v2 = vIndexMap.getOrDefault(v2src, v2src);
            float[] triNormal = (float[])triNormals.get(tri.index());
            dest.triangles().add(v0, v1, v2, (double)triNormal[0], (double)triNormal[1], (double)triNormal[2]);
        }
    }

    public static Mesh simplify(Mesh mesh, float target_percent, float agressiveness) {
        return new SimplifyMesh(mesh).simplify(target_percent, (double)agressiveness);
    }

    public static BufferMesh removeDuplicateVertices(Mesh mesh, int precision) {
        return RemoveDuplicateVertices.calculate(mesh, precision);
    }

    public static <T extends BooleanType<T>> Mesh marchingCubes(RandomAccessibleInterval<T> source) {
        return MarchingCubesBooleanType.calculate(source);
    }

    public static <T extends RealType<T>> Mesh marchingCubes(RandomAccessibleInterval<T> source, double isoLevel) {
        return MarchingCubesRealType.calculate(source, isoLevel);
    }

    public static int nConnectedComponents(Mesh mesh) {
        return MeshConnectedComponents.n(mesh);
    }

    public static Iterable<BufferMesh> connectedComponents(Mesh mesh) {
        return MeshConnectedComponents.iterable(mesh);
    }

    public static void scale(Mesh mesh, double[] scale) {
        Vertices vertices = mesh.vertices();
        long nVertices = vertices.sizel();
        for (long i = 0L; i < nVertices; ++i) {
            double x = vertices.x(i);
            double y = vertices.y(i);
            double z = vertices.z(i);
            vertices.set(i, x * scale[0], y * scale[1], z * scale[2]);
        }
    }

    public static void translate(Mesh mesh, double[] translate) {
        Vertices vertices = mesh.vertices();
        long nVertices = vertices.sizel();
        for (long i = 0L; i < nVertices; ++i) {
            double x = vertices.x(i);
            double y = vertices.y(i);
            double z = vertices.z(i);
            vertices.set(i, x + translate[0], y + translate[1], z + translate[2]);
        }
    }

    public static void translateScale(Mesh mesh, double[] translate, double[] scale) {
        Vertices vertices = mesh.vertices();
        long nv = vertices.size();
        for (long i = 0L; i < nv; ++i) {
            double x = (translate[0] + vertices.x(i)) * scale[0];
            double y = (translate[1] + vertices.y(i)) * scale[1];
            double z = (translate[2] + vertices.z(i)) * scale[2];
            vertices.set(i, x, y, z);
        }
    }

    public static BufferMesh merge(Iterable<Mesh> meshes) {
        int nVertices = 0;
        int nTriangles = 0;
        for (Mesh mesh : meshes) {
            nVertices += mesh.vertices().size();
            nTriangles += mesh.triangles().size();
        }
        BufferMesh out = new BufferMesh(nVertices, nTriangles);
        BufferMesh.Vertices vOut = out.vertices();
        BufferMesh.Triangles tOut = out.triangles();
        for (Mesh mesh : meshes) {
            Vertices vIn = mesh.vertices();
            int[] inToOutMap = new int[vIn.size()];
            for (int i = 0; i < vIn.size(); ++i) {
                int vo;
                float xf = vIn.xf(i);
                float yf = vIn.yf(i);
                float zf = vIn.zf(i);
                float nxf = vIn.nxf(i);
                float nyf = vIn.nyf(i);
                float nzf = vIn.nzf(i);
                float uf = vIn.uf(i);
                float vf = vIn.vf(i);
                inToOutMap[i] = vo = (int)vOut.addf(xf, yf, zf, nxf, nyf, nzf, uf, vf);
            }
            Triangles tIn = mesh.triangles();
            for (int i = 0; i < tIn.size(); ++i) {
                int v0In = tIn.vertex0(i);
                int v1In = tIn.vertex1(i);
                int v2In = tIn.vertex2(i);
                float nxf = tIn.nxf(i);
                float nyf = tIn.nyf(i);
                float nzf = tIn.nzf(i);
                int v0Out = inToOutMap[v0In];
                int v1Out = inToOutMap[v1In];
                int v2Out = inToOutMap[v2In];
                tOut.addf(v0Out, v1Out, v2Out, nxf, nyf, nzf);
            }
        }
        return out;
    }

    private Meshes() {
    }
}

