/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.mesh;

import java.util.Iterator;
import net.imglib2.mesh.Mesh;
import net.imglib2.mesh.Triangle;

public interface Triangles
extends Iterable<Triangle> {
    public Mesh mesh();

    public long sizel();

    default public int size() {
        long size = this.sizel();
        if (size >= Integer.MAX_VALUE) {
            throw new RuntimeException("Too many triangles: " + size);
        }
        return (int)size;
    }

    public long vertex0(long var1);

    default public int vertex0(int tIndex) {
        long vertex0 = this.vertex0((long)tIndex);
        if (tIndex >= Integer.MAX_VALUE) {
            throw new RuntimeException("Index too large: " + tIndex);
        }
        return (int)vertex0;
    }

    public long vertex1(long var1);

    default public int vertex1(int tIndex) {
        long vertex1 = this.vertex1((long)tIndex);
        if (tIndex >= Integer.MAX_VALUE) {
            throw new RuntimeException("Index too large: " + tIndex);
        }
        return (int)vertex1;
    }

    public long vertex2(long var1);

    default public int vertex2(int tIndex) {
        long vertex2 = this.vertex2((long)tIndex);
        if (tIndex >= Integer.MAX_VALUE) {
            throw new RuntimeException("Index too large: " + tIndex);
        }
        return (int)vertex2;
    }

    public float nxf(long var1);

    public float nyf(long var1);

    public float nzf(long var1);

    public long addf(long var1, long var3, long var5, float var7, float var8, float var9);

    default public int addf(int v0, int v1, int v2, float nx, float ny, float nz) {
        long t = this.addf((long)v0, (long)v1, (long)v2, nx, ny, nz);
        if (t >= Integer.MAX_VALUE) {
            throw new RuntimeException("Index too large: " + t);
        }
        return (int)t;
    }

    default public long addf(long v0, long v1, long v2) {
        float v0x = this.mesh().vertices().xf(v0);
        float v0y = this.mesh().vertices().yf(v0);
        float v0z = this.mesh().vertices().zf(v0);
        float v1x = this.mesh().vertices().xf(v1);
        float v1y = this.mesh().vertices().yf(v1);
        float v1z = this.mesh().vertices().zf(v1);
        float v2x = this.mesh().vertices().xf(v2);
        float v2y = this.mesh().vertices().yf(v2);
        float v2z = this.mesh().vertices().zf(v2);
        float v10x = v1x - v0x;
        float v10y = v1y - v0y;
        float v10z = v1z - v0z;
        float v20x = v2x - v0x;
        float v20y = v2y - v0y;
        float v20z = v2z - v0z;
        float nx = v10y * v20z - v10z * v20y;
        float ny = v10z * v20x - v10x * v20z;
        float nz = v10x * v20y - v10y * v20x;
        return this.addf(v0, v1, v2, nx, ny, nz);
    }

    default public int addf(int v0, int v1, int v2) {
        long t = this.addf((long)v0, (long)v1, (long)v2);
        if (t >= Integer.MAX_VALUE) {
            throw new RuntimeException("Index too large: " + t);
        }
        return (int)t;
    }

    default public long addf(float v0x, float v0y, float v0z, float v1x, float v1y, float v1z, float v2x, float v2y, float v2z, float nx, float ny, float nz) {
        long v0 = this.mesh().vertices().add(v0x, v0y, v0z);
        long v1 = this.mesh().vertices().add(v1x, v1y, v1z);
        long v2 = this.mesh().vertices().add(v2x, v2y, v2z);
        return this.addf(v0, v1, v2, nx, ny, nz);
    }

    default public long addf(float v0x, float v0y, float v0z, float v1x, float v1y, float v1z, float v2x, float v2y, float v2z) {
        long v0 = this.mesh().vertices().add(v0x, v0y, v0z);
        long v1 = this.mesh().vertices().add(v1x, v1y, v1z);
        long v2 = this.mesh().vertices().add(v2x, v2y, v2z);
        return this.addf(v0, v1, v2);
    }

    default public double nx(long tIndex) {
        return this.nxf(tIndex);
    }

    default public double ny(long tIndex) {
        return this.nyf(tIndex);
    }

    default public double nz(long tIndex) {
        return this.nzf(tIndex);
    }

    default public long add(long v0, long v1, long v2, double nx, double ny, double nz) {
        return this.addf(v0, v1, v2, (float)nx, (float)ny, (float)nz);
    }

    default public int add(int v0, int v1, int v2, double nx, double ny, double nz) {
        return this.addf(v0, v1, v2, (float)nx, (float)ny, (float)nz);
    }

    default public long add(long v0, long v1, long v2) {
        double v0x = this.mesh().vertices().x(v0);
        double v0y = this.mesh().vertices().y(v0);
        double v0z = this.mesh().vertices().z(v0);
        double v1x = this.mesh().vertices().x(v1);
        double v1y = this.mesh().vertices().y(v1);
        double v1z = this.mesh().vertices().z(v1);
        double v2x = this.mesh().vertices().x(v2);
        double v2y = this.mesh().vertices().y(v2);
        double v2z = this.mesh().vertices().z(v2);
        double v10x = v1x - v0x;
        double v10y = v1y - v0y;
        double v10z = v1z - v0z;
        double v20x = v2x - v0x;
        double v20y = v2y - v0y;
        double v20z = v2z - v0z;
        double nx = v10y * v20z - v10z * v20y;
        double ny = v10z * v20x - v10x * v20z;
        double nz = v10x * v20y - v10y * v20x;
        double nmag = Math.sqrt(Math.pow(nx, 2.0) + Math.pow(ny, 2.0) + Math.pow(nz, 2.0));
        return this.add(v0, v1, v2, nx / nmag, ny / nmag, nz / nmag);
    }

    default public long add(double v0x, double v0y, double v0z, double v1x, double v1y, double v1z, double v2x, double v2y, double v2z, double nx, double ny, double nz) {
        long v0 = this.mesh().vertices().add(v0x, v0y, v0z);
        long v1 = this.mesh().vertices().add(v1x, v1y, v1z);
        long v2 = this.mesh().vertices().add(v2x, v2y, v2z);
        return this.add(v0, v1, v2, nx, ny, nz);
    }

    default public long add(double v0x, double v0y, double v0z, double v1x, double v1y, double v1z, double v2x, double v2y, double v2z) {
        long v0 = this.mesh().vertices().add(v0x, v0y, v0z);
        long v1 = this.mesh().vertices().add(v1x, v1y, v1z);
        long v2 = this.mesh().vertices().add(v2x, v2y, v2z);
        return this.add(v0, v1, v2);
    }

    @Override
    default public Iterator<Triangle> iterator() {
        return new Iterator<Triangle>(){
            private long index = -1L;
            private final Triangle triangle = new Triangle(){

                @Override
                public Mesh mesh() {
                    return Triangles.this.mesh();
                }

                @Override
                public long index() {
                    return index;
                }
            };

            @Override
            public boolean hasNext() {
                return this.index + 1L < Triangles.this.sizel();
            }

            @Override
            public Triangle next() {
                ++this.index;
                return this.triangle;
            }
        };
    }
}

