/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.mesh.alg.zslicer;

import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.imglib2.mesh.Mesh;
import net.imglib2.mesh.Triangles;
import net.imglib2.mesh.Vertices;
import net.imglib2.mesh.alg.zslicer.Contour;
import net.imglib2.mesh.alg.zslicer.Slice;
import net.imglib2.mesh.util.MeshUtil;
import net.imglib2.mesh.util.SortArray;
import net.imglib2.mesh.util.SortBy;

public class ZSlicer {
    static final double EPS = 4.0E-4;

    public static List<Slice> slices(Mesh mesh, double[] zs, double zScale) {
        double eps = 4.0E-4 * zScale;
        double[] zrs = new double[zs.length];
        for (int i = 0; i < zs.length; ++i) {
            zrs[i] = MeshUtil.mround(zs[i], eps, 2, 1);
        }
        Triangles triangles = mesh.triangles();
        Vertices vertices = mesh.vertices();
        double[] minZs = new double[triangles.size()];
        double[] maxZs = new double[triangles.size()];
        for (int t = 0; t < triangles.size(); ++t) {
            double maxZ;
            double minZ;
            long v0 = triangles.vertex0(t);
            long v1 = triangles.vertex1(t);
            long v2 = triangles.vertex2(t);
            minZs[t] = minZ = MeshUtil.minZ(vertices, v0, v1, v2, eps);
            maxZs[t] = maxZ = MeshUtil.maxZ(vertices, v0, v1, v2, eps);
        }
        int[] indexMin = SortArray.quicksort(minZs);
        int[] indices = new int[indexMin.length];
        ArrayList<Slice> slices = new ArrayList<Slice>(zrs.length);
        for (int i = 0; i < zrs.length; ++i) {
            double zr = zrs[i];
            int k1 = Arrays.binarySearch(minZs, zr);
            if (k1 < 0) {
                k1 = -(k1 + 1);
            }
            System.arraycopy(indexMin, 0, indices, 0, k1);
            SortBy.sortBy(indices, maxZs, 0, k1 - 1);
            int k2 = SortBy.binarySearch(indices, maxZs, 0, k1, zr);
            if (k2 < 0) {
                k2 = -(k2 + 1);
            }
            List<Contour> contours = ZSlicer.process(mesh, indices, k2, k1, zr, eps);
            slices.add(new Slice(contours));
        }
        return slices;
    }

    private static List<Contour> process(Mesh mesh, int[] indices, int start, int end, double zr, double eps) {
        LinkedList<Segment> segments = new LinkedList<Segment>();
        for (int i = start; i < end; ++i) {
            int id = indices[i];
            Segment segment = ZSlicer.triangleIntersection(mesh, id, zr, eps);
            if (segment == null) continue;
            segments.add(segment);
        }
        Collections.sort(segments);
        ArrayList<Contour> contours = new ArrayList<Contour>();
        while (!segments.isEmpty()) {
            int i;
            Segment first = (Segment)segments.pop();
            if (segments.isEmpty()) break;
            TDoubleArrayList x = new TDoubleArrayList();
            TDoubleArrayList y = new TDoubleArrayList();
            TDoubleArrayList nx = new TDoubleArrayList();
            TDoubleArrayList ny = new TDoubleArrayList();
            x.add(first.xa);
            y.add(first.ya);
            nx.add(first.nx);
            ny.add(first.ny);
            boolean isClosed = false;
            Segment match = new Segment(Double.NaN, Double.NaN, first.eb, -1L, Double.NaN, Double.NaN);
            long endEdge = first.ea;
            double minX = first.xa;
            int minXIndex = 0;
            while (!isClosed && (i = Collections.binarySearch(segments, match)) >= 0) {
                Segment segment = (Segment)segments.remove(i);
                x.add(segment.xa);
                y.add(segment.ya);
                nx.add(segment.nx);
                ny.add(segment.ny);
                if (segment.xa < minX) {
                    minX = segment.xa;
                    minXIndex = x.size() - 1;
                }
                match = new Segment(Double.NaN, Double.NaN, segment.eb, -1L, Double.NaN, Double.NaN);
                if (segment.eb != endEdge) continue;
                isClosed = true;
            }
            if (x.size() < 3) continue;
            boolean isInterior = nx.getQuick(minXIndex) < 0.0;
            contours.add(new Contour(x, y, nx, ny, isInterior));
        }
        return contours;
    }

    public static Slice slice(Mesh mesh, double z, double zScale) {
        double eps = 4.0E-4 * zScale;
        double zr = MeshUtil.mround(z, eps, 2, 1);
        Triangles triangles = mesh.triangles();
        Vertices vertices = mesh.vertices();
        TIntArrayList intersecting = new TIntArrayList();
        for (long f = 0L; f < triangles.sizel(); ++f) {
            double maxZ;
            long v2;
            long v1;
            long v0 = triangles.vertex0(f);
            double minZ = MeshUtil.minZ(vertices, v0, v1 = triangles.vertex1(f), v2 = triangles.vertex2(f), eps);
            if (minZ > zr || (maxZ = MeshUtil.maxZ(vertices, v0, v1, v2, eps)) < zr) continue;
            intersecting.add((int)f);
        }
        List<Contour> contours = ZSlicer.process(mesh, intersecting.toArray(), 0, intersecting.size(), zr, eps);
        return new Slice(contours);
    }

    private static Segment triangleIntersection(Mesh mesh, long id, double z, double eps) {
        long eb;
        long ea;
        double yb;
        double xb;
        double ya;
        double xa;
        long v0 = mesh.triangles().vertex0(id);
        long v1 = mesh.triangles().vertex1(id);
        long v2 = mesh.triangles().vertex2(id);
        double x0 = MeshUtil.mround(mesh.vertices().x(v0), eps, 2, 0);
        double x1 = MeshUtil.mround(mesh.vertices().x(v1), eps, 2, 0);
        double x2 = MeshUtil.mround(mesh.vertices().x(v2), eps, 2, 0);
        double y0 = MeshUtil.mround(mesh.vertices().y(v0), eps, 2, 0);
        double y1 = MeshUtil.mround(mesh.vertices().y(v1), eps, 2, 0);
        double y2 = MeshUtil.mround(mesh.vertices().y(v2), eps, 2, 0);
        double z0 = MeshUtil.mround(mesh.vertices().z(v0), eps, 2, 0);
        double z1 = MeshUtil.mround(mesh.vertices().z(v1), eps, 2, 0);
        double z2 = MeshUtil.mround(mesh.vertices().z(v2), eps, 2, 0);
        double nx = mesh.triangles().nx(id);
        double ny = mesh.triangles().ny(id);
        double nz = mesh.triangles().nz(id);
        double[] cross = new double[3];
        MeshUtil.cross(0.0, 0.0, 1.0, nx, ny, nz, cross);
        double[] ei0 = ZSlicer.edgeIntersection(x0, y0, z0, x1, y1, z1, z);
        double[] ei1 = ZSlicer.edgeIntersection(x0, y0, z0, x2, y2, z2, z);
        double[] ei2 = ZSlicer.edgeIntersection(x1, y1, z1, x2, y2, z2, z);
        if (ei0 == null) {
            xa = ei1[0];
            ya = ei1[1];
            xb = ei2[0];
            yb = ei2[1];
            ea = MeshUtil.edgeID((int)v2, (int)v0);
            eb = MeshUtil.edgeID((int)v1, (int)v2);
        } else if (ei1 == null) {
            xa = ei2[0];
            ya = ei2[1];
            xb = ei0[0];
            yb = ei0[1];
            ea = MeshUtil.edgeID((int)v1, (int)v2);
            eb = MeshUtil.edgeID((int)v0, (int)v1);
        } else {
            xa = ei0[0];
            ya = ei0[1];
            xb = ei1[0];
            yb = ei1[1];
            ea = MeshUtil.edgeID((int)v0, (int)v1);
            eb = MeshUtil.edgeID((int)v2, (int)v0);
        }
        double dx = xb - xa;
        double dy = yb - ya;
        double d = MeshUtil.dotProduct(cross[0], cross[1], cross[2], dx, dy, 0.0);
        if (d > 0.0) {
            return new Segment(xa, ya, ea, eb, nx, ny);
        }
        return new Segment(xb, yb, eb, ea, nx, ny);
    }

    private static double[] edgeIntersection(double xs, double ys, double zs, double xt, double yt, double zt, double z) {
        if (zs > z && zt > z || zs < z && zt < z) {
            return null;
        }
        assert (zs != zt);
        double t = (z - zs) / (zt - zs);
        double x = xs + t * (xt - xs);
        double y = ys + t * (yt - ys);
        return new double[]{x, y};
    }

    static final class Segment
    implements Comparable<Segment> {
        final long ea;
        final long eb;
        final double xa;
        final double ya;
        final double nx;
        final double ny;

        Segment(double xa, double ya, long ea, long eb, double nx, double ny) {
            this.xa = xa;
            this.ya = ya;
            this.ea = ea;
            this.eb = eb;
            this.nx = nx;
            this.ny = ny;
        }

        public String toString() {
            return String.format("S %d -> %d", this.ea, this.eb);
        }

        @Override
        public int compareTo(Segment o) {
            return this.ea < o.ea ? -1 : (this.ea == o.ea ? 0 : 1);
        }
    }
}

