/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.mesh.io.stl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.Paths;
import net.imglib2.mesh.Mesh;
import net.imglib2.mesh.Triangle;
import net.imglib2.mesh.impl.naive.NaiveFloatMesh;

public final class STLMeshIO {
    public static final int HEADER_BYTES = 80;
    public static final String HEADER = STLMeshIO.padEnd("Binary STL created with ImageJ", 80, '.');
    public static final int COUNT_BYTES = 4;
    public static final int FACET_START = 84;
    public static final int FACET_BYTES = 50;

    private STLMeshIO() {
    }

    public static final void read(Mesh mesh, byte[] data) {
        if (data.length < 84) {
            return;
        }
        ByteBuffer buffer = ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN);
        int facetCount = buffer.getInt(80);
        int expectedSize = 84 + facetCount * 50;
        if (expectedSize != buffer.capacity()) {
            return;
        }
        buffer.position(84);
        for (int offset = 84; offset < buffer.capacity(); offset += 50) {
            STLMeshIO.readFacet(mesh, buffer);
        }
    }

    public static final byte[] write(Mesh mesh) {
        long facetCount = mesh == null ? 0L : mesh.triangles().sizel();
        long longBytes = 84L + facetCount * 50L;
        if (longBytes > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too many triangles: " + facetCount);
        }
        int bytes = (int)longBytes;
        ByteBuffer buffer = ByteBuffer.allocate(bytes).order(ByteOrder.LITTLE_ENDIAN);
        buffer.put(HEADER.getBytes());
        buffer.putInt((int)facetCount);
        if (mesh == null) {
            return buffer.array();
        }
        mesh.triangles().forEach(f -> STLMeshIO.writeFacet(buffer, f));
        return buffer.array();
    }

    public static final void read(Mesh mesh, File stlFile) throws IOException {
        if (stlFile == null) {
            return;
        }
        byte[] data = Files.readAllBytes(Paths.get(stlFile.getAbsolutePath(), new String[0]));
        STLMeshIO.read(mesh, data);
    }

    public static final Mesh open(String source) throws IOException {
        NaiveFloatMesh mesh = new NaiveFloatMesh();
        STLMeshIO.read((Mesh)mesh, new File(source));
        return mesh;
    }

    public static final void save(Mesh data, String destination) throws IOException {
        byte[] bytes = STLMeshIO.write(data);
        try (FileOutputStream fos = new FileOutputStream(destination);){
            fos.write(bytes);
        }
    }

    private static final void writeFacet(ByteBuffer buffer, Triangle facet) {
        STLMeshIO.writeVector(buffer, facet.nxf(), facet.nyf(), facet.nzf());
        STLMeshIO.writeVector(buffer, facet.v0xf(), facet.v0yf(), facet.v0zf());
        STLMeshIO.writeVector(buffer, facet.v1xf(), facet.v1yf(), facet.v1zf());
        STLMeshIO.writeVector(buffer, facet.v2xf(), facet.v2yf(), facet.v2zf());
        buffer.putShort((short)0);
    }

    private static void writeVector(ByteBuffer buffer, float x, float y, float z) {
        buffer.putFloat(x);
        buffer.putFloat(y);
        buffer.putFloat(z);
    }

    private static void readFacet(Mesh mesh, ByteBuffer buffer) {
        float nx = buffer.getFloat();
        float ny = buffer.getFloat();
        float nz = buffer.getFloat();
        float v0x = buffer.getFloat();
        float v0y = buffer.getFloat();
        float v0z = buffer.getFloat();
        float v1x = buffer.getFloat();
        float v1y = buffer.getFloat();
        float v1z = buffer.getFloat();
        float v2x = buffer.getFloat();
        float v2y = buffer.getFloat();
        float v2z = buffer.getFloat();
        short attributeByteCount = buffer.getShort();
        mesh.triangles().addf(v0x, v0y, v0z, v1x, v1y, v1z, v2x, v2y, v2z, nx, ny, nz);
    }

    private static String padEnd(String s, int minLen, char padChar) {
        StringBuilder sb = new StringBuilder();
        while (sb.length() < minLen) {
            sb.append(padChar);
        }
        return sb.toString();
    }
}

