/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.mesh.util;

import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TLongArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Random;

public class SortTrove {
    public static void reorder(TDoubleArrayList data, int[] ind) {
        BitSet done = new BitSet(data.size());
        for (int i = 0; i < data.size() && done.cardinality() < data.size(); ++i) {
            int ia = i;
            int ib = ind[ia];
            if (done.get(ia)) continue;
            if (ia == ib) {
                done.set(ia);
                continue;
            }
            int x = ia;
            double a = data.getQuick(ia);
            while (ib != x && !done.get(ia)) {
                double b = data.getQuick(ib);
                data.setQuick(ia, b);
                done.set(ia);
                ia = ib;
                ib = ind[ia];
            }
            data.setQuick(ia, a);
            done.set(ia);
        }
    }

    public static int[] quicksort(TDoubleArrayList main) {
        int[] index = new int[main.size()];
        for (int i = 0; i < index.length; ++i) {
            index[i] = i;
        }
        SortTrove.quicksort(main, index);
        return index;
    }

    public static void quicksort(TDoubleArrayList main, int[] index) {
        SortTrove.quicksort(main, index, 0, index.length - 1);
    }

    public static void quicksort(TDoubleArrayList a, int[] index, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = SortTrove.partition(a, index, left, right);
        SortTrove.quicksort(a, index, left, i - 1);
        SortTrove.quicksort(a, index, i + 1, right);
    }

    private static int partition(TDoubleArrayList a, int[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (SortTrove.less(a.getQuick(++i), a.getQuick(right))) {
                continue;
            }
            while (SortTrove.less(a.getQuick(right), a.getQuick(--j)) && j != left) {
            }
            if (i >= j) break;
            SortTrove.exch(a, index, i, j);
        }
        SortTrove.exch(a, index, i, right);
        return i;
    }

    private static boolean less(double x, double y) {
        return x < y;
    }

    private static void exch(TDoubleArrayList a, int[] index, int i, int j) {
        double swap = a.getQuick(i);
        a.setQuick(i, a.getQuick(j));
        a.setQuick(j, swap);
        int b = index[i];
        index[i] = index[j];
        index[j] = b;
    }

    public static void quicksort(TLongArrayList main, Comparator<Long> c) {
        int[] index = new int[main.size()];
        for (int i = 0; i < index.length; ++i) {
            index[i] = i;
        }
        SortTrove.quicksort(main, 0, main.size(), c);
    }

    private static void quicksort(TLongArrayList a, int left, int right, Comparator<Long> c) {
        if (right <= left) {
            return;
        }
        int i = SortTrove.partition(a, left, right, c);
        SortTrove.quicksort(a, left, i - 1, c);
        SortTrove.quicksort(a, i + 1, right, c);
    }

    private static int partition(TLongArrayList a, int left, int right, Comparator<Long> c) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (SortTrove.less(a.getQuick(++i), a.getQuick(right))) {
                continue;
            }
            while (SortTrove.less(a.getQuick(right), a.getQuick(--j)) && j != left) {
            }
            if (i >= j) break;
            SortTrove.exch(a, i, j);
        }
        SortTrove.exch(a, i, right);
        return i;
    }

    private static void exch(TLongArrayList a, int i, int j) {
        long swap = a.getQuick(i);
        a.setQuick(i, a.getQuick(j));
        a.setQuick(j, swap);
    }

    public static void main(String[] args) {
        int i;
        Random ran = new Random(1L);
        int n = 10;
        TDoubleArrayList arr = new TDoubleArrayList();
        for (int i2 = 0; i2 < 10; ++i2) {
            arr.add(ran.nextDouble());
        }
        TDoubleArrayList copy = new TDoubleArrayList(arr);
        System.out.print(String.format("Before sorting: %4.2f", arr.get(0)));
        for (int i3 = 1; i3 < arr.size(); ++i3) {
            System.out.print(String.format(", %4.2f", arr.get(i3)));
        }
        System.out.println();
        int[] index = SortTrove.quicksort(arr);
        System.out.print(String.format("After sorting:  %4.2f", arr.get(0)));
        for (i = 1; i < arr.size(); ++i) {
            System.out.print(String.format(", %4.2f", arr.get(i)));
        }
        System.out.println();
        System.out.print(String.format("Index:          %4d", index[0]));
        for (i = 1; i < arr.size(); ++i) {
            System.out.print(String.format(", %4d", index[i]));
        }
        System.out.println();
        SortTrove.reorder(arr, index);
        System.out.print(String.format("Reorder copy:   %4.2f", copy.get(0)));
        for (i = 1; i < copy.size(); ++i) {
            System.out.print(String.format(", %4.2f", copy.get(i)));
        }
        System.out.println();
    }
}

