/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ListIterator;
import java.util.Objects;
import org.apache.commons.collections4.Unmodifiable;

public final class UnmodifiableListIterator<E>
implements ListIterator<E>,
Unmodifiable {
    private final ListIterator<? extends E> iterator;

    @Deprecated
    public static <E> ListIterator<E> umodifiableListIterator(ListIterator<? extends E> iterator) {
        return UnmodifiableListIterator.unmodifiableListIterator(iterator);
    }

    public static <E> ListIterator<E> unmodifiableListIterator(ListIterator<? extends E> iterator) {
        Objects.requireNonNull(iterator, "iterator");
        if (iterator instanceof Unmodifiable) {
            ListIterator<? extends E> tmpIterator = iterator;
            return tmpIterator;
        }
        return new UnmodifiableListIterator<E>(iterator);
    }

    private UnmodifiableListIterator(ListIterator<? extends E> iterator) {
        this.iterator = iterator;
    }

    @Override
    public void add(E obj) {
        throw new UnsupportedOperationException("add() is not supported");
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public boolean hasPrevious() {
        return this.iterator.hasPrevious();
    }

    @Override
    public E next() {
        return this.iterator.next();
    }

    @Override
    public int nextIndex() {
        return this.iterator.nextIndex();
    }

    @Override
    public E previous() {
        return this.iterator.previous();
    }

    @Override
    public int previousIndex() {
        return this.iterator.previousIndex();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() is not supported");
    }

    @Override
    public void set(E obj) {
        throw new UnsupportedOperationException("set() is not supported");
    }
}

