/*
 * Decompiled with CFR 0.152.
 */
package io.scif.filters;

import io.scif.filters.AbstractFilter;
import io.scif.filters.Filter;
import io.scif.filters.MasterFilter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.scijava.Contextual;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.PluginService;

public class MasterFilterHelper<T extends Contextual>
extends AbstractFilter<T>
implements MasterFilter<T> {
    @Parameter
    private PluginService pluginService;
    private final T tail;
    private final HashMap<Class<? extends Filter>, Filter> instanceMap = new HashMap();
    private final TreeSet<Filter> enabled = new TreeSet();

    public MasterFilterHelper(T wrapped, Class<? extends T> wrappedClass) {
        super(wrappedClass);
        this.tail = wrapped;
        this.setParent(this.tail);
        this.setContext(wrapped.getContext());
        List filters = this.pluginService.createInstancesOfType(Filter.class);
        for (Filter filter : filters) {
            if (!filter.target().isAssignableFrom(wrappedClass)) continue;
            this.instanceMap.put(filter.getClass(), filter);
            if (!filter.enabledDefault()) continue;
            this.enable(filter.getClass());
        }
    }

    @Override
    public <F extends Filter> F enable(Class<F> filterClass) {
        Filter filter = this.instanceMap.get(filterClass);
        if (filter != null) {
            this.enabled.add(filter);
            this.updateParents();
        }
        return (F)filter;
    }

    @Override
    public boolean disable(Class<? extends Filter> filterClass) {
        Filter filter = this.instanceMap.get(filterClass);
        boolean disabled = false;
        if (filter != null) {
            this.enabled.remove(filter);
            this.updateParents();
            filter.reset();
            disabled = true;
        }
        return disabled;
    }

    @Override
    public T getTail() {
        return this.tail;
    }

    @Override
    public Class<?> target() {
        return null;
    }

    @Override
    public void reset() {
        super.reset();
        this.enabled.clear();
        this.updateParents();
    }

    @Override
    public Set<Class<? extends Filter>> getFilterClasses() {
        return this.instanceMap.keySet();
    }

    private void updateParents() {
        if (this.enabled.isEmpty()) {
            this.setParent(this.tail);
        } else {
            Iterator<Filter> filterIterator = this.enabled.descendingIterator();
            Filter currentFilter = filterIterator.next();
            currentFilter.setParent(this.tail);
            while (filterIterator.hasNext()) {
                Filter nextFilter = filterIterator.next();
                nextFilter.setParent(currentFilter);
                currentFilter = nextFilter;
            }
            this.setParent(currentFilter);
        }
    }
}

