/*
 * Decompiled with CFR 0.152.
 */
package io.scif.gui;

import io.scif.Format;
import io.scif.gui.ComboFileFilter;
import io.scif.gui.FormatFileFilter;
import io.scif.gui.GUIService;
import io.scif.gui.PreviewPane;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public class DefaultGUIService
extends AbstractService
implements GUIService {
    private final String ALL_TYPES = "All supported file types";

    @Override
    public FileFilter[] buildFileFilters(Collection<Format> formats) {
        FileFilter[] filters = new FileFilter[formats.size()];
        int i = 0;
        for (Format f : formats) {
            filters[i++] = new FormatFileFilter(f);
        }
        return filters;
    }

    @Override
    public JFileChooser buildFileChooser(Collection<Format> formats) {
        return this.buildFileChooser(formats, true);
    }

    @Override
    public JFileChooser buildFileChooser(Collection<Format> formats, boolean preview) {
        return this.buildFileChooser(this.buildFileFilters(formats), preview);
    }

    @Override
    public JFileChooser buildFileChooser(FileFilter[] filters) {
        return this.buildFileChooser(filters, true);
    }

    @Override
    public JFileChooser buildFileChooser(final FileFilter[] filters, final boolean preview) {
        final JFileChooser[] jfc = new JFileChooser[1];
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ComboFileFilter cff;
                JFileChooser fc = new JFileChooser(System.getProperty("user.dir"));
                FileFilter[] ff = DefaultGUIService.this.sortFilters(filters);
                FileFilter combo = null;
                if (ff.length > 0 && ff[0] instanceof ComboFileFilter && "All supported file types".equals((cff = (ComboFileFilter)ff[0]).getDescription())) {
                    combo = cff;
                }
                if (combo == null && (combo = DefaultGUIService.this.makeComboFilter(ff)) != null) {
                    fc.addChoosableFileFilter(combo);
                }
                for (FileFilter filter : ff) {
                    fc.addChoosableFileFilter(filter);
                }
                if (combo != null) {
                    fc.setFileFilter(combo);
                }
                if (preview) {
                    new PreviewPane(DefaultGUIService.this.getContext(), fc);
                }
                jfc[0] = fc;
            }
        };
        if (Thread.currentThread().getName().startsWith("AWT-EventQueue")) {
            r.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InterruptedException exc) {
                return null;
            }
            catch (InvocationTargetException exc) {
                return null;
            }
        }
        return jfc[0];
    }

    private FileFilter makeComboFilter(FileFilter[] filters) {
        return filters.length > 1 ? new ComboFileFilter(filters, "All supported file types") : null;
    }

    private FileFilter[] sortFilters(FileFilter[] filters) {
        filters = ComboFileFilter.sortFilters(filters);
        this.shuffleAllTypesToFront(filters);
        return filters;
    }

    private void shuffleAllTypesToFront(FileFilter[] filters) {
        for (int i = 0; i < filters.length; ++i) {
            if (!(filters[i] instanceof ComboFileFilter) || !"All supported file types".equals(filters[i].getDescription())) continue;
            FileFilter f = filters[i];
            for (int j = i; j >= 1; --j) {
                filters[j] = filters[j - 1];
            }
            filters[0] = f;
            break;
        }
    }
}

