/*
 * Decompiled with CFR 0.152.
 */
package bdv.export;

import bdv.export.ExportMipmapInfo;
import bdv.export.HDF5Access;
import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import java.io.File;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.janelia.saalfeldlab.n5.Compression;
import org.janelia.saalfeldlab.n5.DataBlock;
import org.janelia.saalfeldlab.n5.DataType;
import org.janelia.saalfeldlab.n5.DatasetAttributes;

class Hdf5BlockWriterThread
extends Thread {
    private final HDF5Access hdf5Access;
    private final BlockingQueue<Runnable> queue;
    private volatile boolean shutdown;
    private final Object emptyMonitor = new Object();

    @Deprecated
    public Hdf5BlockWriterThread(HDF5Access hdf5Access, int queueLength) {
        this.hdf5Access = hdf5Access;
        this.queue = new ArrayBlockingQueue<Runnable>(queueLength);
        this.shutdown = false;
        this.setName("HDF5BlockWriterQueue");
    }

    public Hdf5BlockWriterThread(File hdf5File, int queueLength) {
        IHDF5Writer hdf5Writer = HDF5Factory.open((File)hdf5File);
        this.hdf5Access = new HDF5Access(hdf5Writer);
        this.queue = new ArrayBlockingQueue<Runnable>(queueLength);
        this.shutdown = false;
        this.setName("HDF5BlockWriterQueue");
    }

    public Hdf5BlockWriterThread(String hdf5FilePath, int queueLength) {
        this(new File(hdf5FilePath), queueLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.shutdown || !this.queue.isEmpty()) {
            try {
                Runnable task = this.queue.poll(10L, TimeUnit.MILLISECONDS);
                if (task != null) {
                    task.run();
                }
                if (!this.queue.isEmpty()) continue;
                Object object = this.emptyMonitor;
                synchronized (object) {
                    this.emptyMonitor.notifyAll();
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilEmpty() {
        Object object = this.emptyMonitor;
        synchronized (object) {
            while (!this.queue.isEmpty()) {
                try {
                    this.emptyMonitor.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void close() {
        this.shutdown = true;
        try {
            this.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.hdf5Access.close();
    }

    public IHDF5Writer getIHDF5Writer() {
        return this.hdf5Access.getIHDF5Writer();
    }

    public void writeMipmapDescription(int setupIdPartition, ExportMipmapInfo mipmapInfo) {
        this.put(() -> this.hdf5Access.writeMipmapDescription(setupIdPartition, mipmapInfo));
    }

    public void writeDataType(int setupIdPartition, DataType dataType) {
        this.put(() -> this.hdf5Access.writeDataType(setupIdPartition, dataType));
    }

    public void createDataset(String path, long[] dimensions, int[] cellDimensions, DataType dataType, Compression compression) {
        this.put(() -> this.hdf5Access.createDataset(path, dimensions, cellDimensions, dataType, compression));
    }

    public <T> void writeBlock(String pathName, DatasetAttributes datasetAttributes, DataBlock<T> dataBlock) {
        this.put(() -> this.hdf5Access.writeBlock(pathName, datasetAttributes, dataBlock));
    }

    public void flush() {
        this.waitUntilEmpty();
    }

    private boolean put(Runnable task) {
        try {
            this.queue.put(task);
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
    }
}

