/*
 * Decompiled with CFR 0.152.
 */
package bdv.export.n5;

import bdv.export.ExportMipmapInfo;
import bdv.export.ExportScalePyramid;
import bdv.export.ProgressWriter;
import bdv.export.ProgressWriterNull;
import bdv.export.SubTaskProgressWriter;
import bdv.img.cache.SimpleCacheArrayLoader;
import bdv.img.n5.BdvN5Format;
import bdv.img.n5.DataTypeProperties;
import bdv.img.n5.N5ImageLoader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import mpicbg.spim.data.generic.base.Entity;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.generic.sequence.BasicSetupImgLoader;
import mpicbg.spim.data.generic.sequence.BasicViewDescription;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.generic.sequence.ImgLoaderHint;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.cache.img.ReadOnlyCachedCellImgFactory;
import net.imglib2.cache.img.ReadOnlyCachedCellImgOptions;
import net.imglib2.img.cell.Cell;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Cast;
import org.janelia.saalfeldlab.n5.Compression;
import org.janelia.saalfeldlab.n5.DataBlock;
import org.janelia.saalfeldlab.n5.DataType;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5FSWriter;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.N5Writer;

public class WriteSequenceToN5 {
    private static final String MULTI_SCALE_KEY = "multiScale";
    private static final String RESOLUTION_KEY = "resolution";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeN5File(AbstractSequenceDescription<?, ?, ?> seq, Map<Integer, ExportMipmapInfo> perSetupMipmapInfo, Compression compression, File n5File, ExportScalePyramid.LoopbackHeuristic loopbackHeuristic, ExportScalePyramid.AfterEachPlane afterEachPlane, int numCellCreatorThreads, ProgressWriter progressWriter) throws IOException {
        Object downsamplingFactors;
        if (progressWriter == null) {
            progressWriter = new ProgressWriterNull();
        }
        progressWriter.setProgress(0.0);
        BasicImgLoader imgLoader = seq.getImgLoader();
        for (BasicViewSetup setup : seq.getViewSetupsOrdered()) {
            Object type = imgLoader.getSetupImgLoader(setup.getId()).getImageType();
            if (type instanceof RealType && type instanceof NativeType && DataTypeProperties.n5DataType((NativeType)Cast.unchecked((Object)type)) != null) continue;
            throw new IllegalArgumentException("Unsupported pixel type: " + type.getClass().getSimpleName());
        }
        List timepointIds = seq.getTimePoints().getTimePointsOrdered().stream().map(Entity::getId).collect(Collectors.toList());
        List setupIds = seq.getViewSetupsOrdered().stream().map(Entity::getId).collect(Collectors.toList());
        N5FSWriter n5 = new N5FSWriter(n5File.getAbsolutePath());
        Iterator iterator = setupIds.iterator();
        while (iterator.hasNext()) {
            int setupId = (Integer)iterator.next();
            String pathName = BdvN5Format.getPathName(setupId);
            downsamplingFactors = perSetupMipmapInfo.get(setupId).getExportResolutions();
            DataType dataType = DataTypeProperties.n5DataType((NativeType)Cast.unchecked((Object)imgLoader.getSetupImgLoader(setupId).getImageType()));
            n5.createGroup(pathName);
            n5.setAttribute(pathName, "downsamplingFactors", downsamplingFactors);
            n5.setAttribute(pathName, "dataType", (Object)dataType);
        }
        int numTasks = 0;
        Iterator setupId = timepointIds.iterator();
        while (setupId.hasNext()) {
            int timepointIdSequence = (Integer)setupId.next();
            downsamplingFactors = setupIds.iterator();
            while (downsamplingFactors.hasNext()) {
                int setupIdSequence = (Integer)downsamplingFactors.next();
                if (!((BasicViewDescription)seq.getViewDescriptions().get(new ViewId(timepointIdSequence, setupIdSequence))).isPresent()) continue;
                ++numTasks;
            }
        }
        int numCompletedTasks = 0;
        ExecutorService executorService = Executors.newFixedThreadPool(numCellCreatorThreads);
        try {
            int numTimepoints = timepointIds.size();
            int timepointIndex = 0;
            Iterator iterator2 = timepointIds.iterator();
            while (iterator2.hasNext()) {
                int timepointId = (Integer)iterator2.next();
                progressWriter.out().printf("proccessing timepoint %d / %d\n", ++timepointIndex, numTimepoints);
                ArrayList<Integer> setupsTimePoint = new ArrayList<Integer>();
                Iterator iterator3 = setupIds.iterator();
                while (iterator3.hasNext()) {
                    int setupId2 = (Integer)iterator3.next();
                    if (!((BasicViewDescription)seq.getViewDescriptions().get(new ViewId(timepointId, setupId2))).isPresent()) continue;
                    setupsTimePoint.add(setupId2);
                }
                int numSetups = setupsTimePoint.size();
                int setupIndex = 0;
                Iterator iterator4 = setupsTimePoint.iterator();
                while (iterator4.hasNext()) {
                    int setupId3 = (Integer)iterator4.next();
                    progressWriter.out().printf("proccessing setup %d / %d\n", ++setupIndex, numSetups);
                    ExportMipmapInfo mipmapInfo = perSetupMipmapInfo.get(setupId3);
                    double startCompletionRatio = (double)numCompletedTasks++ / (double)numTasks;
                    double endCompletionRatio = (double)numCompletedTasks / (double)numTasks;
                    SubTaskProgressWriter subProgressWriter = new SubTaskProgressWriter(progressWriter, startCompletionRatio, endCompletionRatio);
                    WriteSequenceToN5.writeScalePyramid((N5Writer)n5, compression, imgLoader, setupId3, timepointId, mipmapInfo, executorService, numCellCreatorThreads, loopbackHeuristic, afterEachPlane, subProgressWriter);
                    String pathName = BdvN5Format.getPathName(setupId3, timepointId);
                    n5.createGroup(pathName);
                    n5.setAttribute(pathName, MULTI_SCALE_KEY, (Object)true);
                    VoxelDimensions voxelSize = ((BasicViewSetup)seq.getViewSetups().get(setupId3)).getVoxelSize();
                    if (voxelSize != null) {
                        double[] resolution = new double[voxelSize.numDimensions()];
                        voxelSize.dimensions(resolution);
                        n5.setAttribute(pathName, RESOLUTION_KEY, (Object)resolution);
                    }
                    int[][] downsamplingFactors2 = perSetupMipmapInfo.get(setupId3).getExportResolutions();
                    for (int l = 0; l < downsamplingFactors2.length; ++l) {
                        n5.setAttribute(BdvN5Format.getPathName(setupId3, timepointId, l), "downsamplingFactors", (Object)downsamplingFactors2[l]);
                    }
                }
            }
        }
        finally {
            executorService.shutdown();
        }
        progressWriter.setProgress(1.0);
    }

    static <T extends RealType<T> & NativeType<T>> void writeScalePyramid(N5Writer n5, Compression compression, BasicImgLoader imgLoader, int setupId, int timepointId, ExportMipmapInfo mipmapInfo, ExecutorService executorService, int numThreads, ExportScalePyramid.LoopbackHeuristic loopbackHeuristic, ExportScalePyramid.AfterEachPlane afterEachPlane, ProgressWriter progressWriter) throws IOException {
        BasicSetupImgLoader setupImgLoader = (BasicSetupImgLoader)Cast.unchecked((Object)imgLoader.getSetupImgLoader(setupId));
        RandomAccessibleInterval img = setupImgLoader.getImage(timepointId, new ImgLoaderHint[0]);
        RealType type = (RealType)setupImgLoader.getImageType();
        N5DatasetIO<RealType> io = new N5DatasetIO<RealType>(n5, compression, setupId, timepointId, type);
        ExportScalePyramid.writeScalePyramid(img, type, mipmapInfo, io, executorService, numThreads, loopbackHeuristic, afterEachPlane, progressWriter);
    }

    static class N5DatasetIO<T extends RealType<T> & NativeType<T>>
    implements ExportScalePyramid.DatasetIO<N5Dataset, T> {
        private final N5Writer n5;
        private final Compression compression;
        private final int setupId;
        private final int timepointId;
        private final DataType dataType;
        private final T type;

        public N5DatasetIO(N5Writer n5, Compression compression, int setupId, int timepointId, T type) {
            this.n5 = n5;
            this.compression = compression;
            this.setupId = setupId;
            this.timepointId = timepointId;
            this.dataType = DataTypeProperties.n5DataType((NativeType)type);
            this.type = type;
        }

        @Override
        public N5Dataset createDataset(int level, long[] dimensions, int[] blockSize) throws IOException {
            String pathName = BdvN5Format.getPathName(this.setupId, this.timepointId, level);
            try {
                this.n5.createDataset(pathName, dimensions, blockSize, this.dataType, this.compression);
            }
            catch (N5Exception e) {
                throw new IOException(e);
            }
            DatasetAttributes attributes = this.n5.getDatasetAttributes(pathName);
            return new N5Dataset(pathName, attributes);
        }

        @Override
        public void writeBlock(N5Dataset dataset, DataBlock<?> dataBlock) throws IOException {
            try {
                this.n5.writeBlock(dataset.pathName, dataset.attributes, dataBlock);
            }
            catch (N5Exception e) {
                throw new IOException(e);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public RandomAccessibleInterval<T> getImage(int level) throws IOException {
            DatasetAttributes attributes;
            String pathName = BdvN5Format.getPathName(this.setupId, this.timepointId, level);
            try {
                attributes = this.n5.getDatasetAttributes(pathName);
            }
            catch (N5Exception e) {
                throw new IOException(e);
            }
            long[] dimensions = attributes.getDimensions();
            int[] cellDimensions = attributes.getBlockSize();
            CellGrid grid = new CellGrid(dimensions, cellDimensions);
            SimpleCacheArrayLoader<?> cacheArrayLoader = N5ImageLoader.createCacheArrayLoader((N5Reader)this.n5, pathName);
            return new ReadOnlyCachedCellImgFactory().createWithCacheLoader(dimensions, (NativeType)this.type, key -> {
                int n = grid.numDimensions();
                long[] cellMin = new long[n];
                int[] cellDims = new int[n];
                long[] cellGridPosition = new long[n];
                grid.getCellDimensions(key.longValue(), cellMin, cellDims);
                grid.getCellGridPositionFlat(key.longValue(), cellGridPosition);
                return new Cell(cellDims, cellMin, cacheArrayLoader.loadArray(cellGridPosition, cellDims));
            }, (ReadOnlyCachedCellImgOptions)ReadOnlyCachedCellImgOptions.options().cellDimensions(cellDimensions));
        }
    }

    static class N5Dataset {
        final String pathName;
        final DatasetAttributes attributes;

        public N5Dataset(String pathName, DatasetAttributes attributes) {
            this.pathName = pathName;
            this.attributes = attributes;
        }
    }
}

