/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.detection;

import fiji.plugin.trackmate.detection.DetectionUtils;
import fiji.plugin.trackmate.detection.LogDetector;
import fiji.plugin.trackmate.detection.SpotDetector;
import fiji.plugin.trackmate.detection.SpotDetectorFactory;
import fiji.plugin.trackmate.detection.SpotDetectorFactoryGenericConfig;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.util.TMUtils;
import fiji.plugin.trackmate.util.cli.CommonTrackMateArguments;
import fiji.plugin.trackmate.util.cli.Configurator;
import fiji.plugin.trackmate.util.cli.HasInteractivePreview;
import ij.ImagePlus;
import java.util.Map;
import javax.swing.ImageIcon;
import net.imagej.ImgPlus;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Plugin;

@Plugin(type=SpotDetectorFactory.class)
public class LogDetectorFactory<T extends RealType<T> & NativeType<T>>
implements SpotDetectorFactory<T>,
SpotDetectorFactoryGenericConfig<T, LogDetectorCLI> {
    public static final String DETECTOR_KEY = "LOG_DETECTOR";
    public static final String NAME = "LoG detector";
    public static final String INFO_TEXT = "<html>This detector applies a LoG (Laplacian of Gaussian) filter <br>to the image, with a sigma suited to the blob estimated size. <br>Calculations are made in the Fourier space. The maxima in the <br>filtered image are searched for, and maxima too close from each <br>other are suppressed. A quadratic fitting scheme allows to do <br>sub-pixel localization. </html>";
    public static final ImageIcon ICON = new ImageIcon(Icons.class.getResource("images/LoG-icon-64px.png"));

    @Override
    public SpotDetector<T> getDetector(ImgPlus<T> img, Map<String, Object> settings, Interval interval, int frame) {
        double radius = (Double)settings.get("RADIUS");
        double threshold = (Double)settings.get("THRESHOLD");
        boolean doMedian = (Boolean)settings.get("DO_MEDIAN_FILTERING");
        boolean doSubpixel = (Boolean)settings.get("DO_SUBPIXEL_LOCALIZATION");
        double[] calibration = TMUtils.getSpatialCalibration(img);
        int channel = (Integer)settings.get("TARGET_CHANNEL") - 1;
        RandomAccessibleInterval<T> imFrame = DetectionUtils.prepareFrameImg(img, channel, frame);
        LogDetector<T> detector = new LogDetector<T>(imFrame, interval, calibration, radius, threshold, doSubpixel, doMedian);
        detector.setNumThreads(1);
        return detector;
    }

    @Override
    public String getKey() {
        return DETECTOR_KEY;
    }

    @Override
    public String getInfoText() {
        return INFO_TEXT;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public ImageIcon getIcon() {
        return ICON;
    }

    @Override
    public LogDetectorCLI getConfigurator(ImagePlus imp) {
        int nChannels = imp == null ? 1 : imp.getNChannels();
        String units = imp == null ? "no image" : imp.getCalibration().getUnit();
        return new LogDetectorCLI(nChannels, units);
    }

    public static class LogDetectorCLI
    extends Configurator
    implements HasInteractivePreview {
        public LogDetectorCLI(int nChannels, String units) {
            CommonTrackMateArguments.addTargetChannel(this, nChannels);
            CommonTrackMateArguments.addDiameter(this, units);
            CommonTrackMateArguments.addThreshold(this);
            CommonTrackMateArguments.addMedianFiltering(this);
            CommonTrackMateArguments.addSubpixelLocalization(this);
        }

        @Override
        public String getPreviewArgumentKey() {
            return "THRESHOLD";
        }
    }
}

