/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.visualization.hyperstack;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.SpotRoi;
import fiji.plugin.trackmate.detection.semiauto.SemiAutoTracker;
import fiji.plugin.trackmate.util.ModelTools;
import fiji.plugin.trackmate.util.TMUtils;
import fiji.plugin.trackmate.util.Threads;
import fiji.plugin.trackmate.util.TrackNavigator;
import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.FreehandRoi;
import ij.gui.ImageCanvas;
import ij.gui.Roi;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.jgrapht.graph.DefaultWeightedEdge;

public class ModelEditActions {
    static final double FALL_BACK_RADIUS = 5.0;
    private static final double COARSE_STEP = 2.0;
    private static final double FINE_STEP = (double)0.2f;
    private final Model model;
    private final SelectionModel selectionModel;
    private final Logger logger;
    private final ImagePlus imp;
    private Spot quickEditedSpot;
    private double previousRadius = 5.0;
    private FreehandRoi roiedit;
    private final TrackNavigator trackNavigator;

    public ModelEditActions(ImagePlus imp, Model model, SelectionModel selectionModel, Logger logger) {
        this.imp = imp;
        this.model = model;
        this.selectionModel = selectionModel;
        this.logger = logger;
        this.trackNavigator = new TrackNavigator(model, selectionModel);
    }

    private Spot makeSpot(Point mouseLocation) {
        ImageCanvas canvas = this.imp.getCanvas();
        if (mouseLocation == null) {
            mouseLocation = MouseInfo.getPointerInfo().getLocation();
            SwingUtilities.convertPointFromScreen(mouseLocation, (Component)canvas);
        }
        double[] calibration = TMUtils.getSpatialCalibration(this.imp);
        return new Spot((-0.5 + canvas.offScreenXD(mouseLocation.x)) * calibration[0], (-0.5 + canvas.offScreenYD(mouseLocation.y)) * calibration[1], (double)(this.imp.getSlice() - 1) * calibration[2], 5.0, -1.0);
    }

    private Spot getSpotAtMouseLocation() {
        Spot clickLocation = this.makeSpot(null);
        int frame = this.imp.getFrame() - 1;
        return this.model.getSpots().getSpotAt(clickLocation, frame, true);
    }

    private void updateStatusBar(Spot spot, String units) {
        if (null == spot) {
            return;
        }
        String statusString = "";
        statusString = null == spot.getName() || spot.getName().equals("") ? String.format(Locale.US, "Spot ID%d, x = %.1f, y = %.1f, z = %.1f, r = %.1f %s", spot.ID(), spot.getFeature("POSITION_X"), spot.getFeature("POSITION_Y"), spot.getFeature("POSITION_Z"), spot.getFeature("RADIUS"), units) : String.format(Locale.US, "Spot %s, x = %.1f, y = %.1f, z = %.1f, r = %.1f %s", spot.getName(), spot.getFeature("POSITION_X"), spot.getFeature("POSITION_Y"), spot.getFeature("POSITION_Z"), spot.getFeature("RADIUS"), units);
        IJ.showStatus((String)statusString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deleteSpotSelection() {
        ArrayList<Spot> spotSelection = new ArrayList<Spot>(this.selectionModel.getSpotSelection());
        ArrayList<DefaultWeightedEdge> edgeSelection = new ArrayList<DefaultWeightedEdge>(this.selectionModel.getEdgeSelection());
        this.model.beginUpdate();
        try {
            this.selectionModel.clearSelection();
            for (DefaultWeightedEdge edge : edgeSelection) {
                this.model.removeEdge(edge);
                this.logger.log("Removed edge " + String.valueOf(edge) + ".\n");
            }
            for (Spot spot : spotSelection) {
                this.model.removeSpot(spot);
                this.logger.log("Removed spot " + String.valueOf(spot) + ".\n");
            }
        }
        finally {
            this.model.endUpdate();
        }
    }

    public void semiAutoTracking(double qualityThreshold, double distanceTolerance, int nFrames) {
        this.logger.log("Semi-automatic tracking.\n");
        SemiAutoTracker autotracker = new SemiAutoTracker(this.model, this.selectionModel, this.imp, this.logger);
        autotracker.setParameters(qualityThreshold, distanceTolerance, nFrames);
        autotracker.setNumThreads(Prefs.getThreads() / 2);
        Threads.run("TrackMate semi-automated tracking thread", () -> {
            boolean ok;
            boolean bl = ok = autotracker.checkInput() && autotracker.process();
            if (!ok) {
                this.logger.error(autotracker.getErrorMessage());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSpot(boolean autoLinkingmode) {
        double radius = this.previousRadius;
        Spot newSpot = this.makeSpot(null);
        double dt = this.imp.getCalibration().frameInterval;
        int frame = this.imp.getFrame() - 1;
        newSpot.putFeature("POSITION_T", (double)frame * dt);
        newSpot.putFeature("FRAME", Double.valueOf(frame));
        newSpot.putFeature("RADIUS", radius);
        newSpot.putFeature("QUALITY", -1.0);
        this.model.beginUpdate();
        try {
            this.model.addSpotTo(newSpot, frame);
            this.logger.log("Added spot " + String.valueOf(newSpot) + " to frame " + frame + ".\n");
        }
        finally {
            this.model.endUpdate();
        }
        if (autoLinkingmode) {
            Spot source;
            Set<Spot> spotSelection = this.selectionModel.getSpotSelection();
            if (spotSelection.size() == 1 && newSpot.diffTo(source = spotSelection.iterator().next(), "FRAME") != 0.0) {
                this.model.beginUpdate();
                try {
                    this.model.addEdge(source, newSpot, -1.0);
                    this.logger.log("Created a link between " + String.valueOf(source) + " and " + String.valueOf(newSpot) + ".\n");
                }
                finally {
                    this.model.endUpdate();
                }
            }
            this.selectionModel.clearSpotSelection();
            this.selectionModel.addSpotToSelection(newSpot);
        }
    }

    public void deleteSpot() {
        Spot target = this.getSpotAtMouseLocation();
        if (null == target) {
            return;
        }
        this.selectionModel.removeSpotFromSelection(target);
        this.model.beginUpdate();
        try {
            this.model.removeSpot(target);
            this.logger.log("Removed spot " + String.valueOf(target) + ".\n");
        }
        finally {
            this.model.endUpdate();
        }
    }

    public void startMoveSpot() {
        if (null == this.quickEditedSpot) {
            this.quickEditedSpot = this.getSpotAtMouseLocation();
        }
    }

    public void moveSpot(Point mouseLocation) {
        if (this.quickEditedSpot == null) {
            return;
        }
        ImageCanvas canvas = this.imp.getCanvas();
        double[] calibration = TMUtils.getSpatialCalibration(this.imp);
        double x = (-0.5 + canvas.offScreenXD(mouseLocation.x)) * calibration[0];
        double y = (-0.5 + canvas.offScreenYD(mouseLocation.y)) * calibration[1];
        double z = (double)(this.imp.getSlice() - 1) * calibration[2];
        this.quickEditedSpot.putFeature("POSITION_X", x);
        this.quickEditedSpot.putFeature("POSITION_Y", y);
        this.quickEditedSpot.putFeature("POSITION_Z", z);
        this.imp.updateAndDraw();
    }

    public void endMoveSpot() {
        if (null == this.quickEditedSpot) {
            return;
        }
        this.model.beginUpdate();
        try {
            this.model.updateFeatures(this.quickEditedSpot);
        }
        finally {
            this.model.endUpdate();
        }
        this.quickEditedSpot = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeSpotRadius(boolean increase, boolean fast) {
        double newRadius;
        Spot target = this.getSpotAtMouseLocation();
        if (null == target) {
            return;
        }
        double radius = target.getFeature("RADIUS");
        int factor = increase ? 1 : -1;
        double dx = this.imp.getCalibration().pixelWidth;
        double d = newRadius = fast ? radius + (double)factor * dx * 2.0 : radius + (double)factor * dx * (double)0.2f;
        if (newRadius <= dx) {
            return;
        }
        this.previousRadius = newRadius;
        SpotRoi roi = target.getRoi();
        if (null == roi) {
            target.putFeature("RADIUS", newRadius);
        } else {
            double alpha = newRadius / radius;
            roi.scale(alpha);
            target.putFeature("RADIUS", roi.radius());
        }
        this.model.beginUpdate();
        try {
            this.model.updateFeatures(target);
            this.logger.log(String.format(Locale.US, "Changed spot " + String.valueOf(target) + " radius to %.1f " + this.model.getSpaceUnits() + ".\n", radius));
        }
        finally {
            this.model.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toggleLink() {
        Set<Spot> selectedSpots = this.selectionModel.getSpotSelection();
        if (selectedSpots.size() == 2) {
            Spot target;
            Spot targetTmp;
            Iterator<Spot> it = selectedSpots.iterator();
            Spot sourceTmp = it.next();
            Spot source = sourceTmp.diffTo(targetTmp = it.next(), "FRAME") < 0.0 ? sourceTmp : targetTmp;
            Spot spot = target = sourceTmp.diffTo(targetTmp, "FRAME") < 0.0 ? targetTmp : sourceTmp;
            if (this.model.getTrackModel().containsEdge(source, target)) {
                this.model.beginUpdate();
                try {
                    this.model.removeEdge(source, target);
                    this.logger.log("Removed edge between " + String.valueOf(source) + " and " + String.valueOf(target) + ".\n");
                }
                finally {
                    this.model.endUpdate();
                }
            }
            int ts = source.getFeature("FRAME").intValue();
            int tt = target.getFeature("FRAME").intValue();
            if (tt != ts) {
                this.model.beginUpdate();
                try {
                    this.model.addEdge(source, target, -1.0);
                    this.logger.log("Created an edge between " + String.valueOf(source) + " and " + String.valueOf(target) + ".\n");
                }
                finally {
                    this.model.endUpdate();
                }
                Spot single = tt > ts ? target : source;
                this.selectionModel.clearSpotSelection();
                this.selectionModel.addSpotToSelection(single);
            } else {
                this.logger.error("Cannot create an edge between two spots belonging to the same frame.\n");
            }
        } else {
            this.logger.error("Expected selection to contain 2 spots, found " + selectedSpots.size() + ".\n");
        }
    }

    public void stepInTime(boolean forward, int stepwiseTimeBrowsing) {
        int currentT = this.imp.getT() - 1;
        int prevStep = currentT / stepwiseTimeBrowsing * stepwiseTimeBrowsing;
        int tp = forward ? prevStep + stepwiseTimeBrowsing : (currentT == prevStep ? currentT - stepwiseTimeBrowsing : prevStep);
        this.imp.setT(tp + 1);
    }

    public void select(Point point, boolean addToSelection, boolean canClearSelection) {
        Spot target = this.getSpotAtMouseLocation();
        if (null == target) {
            if (canClearSelection) {
                this.selectionModel.clearSelection();
                this.logger.log("Cleared selection.\n");
            }
            this.roiedit = null;
            this.imp.setRoi((Roi)this.roiedit);
        } else {
            this.updateStatusBar(target, this.imp.getCalibration().getUnits());
            if (addToSelection) {
                if (this.selectionModel.getSpotSelection().contains(target)) {
                    this.selectionModel.removeSpotFromSelection(target);
                } else {
                    this.selectionModel.addSpotToSelection(target);
                }
            } else {
                this.selectionModel.clearSpotSelection();
                this.selectionModel.addSpotToSelection(target);
            }
        }
    }

    public void roiEdit(MouseEvent e) {
        if (null == this.roiedit) {
            if (!IJ.spaceBarDown()) {
                this.roiedit = new FreehandRoi(e.getX(), e.getY(), this.imp){
                    private static final long serialVersionUID = 1L;

                    protected void handleMouseUp(int screenX, int screenY) {
                        this.type = 3;
                        super.handleMouseUp(screenX, screenY);
                    }
                };
                this.imp.setRoi((Roi)this.roiedit);
            }
        } else {
            this.roiedit.mouseDragged(e);
        }
    }

    public void selectInRoi(MouseEvent e) {
        if (null != this.roiedit) {
            Threads.run("SpotEditTool roiedit processing", () -> {
                this.roiedit.mouseReleased(e);
                int frame = this.imp.getFrame() - 1;
                Iterator<Spot> it = IJ.shiftKeyDown() ? this.model.getSpots().iterator(true) : this.model.getSpots().iterator(frame, true);
                ArrayList<Spot> added = new ArrayList<Spot>();
                double[] calibration = TMUtils.getSpatialCalibration(this.imp);
                while (it.hasNext()) {
                    Spot spot = it.next();
                    double x = spot.getFeature("POSITION_X");
                    double y = spot.getFeature("POSITION_Y");
                    int xp = (int)(x / calibration[0] + 0.5);
                    int yp = (int)(y / calibration[1] + 0.5);
                    if (null == this.roiedit || !this.roiedit.contains(xp, yp)) continue;
                    added.add(spot);
                }
                if (!added.isEmpty()) {
                    this.selectionModel.addSpotToSelection(added);
                    if (added.size() == 1) {
                        this.logger.log("Added one spot to selection.\n");
                    } else {
                        this.logger.log("Added " + added.size() + " spots to selection.\n");
                    }
                }
                this.roiedit = null;
            });
        }
    }

    public void selectTrackDownward() {
        ModelTools.selectTrackDownward(this.selectionModel);
    }

    public void selectTrackUpward() {
        ModelTools.selectTrackUpward(this.selectionModel);
    }

    public void selectTrack() {
        ModelTools.selectTrack(this.selectionModel);
    }

    public void navigateToChild() {
        this.trackNavigator.nextInTime();
    }

    public void navigateToParent() {
        this.trackNavigator.previousInTime();
    }

    public void navigateToNextSibling() {
        this.trackNavigator.nextSibling();
    }

    public void navigateToPreviousSibling() {
        this.trackNavigator.previousSibling();
    }

    public void navigateToNextTrack() {
        this.trackNavigator.nextTrack();
    }

    public void navigateToPreviousTrack() {
        this.trackNavigator.previousTrack();
    }
}

