/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.meta;

import org.scijava.meta.Manifest;
import org.scijava.meta.POM;

public final class Versions {
    private Versions() {
    }

    public static String of(Class<?> c) {
        return Versions.of(c, null, null);
    }

    public static String of(Class<?> c, String groupId, String artifactId) {
        String version = Versions.fromManifest(c);
        if (version != null) {
            return version;
        }
        return Versions.fromPOM(c, groupId, artifactId);
    }

    public static String fromManifest(Class<?> c) {
        Manifest m = Manifest.manifest(c);
        return m == null ? null : m.version();
    }

    public static String fromPOM(Class<?> c, String groupId, String artifactId) {
        POM pom = POM.pom(c, groupId, artifactId);
        return pom == null ? null : pom.version();
    }

    public static String buildNumber(Class<?> c) {
        Manifest m = Manifest.manifest(c);
        return m == null ? null : m.implementationBuild();
    }

    public static int compare(String v1, String v2) {
        String[] t1 = Versions.splitDots(v1);
        String[] t2 = Versions.splitDots(v2);
        int count = Math.min(t1.length, t2.length);
        for (int t = 0; t < count; ++t) {
            int c = Versions.compareToken(t1[t], t2[t]);
            if (c == 0) continue;
            return c;
        }
        if (t1.length == t2.length) {
            return 0;
        }
        return t1.length < t2.length ? -1 : 1;
    }

    private static String[] splitDots(String s) {
        return s.isEmpty() ? new String[]{} : s.split("\\.", -1);
    }

    private static int compareToken(String t1, String t2) {
        int i1 = Versions.digitIndex(t1);
        int i2 = Versions.digitIndex(t2);
        String suffix1 = t1;
        String suffix2 = t2;
        if (i1 > 0 && i2 > 0) {
            long d2;
            long d1 = Long.parseLong(t1.substring(0, i1));
            if (d1 < (d2 = Long.parseLong(t2.substring(0, i2)))) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            suffix1 = t1.substring(i1);
            suffix2 = t2.substring(i2);
        }
        if (suffix1.isEmpty() && suffix2.isEmpty()) {
            return 0;
        }
        if (suffix1.isEmpty()) {
            return 1;
        }
        if (suffix2.isEmpty()) {
            return -1;
        }
        return suffix1.compareTo(suffix2);
    }

    private static int digitIndex(String s) {
        char ch;
        int index = 0;
        for (int i = 0; i < s.length() && (ch = s.charAt(index)) >= '0' && ch <= '9'; ++i) {
            ++index;
        }
        return index;
    }
}

