/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.indexer;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.scijava.ops.indexer.OpImplData;
import org.scijava.ops.indexer.OpParameter;
import org.scijava.ops.indexer.ProcessingUtils;

class OpMethodImplData
extends OpImplData {
    private static final Pattern COMPUTER_TYPE = Pattern.compile("[cC]omputer(\\d*)$");
    private static final Pattern INPLACE_TYPE = Pattern.compile("[iI]nplace(\\d+)$");

    public OpMethodImplData(ExecutableElement source, String doc, ProcessingEnvironment env) {
        super(source, doc, env);
        this.validateMethod(source);
    }

    private void validateMethod(ExecutableElement source) {
        if (!source.getModifiers().contains((Object)Modifier.PUBLIC)) {
            this.printError(source, " should be a public method!");
        }
        if (!source.getModifiers().contains((Object)Modifier.STATIC)) {
            this.printError(source, " should be a static method!");
        }
        int lastOpDependency = -1;
        List<? extends VariableElement> params = source.getParameters();
        for (int i = 0; i < params.size(); ++i) {
            if (!this.isDependency(params.get(i))) continue;
            if (i != lastOpDependency + 1) {
                this.printError(source, " declares Op dependencies after it declares parameters - all Op dependencies must come first!");
                break;
            }
            ++lastOpDependency;
        }
    }

    private boolean isDependency(VariableElement e) {
        return e.getAnnotationMirrors().stream().anyMatch(a -> a.toString().contains("OpDependency"));
    }

    @Override
    void parseAdditionalTags(Element source, List<String[]> additionalTags) {
        Optional<String[]> returnTag;
        ExecutableElement exSource = (ExecutableElement)source;
        ArrayList<VariableElement> opDependencies = new ArrayList<VariableElement>();
        Iterator<? extends VariableElement> paramItr = exSource.getParameters().iterator();
        for (String[] tag : additionalTags) {
            if (!"@param".equals(tag[0]) || this.paramIsTypeVariable(tag[1])) continue;
            VariableElement param = paramItr.next();
            if (this.isDependency(param)) {
                opDependencies.add(param);
                continue;
            }
            String name = param.getSimpleName().toString();
            String type = param.asType().toString();
            String remainder = tag[1];
            String description = remainder.contains(" ") ? remainder.substring(remainder.indexOf(" ")) : "";
            this.params.add(new OpParameter(name, type, ProcessingUtils.ioType(description), description, ProcessingUtils.isNullable(param, description)));
        }
        if (this.tags.containsKey("type")) {
            this.editIOIndex((String)this.tags.get("type"), this.params);
        }
        if (opDependencies.size() + this.params.size() != exSource.getParameters().size()) {
            this.printError(exSource, " does not have a matching @param tag for each of its parameters!");
        }
        if ((returnTag = additionalTags.stream().filter(t -> t[0].startsWith("@return")).findFirst()).isPresent()) {
            String totalTag = String.join((CharSequence)" ", returnTag.get());
            totalTag = totalTag.replaceFirst("[^\\s]+\\s", "");
            String returnType = exSource.getReturnType().toString();
            this.params.add(new OpParameter("output", returnType, OpParameter.IO_TYPE.OUTPUT, totalTag, false));
        }
        int totalOutputs = 0;
        for (OpParameter p : this.params) {
            if (p.ioType == OpParameter.IO_TYPE.INPUT) continue;
            ++totalOutputs;
        }
        if (totalOutputs > 1) {
            this.printError(exSource, " is only allowed to have 0 or 1 parameter outputs!");
        }
        if (!(exSource.getReturnType() instanceof NoType) && returnTag.isEmpty()) {
            this.printError(exSource, " has a return, but no @return parameter");
        }
    }

    private void editIOIndex(String type, List<OpParameter> params) {
        Matcher m = COMPUTER_TYPE.matcher(type);
        if (m.find()) {
            String idx = m.group(1);
            int ioIndex = idx.isEmpty() ? params.size() - 1 : Integer.parseInt(idx) - 1;
            params.get((int)ioIndex).ioType = OpParameter.IO_TYPE.CONTAINER;
            return;
        }
        m = INPLACE_TYPE.matcher(type);
        if (m.find()) {
            String idx = m.group(1);
            int ioIndex = Integer.parseInt(idx) - 1;
            params.get((int)ioIndex).ioType = OpParameter.IO_TYPE.MUTABLE;
        }
    }

    private void printError(ExecutableElement exSource, String msg) {
        Element clsElement = exSource.getEnclosingElement();
        while (clsElement.getKind() != ElementKind.CLASS) {
            clsElement = clsElement.getEnclosingElement();
        }
        this.env.getMessager().printMessage(Diagnostic.Kind.ERROR, clsElement + " - " + exSource + msg);
    }

    private boolean paramIsTypeVariable(String tag) {
        if (tag.charAt(0) != '<') {
            return false;
        }
        for (int i = 1; i < tag.length(); ++i) {
            char c = tag.charAt(i);
            if (Character.isLetter(c)) continue;
            return c == '>';
        }
        return false;
    }

    @Override
    protected String formulateSource(Element source) {
        ExecutableElement exSource = (ExecutableElement)source;
        StringBuilder sb = new StringBuilder();
        sb.append(source.getEnclosingElement());
        sb.append(".");
        sb.append(source.getSimpleName());
        List<? extends VariableElement> params = exSource.getParameters();
        sb.append("(");
        for (int i = 0; i < params.size(); ++i) {
            TypeMirror d = this.env.getTypeUtils().erasure(params.get(i).asType());
            sb.append(d);
            if (i >= params.size() - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        return "javaMethod:/" + URLEncoder.encode(sb.toString(), StandardCharsets.UTF_8);
    }
}

