/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.imglib2.AbstractWrappedRealInterval;
import net.imglib2.RandomAccessible;
import net.imglib2.blocks.Extension;
import net.imglib2.blocks.FallbackProperties;
import net.imglib2.blocks.PrimitiveBlocksUtils;
import net.imglib2.blocks.ViewNode;
import net.imglib2.blocks.ViewProperties;
import net.imglib2.blocks.ViewPropertiesOrError;
import net.imglib2.converter.AbstractConvertedRandomAccessible;
import net.imglib2.converter.Converter;
import net.imglib2.converter.read.ConvertedRandomAccessible;
import net.imglib2.converter.read.ConvertedRandomAccessibleInterval;
import net.imglib2.img.ImgView;
import net.imglib2.img.NativeImg;
import net.imglib2.img.WrappedImg;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.cell.AbstractCellImg;
import net.imglib2.img.planar.PlanarImg;
import net.imglib2.transform.integer.BoundingBox;
import net.imglib2.transform.integer.MixedTransform;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.util.Cast;
import net.imglib2.util.Intervals;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.IntervalView;
import net.imglib2.view.MixedTransformView;
import net.imglib2.view.fluent.RandomAccessibleView;

class ViewAnalyzer {
    private final RandomAccessible<?> ra;
    private final List<ViewNode> nodes = new ArrayList<ViewNode>();
    private final StringBuilder errorDescription = new StringBuilder();
    private int oobIndex = -1;
    private Extension oobExtension = null;
    private Supplier<? extends Converter<?, ?>> converterSupplier;
    private MixedTransform transform;
    private MixedTransform permuteInvertTransform;
    private MixedTransform remainderTransform;

    private ViewAnalyzer(RandomAccessible<?> ra) {
        this.ra = ra;
    }

    private <T extends Type<T>> boolean checkViewTypeSupported() {
        Type type = (Type)Cast.unchecked(this.ra.getType());
        if (type instanceof NativeType && ((NativeType)type).getEntitiesPerPixel().getRatio() == 1.0) {
            return true;
        }
        this.errorDescription.append("The pixel Type of the View must be a NativeType with entitiesPerPixel==1. (Found " + type.getClass().getSimpleName() + ")");
        return false;
    }

    private boolean analyze() {
        RandomAccessible<Object> source = this.ra;
        while (source != null) {
            Object view;
            if (source instanceof NativeImg) {
                view = (NativeImg)source;
                this.nodes.add(new ViewNode.DefaultViewNode(ViewNode.ViewType.NATIVE_IMG, (RandomAccessible<?>)view));
                source = null;
                continue;
            }
            if (source instanceof WrappedImg) {
                view = (WrappedImg)((Object)source);
                this.nodes.add(new ViewNode.DefaultViewNode(ViewNode.ViewType.IDENTITY, source));
                source = view.getImg();
                continue;
            }
            if (source instanceof ImgView) {
                view = (ImgView)source;
                this.nodes.add(new ViewNode.DefaultViewNode(ViewNode.ViewType.IDENTITY, (RandomAccessible<?>)view));
                source = (RandomAccessible)((AbstractWrappedRealInterval)view).getSource();
                continue;
            }
            if (source instanceof RandomAccessibleView) {
                view = (RandomAccessibleView)source;
                this.nodes.add(new ViewNode.DefaultViewNode(ViewNode.ViewType.IDENTITY, (RandomAccessible<?>)view));
                source = view.delegate();
                continue;
            }
            if (source instanceof IntervalView) {
                view = (IntervalView)source;
                this.nodes.add(new ViewNode.DefaultViewNode(ViewNode.ViewType.INTERVAL, (RandomAccessible<?>)view));
                source = ((IntervalView)view).getSource();
                continue;
            }
            if (source instanceof ConvertedRandomAccessible) {
                view = (ConvertedRandomAccessible)source;
                this.nodes.add(new ViewNode.ConverterViewNode(view));
                source = ((AbstractConvertedRandomAccessible)view).getSource();
                continue;
            }
            if (source instanceof ConvertedRandomAccessibleInterval) {
                view = (ConvertedRandomAccessibleInterval)source;
                this.nodes.add(new ViewNode.ConverterViewNode(view));
                source = (RandomAccessible)((AbstractWrappedRealInterval)view).getSource();
                continue;
            }
            if (source instanceof MixedTransformView) {
                view = (MixedTransformView)source;
                this.nodes.add(new ViewNode.MixedTransformViewNode((MixedTransformView<?>)view));
                source = ((MixedTransformView)view).getSource();
                continue;
            }
            if (source instanceof ExtendedRandomAccessibleInterval) {
                view = (ExtendedRandomAccessibleInterval)source;
                this.nodes.add(new ViewNode.ExtensionViewNode((ExtendedRandomAccessibleInterval<?, ?>)view));
                source = ((ExtendedRandomAccessibleInterval)view).getSource();
                continue;
            }
            this.errorDescription.append("Cannot analyze view " + source + " of class " + source.getClass().getSimpleName());
            return false;
        }
        return true;
    }

    private boolean checkRootSupported() {
        ViewNode root = this.nodes.get(this.nodes.size() - 1);
        if (root.viewType() != ViewNode.ViewType.NATIVE_IMG) {
            this.errorDescription.append("The root of the View sequence must be a NativeImg. (Found " + root.view() + " of class " + root.view().getClass().getSimpleName() + ")");
            return false;
        }
        if (root.view() instanceof PlanarImg || root.view() instanceof ArrayImg || root.view() instanceof AbstractCellImg) {
            return true;
        }
        this.errorDescription.append("The root of the View sequence must be PlanarImg, ArrayImg, or AbstractCellImg. (Found " + root.view() + " of class " + root.view().getClass().getSimpleName() + ")");
        return false;
    }

    private boolean checkRootTypeSupported() {
        ViewNode root = this.nodes.get(this.nodes.size() - 1);
        NativeType type = (NativeType)((NativeImg)root.view()).createLinkedType();
        if (type.getEntitiesPerPixel().getRatio() == 1.0) {
            return true;
        }
        this.errorDescription.append("The pixel Type of root of the View sequence must be a NativeType with entitiesPerPixel==1. (Found " + type.getClass().getSimpleName() + ")");
        return false;
    }

    private boolean checkExtensions1() {
        this.oobIndex = -1;
        for (int i = 0; i < this.nodes.size(); ++i) {
            if (this.nodes.get(i).viewType() != ViewNode.ViewType.EXTENSION) continue;
            if (this.oobIndex < 0) {
                this.oobIndex = i;
                continue;
            }
            this.errorDescription.append("There must be at most one out-of-bounds extension.");
            return false;
        }
        if (this.oobIndex >= 0) {
            ViewNode.ExtensionViewNode node = (ViewNode.ExtensionViewNode)this.nodes.get(this.oobIndex);
            this.oobExtension = Extension.of(node);
        }
        return true;
    }

    private boolean checkExtensions2() {
        if (this.oobIndex < 0) {
            return true;
        }
        if (this.oobExtension.type() != Extension.Type.UNKNOWN) {
            return true;
        }
        ViewNode.ExtensionViewNode node = (ViewNode.ExtensionViewNode)this.nodes.get(this.oobIndex);
        this.errorDescription.append("Only constant-value, border, mirror-single, mirror-double out-of-bounds extensions are supported. (Found " + node.getOutOfBoundsFactory().getClass().getSimpleName() + ")");
        return false;
    }

    private boolean checkExtensions3() {
        if (this.oobIndex < 0) {
            return true;
        }
        BoundingBox bbExtension = this.nodes.get(this.oobIndex + 1).bbox();
        BoundingBox bb = this.nodes.get(this.nodes.size() - 1).bbox();
        for (int i = this.nodes.size() - 1; i > this.oobIndex; --i) {
            ViewNode node = this.nodes.get(i);
            if (node.viewType() != ViewNode.ViewType.MIXED_TRANSFORM) continue;
            MixedTransform t = ((ViewNode.MixedTransformViewNode)node).getTransformToSource();
            bb = ViewAnalyzer.applyInverse(t, bb);
        }
        if (Intervals.equals(bb.getInterval(), bbExtension.getInterval())) {
            return true;
        }
        this.errorDescription.append("The interval at the out-of-bounds extension must be equal to the root interval carried through the transforms so far.");
        return false;
    }

    private static void applyInverse(MixedTransform transform, long[] source, long[] target) {
        assert (source.length >= transform.numSourceDimensions());
        assert (target.length >= transform.numTargetDimensions());
        Arrays.fill(source, 0, transform.numSourceDimensions(), 0L);
        for (int d = 0; d < transform.numTargetDimensions(); ++d) {
            if (transform.getComponentZero(d)) continue;
            long v = target[d] - transform.getTranslation(d);
            source[transform.getComponentMapping((int)d)] = transform.getComponentInversion(d) ? -v : v;
        }
    }

    private static BoundingBox applyInverse(MixedTransform transform, BoundingBox boundingBox) {
        assert (boundingBox.numDimensions() == transform.numTargetDimensions());
        if (transform.numSourceDimensions() == transform.numTargetDimensions()) {
            long[] tmp = new long[transform.numTargetDimensions()];
            boundingBox.corner1(tmp);
            ViewAnalyzer.applyInverse(transform, boundingBox.corner1, tmp);
            boundingBox.corner2(tmp);
            ViewAnalyzer.applyInverse(transform, boundingBox.corner2, tmp);
            return boundingBox;
        }
        BoundingBox b = new BoundingBox(transform.numSourceDimensions());
        ViewAnalyzer.applyInverse(transform, b.corner1, boundingBox.corner1);
        ViewAnalyzer.applyInverse(transform, b.corner2, boundingBox.corner2);
        return b;
    }

    private boolean checkConverters() {
        boolean dontConvertBeforeExtend = this.oobExtension != null && this.oobExtension.type().isValueDependent();
        ArrayList converterViewNodes = new ArrayList();
        for (int i = 0; i < this.nodes.size(); ++i) {
            ViewNode node = this.nodes.get(i);
            if (node.viewType() != ViewNode.ViewType.CONVERTER) continue;
            if (i > this.oobIndex && dontConvertBeforeExtend) {
                this.errorDescription.append("The out-of-bounds extension in the view sequence requires that no converter is applied before it.");
                return false;
            }
            converterViewNodes.add((ViewNode.ConverterViewNode)node);
        }
        if (!converterViewNodes.isEmpty()) {
            this.converterSupplier = ViewAnalyzer.accumulateConverters(converterViewNodes);
        }
        return true;
    }

    private static Supplier<? extends Converter<?, ?>> accumulateConverters(List<ViewNode.ConverterViewNode<?, ?>> nodes) {
        AccumulateConverters acc = new AccumulateConverters();
        for (int i = nodes.size() - 1; i >= 0; --i) {
            acc.append(nodes.get(i));
        }
        return acc.converterSupplier;
    }

    private boolean concatenateTransforms() {
        int n = this.ra.numDimensions();
        this.transform = new MixedTransform(n, n);
        for (ViewNode node : this.nodes) {
            if (node.viewType() != ViewNode.ViewType.MIXED_TRANSFORM) continue;
            ViewNode.MixedTransformViewNode tnode = (ViewNode.MixedTransformViewNode)node;
            this.transform = this.transform.preConcatenate(tnode.getTransformToSource());
        }
        return true;
    }

    private boolean checkNoDimensionsAdded() {
        if (this.transform.hasFullSourceMapping()) {
            return true;
        }
        this.errorDescription.append("All View dimensions must map to a dimension of the underlying NativeImg. That is Views.addDimension(...) is not allowed.");
        return false;
    }

    private boolean splitTransform() {
        MixedTransform[] split = PrimitiveBlocksUtils.split(this.transform);
        this.permuteInvertTransform = split[0];
        this.remainderTransform = split[1];
        return true;
    }

    private <T extends NativeType<T>, R extends NativeType<R>> ViewProperties<T, R> getViewProperties() {
        NativeType viewType = (NativeType)Cast.unchecked(this.ra.getType());
        int viewNumDimensions = this.ra.numDimensions();
        NativeImg root = (NativeImg)Cast.unchecked(this.nodes.get(this.nodes.size() - 1).view());
        NativeType rootType = (NativeType)root.createLinkedType();
        return new ViewProperties<NativeType, NativeType>(viewType, viewNumDimensions, root, rootType, this.oobExtension, this.transform, this.permuteInvertTransform, this.converterSupplier);
    }

    private <T extends NativeType<T>> FallbackProperties<T> getFallbackProperties() {
        RandomAccessible view = (RandomAccessible)Cast.unchecked(this.ra);
        return new FallbackProperties<NativeType>((NativeType)view.getType(), view);
    }

    public static <T extends NativeType<T>, R extends NativeType<R>> ViewPropertiesOrError<T, R> getViewProperties(RandomAccessible<T> view) {
        boolean fullySupported;
        ViewAnalyzer v = new ViewAnalyzer(view);
        boolean supportsFallback = v.checkViewTypeSupported();
        if (!supportsFallback) {
            return new ViewPropertiesOrError(null, null, v.errorDescription.toString());
        }
        boolean bl = fullySupported = v.analyze() && v.checkRootSupported() && v.checkRootTypeSupported() && v.checkExtensions1() && v.checkExtensions2() && v.checkExtensions3() && v.checkConverters() && v.concatenateTransforms() && v.checkNoDimensionsAdded() && v.splitTransform();
        if (!fullySupported) {
            String errorMessage = "The RandomAccessible " + view + " is only be supported through the fall-back implementation of PrimitiveBlocks. \n" + v.errorDescription;
            FallbackProperties<T> fallbackProperties = v.getFallbackProperties();
            return new ViewPropertiesOrError(null, fallbackProperties, errorMessage);
        }
        ViewProperties<T, R> viewProperties = v.getViewProperties();
        FallbackProperties<T> fallbackProperties = v.getFallbackProperties();
        return new ViewPropertiesOrError<T, R>(viewProperties, fallbackProperties, "");
    }

    private static class AccumulateConverters {
        private Supplier<? extends Converter<?, ?>> converterSupplier = null;
        private Supplier<?> destinationSupplier = null;

        private AccumulateConverters() {
        }

        private <A, B, C> void append(final ViewNode.ConverterViewNode<B, C> node) {
            if (this.converterSupplier == null) {
                this.converterSupplier = node.getConverterSupplier();
                this.destinationSupplier = node.getDestinationSupplier();
            } else {
                final Supplier<? extends Converter<?, ?>> pcs = this.converterSupplier;
                final Supplier<?> pds = this.destinationSupplier;
                this.converterSupplier = () -> new Converter<A, C>(){
                    final Converter cAB;
                    final Object b;
                    final Converter cBC;
                    {
                        this.cAB = (Converter)pcs.get();
                        this.b = pds.get();
                        this.cBC = node.getConverterSupplier().get();
                    }

                    @Override
                    public void convert(A a, C c) {
                        this.cAB.convert(a, this.b);
                        this.cBC.convert(this.b, c);
                    }
                };
                this.destinationSupplier = node.getDestinationSupplier();
            }
        }
    }
}

