/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.cell;

import net.imglib2.AbstractCursor;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.img.cell.AbstractCellImg;
import net.imglib2.img.cell.Cell;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.type.Index;
import net.imglib2.type.NativeType;

public class CellCursor<T extends NativeType<T>, C extends Cell<?>>
extends AbstractCursor<T>
implements AbstractCellImg.CellImgSampler<C> {
    protected final T type;
    protected final Index i;
    protected final Cursor<C> cursorOnCells;
    private final CellGrid grid;
    protected int lastIndexInCell;
    protected int typeIndex;
    protected boolean isNotLastCell;
    private C cell;
    private final long[] tmpIndices = new long[2];

    protected CellCursor(CellCursor<T, C> cursor) {
        super(cursor.numDimensions());
        this.type = cursor.type.duplicateTypeOnSameNativeImg();
        this.i = this.type.index();
        this.cursorOnCells = cursor.cursorOnCells.copy();
        this.grid = cursor.grid;
        this.lastIndexInCell = cursor.lastIndexInCell;
        this.typeIndex = cursor.typeIndex;
        this.isNotLastCell = cursor.isNotLastCell;
        this.type.updateContainer(this);
        this.i.set(this.typeIndex);
    }

    public CellCursor(AbstractCellImg<T, ?, C, ?> img) {
        super(img.numDimensions());
        this.type = img.createLinkedType();
        this.i = this.type.index();
        this.cursorOnCells = ((IterableInterval)img.getCells()).cursor();
        this.grid = img.getCellGrid();
        this.reset();
    }

    @Override
    public C getCell() {
        this.cell = (Cell)this.cursorOnCells.get();
        return this.cell;
    }

    @Override
    public T get() {
        return this.type;
    }

    @Override
    public T getType() {
        return this.type;
    }

    @Override
    public CellCursor<T, C> copy() {
        return new CellCursor<T, C>(this);
    }

    @Override
    public boolean hasNext() {
        return this.typeIndex < this.lastIndexInCell || this.isNotLastCell;
    }

    @Override
    public void jumpFwd(long steps) {
        long newIndex = (long)this.typeIndex + steps;
        if (newIndex <= (long)this.lastIndexInCell) {
            this.typeIndex = (int)newIndex;
            this.i.set(this.typeIndex);
        } else {
            this.grid.getIndicesFromGridPosition(this.cursorOnCells, this.tmpIndices);
            long gridIndexOfCurrentCell = this.tmpIndices[0];
            long indexOfFirstPixelInCurrentCell = this.tmpIndices[1];
            this.grid.getCellAndPixelIndices(newIndex + indexOfFirstPixelInCurrentCell, this.tmpIndices);
            long gridIndexOfNewCell = this.tmpIndices[0];
            int indexInNewCell = (int)this.tmpIndices[1];
            long cellSteps = gridIndexOfNewCell - gridIndexOfCurrentCell;
            this.cursorOnCells.jumpFwd(cellSteps);
            this.isNotLastCell = this.cursorOnCells.hasNext();
            this.lastIndexInCell = (int)(((Cell)this.getCell()).size() - 1L);
            this.typeIndex = indexInNewCell;
            this.i.set(this.typeIndex);
            this.type.updateContainer(this);
        }
    }

    @Override
    public void fwd() {
        if (++this.typeIndex > this.lastIndexInCell) {
            this.moveToNextCell();
            this.typeIndex = 0;
        }
        this.i.set(this.typeIndex);
    }

    @Override
    public void reset() {
        this.cursorOnCells.reset();
        this.moveToNextCell();
        this.i.set(this.typeIndex);
    }

    @Override
    public String toString() {
        return this.type.toString();
    }

    @Override
    public long getLongPosition(int dim) {
        return ((Cell)this.getCell()).indexToGlobalPosition(this.typeIndex, dim);
    }

    @Override
    public void localize(long[] position) {
        ((Cell)this.getCell()).indexToGlobalPosition(this.typeIndex, position);
    }

    private void moveToNextCell() {
        this.cursorOnCells.fwd();
        this.isNotLastCell = this.cursorOnCells.hasNext();
        this.lastIndexInCell = (int)(((Cell)this.getCell()).size() - 1L);
        this.typeIndex = -1;
        this.type.updateContainer(this);
    }
}

