/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.interpolation.neighborsearch;

import java.util.function.DoubleUnaryOperator;
import net.imglib2.KDTree;
import net.imglib2.RealPoint;
import net.imglib2.RealRandomAccess;
import net.imglib2.neighborsearch.RadiusNeighborSearch;
import net.imglib2.neighborsearch.RadiusNeighborSearchOnKDTree;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.NumericType;

public class RadialKDTreeInterpolator<T extends NumericType<T>>
extends RealPoint
implements RealRandomAccess<T> {
    protected static final double minThreshold = 4.94E-321;
    protected final RadiusNeighborSearch<T> search;
    protected final double maxRadius;
    protected final double maxSquaredRadius;
    protected final KDTree<T> tree;
    protected final T value;
    protected final T tmp;
    protected final DoubleUnaryOperator squaredRadiusFunction;

    public RadialKDTreeInterpolator(KDTree<T> tree, DoubleUnaryOperator squaredRadiusFunction, double maxRadius, T t) {
        super(tree.numDimensions());
        this.squaredRadiusFunction = squaredRadiusFunction;
        this.tree = tree;
        this.search = new RadiusNeighborSearchOnKDTree<T>(tree);
        this.maxRadius = maxRadius;
        this.maxSquaredRadius = maxRadius * maxRadius;
        this.value = (NumericType)t.copy();
        this.tmp = (NumericType)t.copy();
    }

    public double getMaxRadius() {
        return this.maxRadius;
    }

    @Override
    public T get() {
        this.value.setZero();
        this.search.search(this, this.maxRadius, false);
        if (this.search.numNeighbors() == 0) {
            return this.value;
        }
        for (int i = 0; i < this.search.numNeighbors(); ++i) {
            this.tmp.set((Type)((Type)this.search.getSampler(i).get()));
            this.tmp.mul(this.squaredRadiusFunction.applyAsDouble(this.search.getSquareDistance(i)));
            this.value.add(this.tmp);
        }
        return this.value;
    }

    @Override
    public RadialKDTreeInterpolator<T> copy() {
        return new RadialKDTreeInterpolator<T>(this.tree, this.squaredRadiusFunction, this.maxRadius, this.value);
    }

    @Override
    public RadialKDTreeInterpolator<T> copyRealRandomAccess() {
        return this.copy();
    }
}

