/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.loops;

import java.util.Arrays;
import java.util.List;
import net.imglib2.Dimensions;
import net.imglib2.Positionable;
import net.imglib2.loops.ClassCopyProvider;

public final class LoopUtils {
    private static ClassCopyProvider<Runnable> factory = new ClassCopyProvider<Runnable>(LineProcessor.class, Runnable.class, new Class[0]);

    private LoopUtils() {
    }

    public static Runnable createLineLoop(Positionable positionable, long length, int dimension, Runnable action) {
        List<Object> key = Arrays.asList(action.getClass());
        return factory.newInstanceForKey(key, action, positionable, length, dimension);
    }

    public static Runnable createIntervalLoop(Positionable positionable, Dimensions dimensions, Runnable action) {
        for (int i = 0; i < dimensions.numDimensions(); ++i) {
            long dimension = dimensions.dimension(i);
            if (dimension > 1L) {
                action = LoopUtils.createLineLoop(positionable, dimension, i, action);
                continue;
            }
            if (dimension > 0L) continue;
            action = () -> {};
        }
        return action;
    }

    public static class LineProcessor
    implements Runnable {
        private final Runnable action;
        private final Positionable positionable;
        private final long lineLength;
        private final int dimension;

        public LineProcessor(Runnable action, Positionable positionable, long length, int dimension) {
            this.action = action;
            this.positionable = positionable;
            this.lineLength = length;
            this.dimension = dimension;
        }

        @Override
        public void run() {
            for (long i = 0L; i < this.lineLength; ++i) {
                this.action.run();
                this.positionable.fwd(this.dimension);
            }
            this.positionable.move(-this.lineLength, this.dimension);
        }
    }
}

