/*
 * Decompiled with CFR 0.152.
 */
package ij3d.pointlist;

import ij.gui.GenericDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import vib.BenesNamedPoint;
import vib.PointList;

public class PointListPanel
extends Panel
implements ActionListener,
PointList.PointListListener {
    private PointList points;
    private GridBagConstraints c;
    private final PopupMenu popup = this.createPopup();
    private BenesNamedPoint current;
    private final DecimalFormat df = new DecimalFormat("00.000");
    private final String header;
    private final Color grey = Color.LIGHT_GRAY;

    public PointListPanel(String header, PointList points) {
        this.header = header;
        this.add(this.popup);
        this.points = points;
        points.addPointListListener((PointList.PointListListener)this);
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.WHITE);
        this.c = new GridBagConstraints();
        this.recreatePointsPanel();
    }

    public void setPointList(PointList pl) {
        this.points.removePointListListener((PointList.PointListListener)this);
        this.points = pl;
        this.points.addPointListListener((PointList.PointListListener)this);
        this.recreatePointsPanel();
    }

    private PopupMenu createPopup() {
        PopupMenu popup = new PopupMenu();
        MenuItem mi = new MenuItem("Up");
        mi.addActionListener(this);
        popup.add(mi);
        mi = new MenuItem("Down");
        mi.addActionListener(this);
        popup.add(mi);
        mi = new MenuItem("Rename");
        mi.addActionListener(this);
        popup.add(mi);
        mi = new MenuItem("Remove");
        mi.addActionListener(this);
        popup.add(mi);
        return popup;
    }

    private void recreatePointsPanel() {
        this.removeAll();
        this.c = new GridBagConstraints();
        this.addHeader();
        int i = 0;
        if (this.points.size() == 0) {
            this.addEmptyRow();
        }
        for (BenesNamedPoint p : this.points) {
            this.addRow(p, i++);
        }
        this.layoutWindow();
    }

    private void addHeader() {
        Label l = new Label(this.header);
        l.setFont(new Font("Verdana", 1, 12));
        this.c.gridy = 0;
        this.c.gridwidth = 2;
        this.c.gridx = 0;
        this.add((Component)l, this.c);
        this.c.gridwidth = 1;
    }

    private void addEmptyRow() {
        Label l = new Label("     No points set       ");
        this.c.gridx = 0;
        this.c.gridy = -1;
        this.c.anchor = 21;
        this.add((Component)l, this.c);
    }

    private void addRow(final BenesNamedPoint p, int row) {
        if (!p.isSet()) {
            return;
        }
        this.c.gridx = 0;
        this.c.gridy = -1;
        this.c.fill = 1;
        this.c.anchor = 21;
        final Label label = new Label(p.getName() + "   ");
        label.setName(p.getName());
        label.setFont(new Font("Verdana", 1, 12));
        label.setForeground(Color.BLUE);
        if (row % 2 == 0) {
            label.setBackground(this.grey);
        }
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    PointListPanel.this.current = p;
                    PointListPanel.this.popup.show(label, e.getX(), e.getY());
                } else {
                    PointListPanel.this.points.highlight(p);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    PointListPanel.this.current = p;
                    PointListPanel.this.popup.show(label, e.getX(), e.getY());
                }
            }
        });
        this.add((Component)label, this.c);
        this.c.anchor = 21;
        this.c.gridx = 1;
        this.c.fill = 1;
        Label coordinateLabel = new Label(this.df.format(p.x) + "    " + this.df.format(p.y) + "    " + this.df.format(p.z));
        coordinateLabel.setFont(new Font("Verdana", 0, 12));
        if (row % 2 == 0) {
            coordinateLabel.setBackground(this.grey);
        }
        this.add((Component)coordinateLabel, this.c);
    }

    private void layoutWindow() {
        Container pa;
        for (pa = this.getParent(); pa != null && !(pa instanceof Window); pa = pa.getParent()) {
        }
        if (pa != null) {
            pa.validate();
        }
    }

    public void renamePoint(BenesNamedPoint p) {
        GenericDialog gd = new GenericDialog("Rename point");
        gd.addStringField("New name ", p.getName());
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        this.points.rename(p, gd.getNextString());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("Rename")) {
            this.renamePoint(this.current);
        } else if (command.equals("Remove")) {
            this.points.remove(this.current);
        } else if (command.equals("Up")) {
            this.points.up(this.current);
        } else if (command.equals("Down")) {
            this.points.down(this.current);
        }
    }

    public void added(BenesNamedPoint p) {
        int i = this.points.size();
        if (i == 1) {
            this.recreatePointsPanel();
        } else {
            this.addRow(p, this.points.size() - 1);
            this.layoutWindow();
        }
    }

    public void removed(BenesNamedPoint p) {
        this.recreatePointsPanel();
    }

    public void renamed(BenesNamedPoint p) {
        this.recreatePointsPanel();
    }

    public void highlighted(BenesNamedPoint p) {
    }

    public void reordered() {
        this.recreatePointsPanel();
    }

    public void moved(BenesNamedPoint p) {
        Component[] c = this.getComponents();
        boolean found = false;
        for (int i = 0; i < c.length; ++i) {
            if (!c[i].getName().equals(p.getName()) || i >= c.length - 1) continue;
            Label coord = (Label)c[i + 1];
            coord.setText(this.df.format(p.x) + "    " + this.df.format(p.y) + "    " + this.df.format(p.z));
            found = true;
        }
        if (!found) {
            this.recreatePointsPanel();
        }
    }
}

