/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.metadata.imagej;

import java.util.Map;
import java.util.Objects;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.ScaleAndTranslation;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.universe.metadata.AbstractN5DatasetMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.SpatialMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.Axis;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.AxisMetadata;

public class N5ImagePlusMetadata
extends AbstractN5DatasetMetadata
implements SpatialMetadata,
AxisMetadata {
    public final String name;
    public final double fps;
    public final double frameInterval;
    public final double pixelWidth;
    public final double pixelHeight;
    public final double pixelDepth;
    public final double xOrigin;
    public final double yOrigin;
    public final double zOrigin;
    public final int numChannels;
    public final int numSlices;
    public final int numFrames;
    public final int type;
    public final String unit;
    public final Map<String, Object> properties;
    private transient Axis[] axes;

    public N5ImagePlusMetadata(String path, DatasetAttributes attributes, String name, double fps, double frameInterval, String unit, Double pixelWidth, Double pixelHeight, Double pixelDepth, Double xOrigin, Double yOrigin, Double zOrigin, Integer numChannels, Integer numSlices, Integer numFrames, Integer type, Map<String, Object> properties) {
        super(path, attributes);
        this.name = name;
        this.fps = Objects.requireNonNull(Double.valueOf(fps), "fps must be non null");
        this.frameInterval = Objects.requireNonNull(Double.valueOf(frameInterval), "frameInterval must be non null");
        this.unit = Objects.requireNonNull(unit, "unit must be non null");
        this.pixelWidth = Objects.requireNonNull(pixelWidth, "pixelWidth must be non null");
        this.pixelHeight = Objects.requireNonNull(pixelHeight, "pixelHeight must be non null");
        this.pixelDepth = Objects.requireNonNull(pixelDepth, "pixelDepth must be non null");
        this.xOrigin = Objects.requireNonNull(xOrigin, "xOrigin must be non null");
        this.yOrigin = Objects.requireNonNull(yOrigin, "yOrigin must be non null");
        this.zOrigin = Objects.requireNonNull(zOrigin, "zOrigin must be non null");
        this.numChannels = Objects.requireNonNull(numChannels, "numChannels must be non null");
        this.numSlices = Objects.requireNonNull(numSlices, "numSlices must be non null");
        this.numFrames = Objects.requireNonNull(numFrames, "numFrames must be non null");
        this.type = type == null ? -1 : type;
        this.properties = properties;
        this.axes = this.buildAxes();
    }

    private Axis[] buildAxes() {
        int nd = 2;
        if (this.numChannels > 1) {
            ++nd;
        }
        if (this.numSlices > 1) {
            ++nd;
        }
        if (this.numFrames > 1) {
            ++nd;
        }
        this.axes = new Axis[nd];
        this.axes[0] = new Axis("space", "x", this.unit);
        this.axes[1] = new Axis("space", "y", this.unit);
        int i = 2;
        if (this.numChannels > 1) {
            this.axes[i++] = new Axis("channel", "c", "");
        }
        if (this.numSlices > 1) {
            this.axes[i++] = new Axis("space", "z", this.unit);
        }
        if (this.numFrames > 1) {
            this.axes[i++] = new Axis("time", "t", "sec");
        }
        return this.axes;
    }

    public int getType() {
        return this.type;
    }

    public AffineGet spatialTransform() {
        int nd = this.numSlices > 1 ? 3 : 2;
        double[] spacing = new double[nd];
        double[] offset = new double[nd];
        spacing[0] = this.pixelWidth;
        spacing[1] = this.pixelHeight;
        if (this.numSlices > 1) {
            spacing[2] = this.pixelDepth;
        }
        offset[0] = this.xOrigin;
        offset[1] = this.yOrigin;
        if (this.numSlices > 1) {
            offset[2] = this.zOrigin;
        }
        return new ScaleAndTranslation(spacing, offset);
    }

    public String unit() {
        return this.unit;
    }

    public Axis[] getAxes() {
        return this.axes;
    }
}

