/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.coloc.saca;

import java.util.function.Function;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.histogram.Histogram1d;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.util.Intervals;
import net.imglib2.view.Views;
import org.scijava.function.Computers;
import org.scijava.ops.image.coloc.saca.AdaptiveSmoothedKendallTau;
import org.scijava.ops.spi.Nullable;
import org.scijava.ops.spi.OpDependency;

public class SACAHeatmapZScore<I extends RealType<I>>
implements Computers.Arity5<RandomAccessibleInterval<I>, RandomAccessibleInterval<I>, I, I, Long, RandomAccessibleInterval<DoubleType>> {
    @OpDependency(name="image.histogram")
    private Function<Iterable<I>, Histogram1d<I>> histOp;
    @OpDependency(name="threshold.otsu")
    private Function<Histogram1d<I>, I> otsuOp;

    public void compute(RandomAccessibleInterval<I> image1, RandomAccessibleInterval<I> image2, @Nullable I thres1, @Nullable I thres2, @Nullable Long seed, RandomAccessibleInterval<DoubleType> result) {
        FinalDimensions dims2;
        FinalDimensions dims1 = new FinalDimensions(image1.dimensionsAsLongArray());
        if (!Intervals.equalDimensions((Dimensions)dims1, (Dimensions)(dims2 = new FinalDimensions(image2.dimensionsAsLongArray())))) {
            throw new IllegalArgumentException("Input image dimensions do not match.");
        }
        if (image1.numDimensions() > 2 || image2.numDimensions() > 2) {
            throw new IllegalArgumentException("Only 2D images are supported by SACA. See https://github.com/scijava/scijava/issues/212");
        }
        if (seed == null) {
            seed = 3735928559L;
        }
        if (thres1 == null) {
            thres1 = (RealType)this.otsuOp.apply(this.histOp.apply((Iterable<I>)Views.iterable(image1)));
        }
        if (thres2 == null) {
            thres2 = (RealType)this.otsuOp.apply(this.histOp.apply((Iterable<I>)Views.iterable(image2)));
        }
        AdaptiveSmoothedKendallTau.execute(image1, image2, result, thres1, thres2, seed);
    }
}

